/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.inject;

import java.lang.reflect.Method;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.InjectorLogger;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public final class SetMethodInjector<T>
implements Injector<T> {
    private static final Object[] NULL_PARAM = new Object[]{null};
    private final Value<?> target;
    private final Value<Method> methodValue;

    public SetMethodInjector(Value<?> target, Value<Method> methodValue) {
        this.target = target;
        this.methodValue = methodValue;
    }

    public SetMethodInjector(Value<?> target, Method method) {
        this(target, new ImmediateValue<Method>(method));
    }

    public static <T> Injector<T> create(Value<?> target, Value<Method> methodValue) {
        return new SetMethodInjector<T>(target, methodValue);
    }

    public static <T> Injector<T> create(Value<?> target, Method method) {
        return new SetMethodInjector<T>(target, method);
    }

    public <C> SetMethodInjector(Value<? extends C> target, Class<C> clazz, String methodName, Class<T> paramType) {
        this(target, SetMethodInjector.lookupMethod(clazz, methodName, paramType));
    }

    public <C> SetMethodInjector(C target, Class<C> clazz, String methodName, Class<T> paramType) {
        this((C)new ImmediateValue<C>(target), clazz, methodName, paramType);
    }

    private static <C, T> Method lookupMethod(Class<C> clazz, String methodName, Class<T> paramType) {
        Method method;
        try {
            method = clazz.getMethod(methodName, paramType);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No such method found", e);
        }
        return method;
    }

    @Override
    public void inject(T value) {
        try {
            this.methodValue.getValue().invoke(this.target.getValue(), value);
        }
        catch (Exception e) {
            throw new InjectionException("Failed to inject value into method", e);
        }
    }

    @Override
    public void uninject() {
        try {
            this.methodValue.getValue().invoke(this.target.getValue(), NULL_PARAM);
        }
        catch (Exception e) {
            InjectorLogger.INSTANCE.uninjectFailed(e, this.methodValue);
        }
    }
}

