/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class EnvironmentPropertyValue
implements Value<String>,
PrivilegedAction<String> {
    private final String propertyName;
    private final AccessControlContext accessControlContext;
    private final Value<?> defaultValue;

    public EnvironmentPropertyValue(String propertyName) {
        this(propertyName, Values.nullValue());
    }

    public EnvironmentPropertyValue(String propertyName, AccessControlContext accessControlContext) {
        this(propertyName, accessControlContext, Values.nullValue());
    }

    public EnvironmentPropertyValue(String propertyName, Value<?> defaultValue) {
        this(propertyName, AccessController.getContext(), defaultValue);
    }

    public EnvironmentPropertyValue(String propertyName, AccessControlContext accessControlContext, Value<?> defaultValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName is null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue is null");
        }
        if (accessControlContext == null) {
            throw new IllegalArgumentException("accessControlContext is null");
        }
        this.propertyName = propertyName;
        this.accessControlContext = accessControlContext;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getValue() throws IllegalStateException {
        SecurityManager sm = System.getSecurityManager();
        String result = sm == null ? this.run() : AccessController.doPrivileged(this, this.accessControlContext);
        if (result != null) {
            return result;
        }
        Object value = this.defaultValue.getValue();
        return value != null ? value.toString() : null;
    }

    @Override
    public String run() {
        return System.getenv(this.propertyName);
    }
}

