/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Constructor;
import java.util.List;
import org.jboss.msc.value.Value;

public final class LookupConstructorValue
implements Value<Constructor> {
    private final Value<Class<?>> target;
    private final List<? extends Value<Class<?>>> parameterTypes;

    public LookupConstructorValue(Value<Class<?>> target, List<? extends Value<Class<?>>> parameterTypes) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("parameterTypes is null");
        }
        this.target = target;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public Constructor getValue() throws IllegalStateException {
        Class[] types = new Class[this.parameterTypes.size()];
        int i = 0;
        for (Value<Class<?>> type : this.parameterTypes) {
            types[i++] = type.getValue();
        }
        Class<?> targetClass = this.target.getValue();
        try {
            return targetClass.getConstructor(types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("No such constructor found on " + targetClass);
        }
    }
}

