/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueInjection;

public class ServiceLogger_$logger
implements Serializable,
ServiceLogger {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "MSC";
    private static final String FQCN = ServiceLogger_$logger.class.getName();
    protected final Logger log;
    private static final String internalServiceError = "An internal service error has occurred while processing an operation on %s";
    private static final String uncaughtException = "Worker thread %s threw an uncaught exception";
    private static final String stopFailed = "Failure during stop of %s";
    private static final String serviceNotStarted = "Service not started";
    private static final String mbeanFailed = "Failed to register MBean with MBeanServer";
    private static final String profileOutputCloseFailed = "An error occurred while trying to close the profile output file: %s";
    private static final String exceptionAfterComplete = "Exception thrown after start was already completed in %s";
    private static final String listenerFailed = "Invocation of listener \"%s\" failed";
    private static final String stopServiceMissing = "Unexpected disappearance of %s during stop";
    private static final String greeting = "JBoss MSC version %s";
    private static final String uninjectFailed = "Uninjection \"%2$s\" of %1$s failed unexpectedly";
    private static final String startFailed = "Failed to start %s";

    public ServiceLogger_$logger(Logger log) {
        this.log = log;
    }

    @Override
    public final void internalServiceError(Throwable cause, ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, "MSC000007: " + this.internalServiceError$str(), (Object)serviceName);
    }

    protected String internalServiceError$str() {
        return internalServiceError;
    }

    @Override
    public final void uncaughtException(Throwable cause, Thread thread) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, "MSC000008: " + this.uncaughtException$str(), (Object)thread);
    }

    protected String uncaughtException$str() {
        return uncaughtException;
    }

    @Override
    public final void stopFailed(Throwable cause, ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, "MSC000004: " + this.stopFailed$str(), (Object)serviceName);
    }

    protected String stopFailed$str() {
        return stopFailed;
    }

    @Override
    public final IllegalStateException serviceNotStarted() {
        IllegalStateException result = new IllegalStateException(String.format("MSC000011: " + this.serviceNotStarted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serviceNotStarted$str() {
        return serviceNotStarted;
    }

    @Override
    public final void mbeanFailed(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "MSC000010: " + this.mbeanFailed$str(), new Object[0]);
    }

    protected String mbeanFailed$str() {
        return mbeanFailed;
    }

    @Override
    public final void profileOutputCloseFailed(IOException cause) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "MSC000009: " + this.profileOutputCloseFailed$str(), (Object)cause);
    }

    protected String profileOutputCloseFailed$str() {
        return profileOutputCloseFailed;
    }

    @Override
    public final void exceptionAfterComplete(Throwable cause, ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, "MSC000003: " + this.exceptionAfterComplete$str(), (Object)serviceName);
    }

    protected String exceptionAfterComplete$str() {
        return exceptionAfterComplete;
    }

    public final void listenerFailed(Throwable cause, ServiceListener listener) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, "MSC000002: " + this.listenerFailed$str(), (Object)listener);
    }

    protected String listenerFailed$str() {
        return listenerFailed;
    }

    @Override
    public final void stopServiceMissing(ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "MSC000005: " + this.stopServiceMissing$str(), (Object)serviceName);
    }

    protected String stopServiceMissing$str() {
        return stopServiceMissing;
    }

    @Override
    public final void greeting(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.greeting$str(), (Object)version);
    }

    protected String greeting$str() {
        return greeting;
    }

    public final void uninjectFailed(Throwable cause, ServiceName serviceName, ValueInjection valueInjection) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, "MSC000006: " + this.uninjectFailed$str(), (Object)serviceName, (Object)valueInjection);
    }

    protected String uninjectFailed$str() {
        return uninjectFailed;
    }

    @Override
    public final void startFailed(StartException cause, ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, "MSC000001: " + this.startFailed$str(), (Object)serviceName);
    }

    protected String startFailed$str() {
        return startFailed;
    }
}

