/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceName;

class OptionalDependency
implements Dependency,
Dependent {
    private final Dependency optionalDependency;
    private DependencyState dependencyState;
    private boolean transitiveDependencyUnavailable = false;
    private boolean dependencyFailed = false;
    private Dependent dependent;
    private boolean demandedByDependent;
    boolean forwardNotifications;
    private boolean dependentStartedNotified = false;

    OptionalDependency(Dependency optionalDependency) {
        this.optionalDependency = optionalDependency;
        this.dependencyState = DependencyState.AVAILABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDependent(Dependent dependent) {
        boolean depFailed;
        boolean transDepUnavailable;
        DependencyState depState;
        boolean notifyDependent;
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(dependent));
        this.optionalDependency.addDependent(this);
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            if (this.dependent != null) {
                throw new IllegalStateException("Optional dependent is already set");
            }
            this.dependent = dependent;
            this.forwardNotifications = this.dependencyState.compareTo(DependencyState.AVAILABLE) >= 0;
            notifyDependent = this.forwardNotifications;
            depState = this.dependencyState;
            transDepUnavailable = this.transitiveDependencyUnavailable;
            depFailed = this.dependencyFailed;
        }
        if (notifyDependent) {
            if (depState == DependencyState.UP) {
                dependent.immediateDependencyUp();
            }
            if (transDepUnavailable) {
                dependent.transitiveDependencyUnavailable();
            }
            if (depFailed) {
                dependent.dependencyFailed();
            }
        } else {
            dependent.immediateDependencyUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDependent(Dependent dependent) {
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(dependent));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            dependent = null;
            this.forwardNotifications = false;
        }
        this.optionalDependency.removeDependent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDemand() {
        boolean notifyOptionalDependency;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.demandedByDependent = true;
            notifyOptionalDependency = this.forwardNotifications;
        }
        if (notifyOptionalDependency) {
            this.optionalDependency.addDemand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDemand() {
        boolean startNotifying;
        boolean notifyOptionalDependency;
        boolean depFailed;
        boolean transDepUnavailable;
        DependencyState depState;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.demandedByDependent = false;
            depState = this.dependencyState;
            transDepUnavailable = this.transitiveDependencyUnavailable;
            depFailed = this.dependencyFailed;
            if (this.forwardNotifications) {
                notifyOptionalDependency = true;
                startNotifying = false;
            } else {
                notifyOptionalDependency = false;
                this.forwardNotifications = this.dependencyState.compareTo(DependencyState.AVAILABLE) >= 0;
                startNotifying = this.forwardNotifications;
            }
        }
        if (startNotifying) {
            if (depState == DependencyState.AVAILABLE) {
                this.dependent.immediateDependencyDown();
            }
            if (transDepUnavailable) {
                this.dependent.transitiveDependencyUnavailable();
            }
            if (depFailed) {
                this.dependent.dependencyFailed();
            }
        } else if (notifyOptionalDependency) {
            this.optionalDependency.removeDemand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependentStarted() {
        boolean notifyOptionalDependency;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.dependentStartedNotified = notifyOptionalDependency = this.forwardNotifications;
        }
        if (notifyOptionalDependency) {
            this.optionalDependency.dependentStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependentStopped() {
        boolean notifyOptionalDependency;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            notifyOptionalDependency = this.forwardNotifications && this.dependentStartedNotified;
            this.dependentStartedNotified = false;
        }
        if (notifyOptionalDependency) {
            this.optionalDependency.dependentStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() throws IllegalStateException {
        boolean retrieveValue;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            retrieveValue = this.forwardNotifications;
        }
        return retrieveValue ? this.optionalDependency.getValue() : null;
    }

    @Override
    public ServiceName getName() {
        return this.optionalDependency.getName();
    }

    @Override
    public ServiceControllerImpl<?> getDependencyController() {
        return this.optionalDependency.getDependencyController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyAvailable(ServiceName dependencyName) {
        boolean notifyOptionalDependent;
        boolean startNotifying;
        boolean depFailed;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            depFailed = this.dependencyFailed;
            startNotifying = !this.forwardNotifications;
            this.dependencyState = DependencyState.AVAILABLE;
            notifyOptionalDependent = !this.demandedByDependent && this.dependent != null;
            this.forwardNotifications = notifyOptionalDependent;
        }
        if (notifyOptionalDependent) {
            this.dependent.immediateDependencyDown();
            if (startNotifying && depFailed) {
                this.dependent.dependencyFailed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyUnavailable(ServiceName dependencyName) {
        boolean demandNotified;
        boolean notificationsForwarded;
        boolean depFailed;
        boolean transitiveDepUnavailable;
        DependencyState depState;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            depState = this.dependencyState;
            transitiveDepUnavailable = this.transitiveDependencyUnavailable;
            depFailed = this.dependencyFailed;
            notificationsForwarded = this.forwardNotifications;
            this.forwardNotifications = false;
            this.dependencyState = DependencyState.UNAVAILABLE;
            demandNotified = this.demandedByDependent;
        }
        if (notificationsForwarded) {
            if (depState == DependencyState.AVAILABLE) {
                this.dependent.immediateDependencyUp();
            }
            if (depFailed) {
                this.dependent.dependencyFailureCleared();
            }
            if (transitiveDepUnavailable) {
                this.dependent.transitiveDependencyAvailable();
            }
            if (demandNotified) {
                this.optionalDependency.removeDemand();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyUp() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.dependencyState = DependencyState.UP;
            notifyOptionalDependent = this.forwardNotifications;
        }
        if (notifyOptionalDependent) {
            this.dependent.immediateDependencyUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyDown() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            this.dependencyState = DependencyState.AVAILABLE;
            notifyOptionalDependent = this.forwardNotifications;
        }
        if (notifyOptionalDependent) {
            this.dependent.immediateDependencyDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyFailed() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            notifyOptionalDependent = this.forwardNotifications;
            this.dependencyFailed = true;
        }
        if (notifyOptionalDependent) {
            this.dependent.dependencyFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyFailureCleared() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            notifyOptionalDependent = this.forwardNotifications;
            this.dependencyFailed = false;
        }
        if (notifyOptionalDependent) {
            this.dependent.dependencyFailureCleared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transitiveDependencyAvailable() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            notifyOptionalDependent = this.forwardNotifications;
            this.transitiveDependencyUnavailable = false;
        }
        if (notifyOptionalDependent) {
            this.dependent.transitiveDependencyAvailable();
        }
    }

    @Override
    public ServiceControllerImpl<?> getController() {
        return this.dependent.getController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transitiveDependencyUnavailable() {
        boolean notifyOptionalDependent;
        assert (!Thread.holdsLock(this));
        OptionalDependency optionalDependency = this;
        synchronized (optionalDependency) {
            notifyOptionalDependent = this.forwardNotifications;
            this.transitiveDependencyUnavailable = true;
        }
        if (notifyOptionalDependent) {
            this.dependent.transitiveDependencyUnavailable();
        }
    }

    private static enum DependencyState {
        UNAVAILABLE,
        AVAILABLE,
        UP;

    }
}

