/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.StabilityStatistics;

public final class StabilityMonitor {
    private final Object stabilityLock = new Object();
    private final Object controllersLock = new Object();
    private final Set<ServiceController<?>> problems = new IdentityHashSet();
    private final Set<ServiceController<?>> failed = new IdentityHashSet();
    private final AtomicBoolean cleanupInProgress = new AtomicBoolean();
    private Set<ServiceControllerImpl<?>> controllers = new IdentityHashSet();
    private int unstableServices;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addController(ServiceController<?> controller) {
        if (controller == null) {
            return;
        }
        ServiceControllerImpl serviceController = (ServiceControllerImpl)controller;
        Object object = this.controllersLock;
        synchronized (object) {
            serviceController.addMonitor(this);
            this.controllers.add(serviceController);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeController(ServiceController<?> controller) {
        if (controller == null) {
            return;
        }
        ServiceControllerImpl serviceController = (ServiceControllerImpl)controller;
        Object object = this.controllersLock;
        synchronized (object) {
            serviceController.removeMonitor(this);
            this.controllers.remove(serviceController);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.cleanupInProgress.compareAndSet(false, true)) {
            Object object = this.controllersLock;
            synchronized (object) {
                Set<ServiceControllerImpl<?>> controllers;
                Object object2 = this.stabilityLock;
                synchronized (object2) {
                    controllers = this.controllers;
                    this.controllers = new IdentityHashSet();
                    this.failed.clear();
                    this.problems.clear();
                    this.unstableServices = 0;
                }
                for (ServiceControllerImpl<?> controller : controllers) {
                    controller.removeMonitorNoCallback(this);
                }
            }
            this.cleanupInProgress.set(false);
        }
    }

    public void awaitStability() throws InterruptedException {
        this.awaitStability(null, null, null);
    }

    public void awaitStability(StabilityStatistics statistics) throws InterruptedException {
        this.awaitStability(null, null, statistics);
    }

    public boolean awaitStability(long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitStability(timeout, unit, null, null, null);
    }

    public boolean awaitStability(long timeout, TimeUnit unit, StabilityStatistics statistics) throws InterruptedException {
        return this.awaitStability(timeout, unit, null, null, statistics);
    }

    public void awaitStability(Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problems) throws InterruptedException {
        this.awaitStability(failed, problems, null);
    }

    public boolean awaitStability(long timeout, TimeUnit unit, Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problems) throws InterruptedException {
        return this.awaitStability(timeout, unit, failed, problems, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitStability(Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problems, StabilityStatistics statistics) throws InterruptedException {
        int problemsCount;
        int failedCount;
        Object object = this.stabilityLock;
        synchronized (object) {
            while (this.unstableServices != 0) {
                this.stabilityLock.wait();
            }
            if (failed != null) {
                failed.addAll(this.failed);
            }
            failedCount = this.failed.size();
            if (problems != null) {
                problems.addAll(this.problems);
            }
            problemsCount = this.problems.size();
        }
        this.provideStatistics(failedCount, problemsCount, statistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitStability(long timeout, TimeUnit unit, Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problems, StabilityStatistics statistics) throws InterruptedException {
        int problemsCount;
        int failedCount;
        long now = System.nanoTime();
        long remaining = unit.toNanos(timeout);
        Object object = this.stabilityLock;
        synchronized (object) {
            while (this.unstableServices != 0) {
                if (remaining <= 0L) {
                    return false;
                }
                this.stabilityLock.wait(remaining / 1000000L, (int)(remaining % 1000000L));
                long l = -now;
                now = System.nanoTime();
                remaining -= l + now;
            }
            if (failed != null) {
                failed.addAll(this.failed);
            }
            failedCount = this.failed.size();
            if (problems != null) {
                problems.addAll(this.problems);
            }
            problemsCount = this.problems.size();
        }
        this.provideStatistics(failedCount, problemsCount, statistics);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProblem(ServiceController<?> controller) {
        assert (Thread.holdsLock(controller));
        if (this.cleanupInProgress.get()) {
            return;
        }
        Object object = this.stabilityLock;
        synchronized (object) {
            this.problems.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProblem(ServiceController<?> controller) {
        assert (Thread.holdsLock(controller));
        if (this.cleanupInProgress.get()) {
            return;
        }
        Object object = this.stabilityLock;
        synchronized (object) {
            this.problems.remove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailed(ServiceController<?> controller) {
        assert (Thread.holdsLock(controller));
        if (this.cleanupInProgress.get()) {
            return;
        }
        Object object = this.stabilityLock;
        synchronized (object) {
            this.failed.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFailed(ServiceController<?> controller) {
        assert (Thread.holdsLock(controller));
        if (this.cleanupInProgress.get()) {
            return;
        }
        Object object = this.stabilityLock;
        synchronized (object) {
            this.failed.remove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementUnstableServices() {
        if (this.cleanupInProgress.get()) {
            return;
        }
        Object object = this.stabilityLock;
        synchronized (object) {
            ++this.unstableServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementUnstableServices() {
        if (this.cleanupInProgress.get()) {
            return;
        }
        Object object = this.stabilityLock;
        synchronized (object) {
            if (--this.unstableServices == 0) {
                this.stabilityLock.notifyAll();
            }
            assert (this.unstableServices >= 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void provideStatistics(int failedCount, int problemsCount, StabilityStatistics statistics) {
        Set<ServiceControllerImpl<?>> controllers;
        assert (!Thread.holdsLock(this.stabilityLock));
        assert (!Thread.holdsLock(this.controllersLock));
        if (statistics == null) {
            return;
        }
        Object object = this.controllersLock;
        synchronized (object) {
            controllers = this.controllers;
        }
        int active = 0;
        int lazy = 0;
        int onDemand = 0;
        int never = 0;
        int passive = 0;
        int started = 0;
        int remove = 0;
        for (ServiceControllerImpl<?> controller : controllers) {
            if (controller.getState() == ServiceController.State.UP) {
                ++started;
            }
            if (controller.getMode() == ServiceController.Mode.ACTIVE) {
                ++active;
                continue;
            }
            if (controller.getMode() == ServiceController.Mode.PASSIVE) {
                ++passive;
                continue;
            }
            if (controller.getMode() == ServiceController.Mode.ON_DEMAND) {
                ++onDemand;
                continue;
            }
            if (controller.getMode() == ServiceController.Mode.NEVER) {
                ++never;
                continue;
            }
            if (controller.getMode() == ServiceController.Mode.LAZY) {
                ++lazy;
                continue;
            }
            if (controller.getMode() != ServiceController.Mode.REMOVE) continue;
            ++remove;
        }
        statistics.setActiveCount(active);
        statistics.setFailedCount(failedCount);
        statistics.setLazyCount(lazy);
        statistics.setOnDemandCount(onDemand);
        statistics.setNeverCount(never);
        statistics.setPassiveCount(passive);
        statistics.setProblemsCount(problemsCount);
        statistics.setStartedCount(started);
        statistics.setRemovedCount(remove);
    }
}

