/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueInjection;

@MessageLogger(projectCode="MSC")
interface ServiceLogger {
    public static final ServiceLogger ROOT = (ServiceLogger)Logger.getMessageLogger(ServiceLogger.class, (String)"org.jboss.msc");
    public static final ServiceLogger SERVICE = (ServiceLogger)Logger.getMessageLogger(ServiceLogger.class, (String)"org.jboss.msc.service");
    public static final ServiceLogger FAIL = (ServiceLogger)Logger.getMessageLogger(ServiceLogger.class, (String)"org.jboss.msc.service.fail");

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="JBoss MSC version %s")
    public void greeting(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Failed to start %s")
    public void startFailed(@Cause StartException var1, ServiceName var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Invocation of listener \"%s\" failed")
    public void listenerFailed(@Cause Throwable var1, ServiceListener<?> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="Exception thrown after start was already completed in %s")
    public void exceptionAfterComplete(@Cause Throwable var1, ServiceName var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Failure during stop of %s")
    public void stopFailed(@Cause Throwable var1, ServiceName var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Unexpected disappearance of %s during stop")
    public void stopServiceMissing(ServiceName var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Uninjection \"%2$s\" of %1$s failed unexpectedly")
    public void uninjectFailed(@Cause Throwable var1, ServiceName var2, ValueInjection<?> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="An internal service error has occurred while processing an operation on %s")
    public void internalServiceError(@Cause Throwable var1, ServiceName var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Worker thread %s threw an uncaught exception")
    public void uncaughtException(@Cause Throwable var1, Thread var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="An error occurred while trying to close the profile output file: %s")
    public void profileOutputCloseFailed(IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Failed to register MBean with MBeanServer")
    public void mbeanFailed(@Cause Exception var1);

    @Message(id=11, value="Service not started")
    public IllegalStateException serviceNotStarted();
}

