/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

abstract class Lockable {
    private int readLocksCount;

    Lockable() {
    }

    final void acquireRead() {
        assert (Thread.holdsLock(this));
        ++this.readLocksCount;
    }

    final void releaseRead() {
        assert (Thread.holdsLock(this));
        if (--this.readLocksCount == 0) {
            this.notify();
        }
    }

    final void acquireWrite() {
        assert (Thread.holdsLock(this));
        if (this.readLocksCount > 0) {
            boolean intr = Thread.interrupted();
            try {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignored) {
                        intr = true;
                    }
                } while (this.readLocksCount > 0);
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    final void releaseWrite() {
        assert (Thread.holdsLock(this));
        this.notify();
    }

    final boolean isWriteLocked() {
        return Thread.holdsLock(this) && this.readLocksCount == 0;
    }
}

