/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.msc.service.ContainerShutdownListener;
import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Lockable;
import org.jboss.msc.service.SecurityUtils;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceBuilderImpl;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistrationImpl;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.management.ServiceStatus;
import org.jboss.msc.value.Value;

final class ServiceControllerImpl<S>
implements ServiceController<S>,
Dependent {
    private static final String ILLEGAL_CONTROLLER_STATE = "Illegal controller state";
    private static final int DEPENDENCY_AVAILABLE_TASK = 1;
    private static final int DEPENDENCY_UNAVAILABLE_TASK = 2;
    private static final int DEPENDENCY_STARTED_TASK = 4;
    private static final int DEPENDENCY_STOPPED_TASK = 8;
    private static final int DEPENDENCY_FAILED_TASK = 16;
    private static final int DEPENDENCY_RETRYING_TASK = 32;
    private final Value<? extends Service<S>> serviceValue;
    private final Dependency[] dependencies;
    private final ValueInjection<?>[] injections;
    private final ValueInjection<?>[] outInjections;
    private final IdentityHashSet<ServiceListener<? super S>> listeners;
    private final IdentityHashSet<LifecycleListener> lifecycleListeners;
    private ContainerShutdownListener shutdownListener;
    private final IdentityHashSet<StabilityMonitor> monitors;
    private final ServiceRegistrationImpl primaryRegistration;
    private final ServiceRegistrationImpl[] aliasRegistrations;
    private final ServiceControllerImpl<?> parent;
    private final IdentityHashSet<ServiceControllerImpl<?>> children;
    private final IdentityHashSet<ServiceName> unavailableDependencies;
    private StartException startException;
    private ServiceController.Mode mode = ServiceController.Mode.NEVER;
    private ServiceController.Substate state = ServiceController.Substate.NEW;
    private int execFlags;
    private int demandedByCount;
    private int stoppingDependencies;
    private int runningDependents;
    private int failCount;
    private boolean dependenciesDemanded = false;
    private int asyncTasks;
    private final List<Runnable> listenerTransitionTasks = new ArrayList<Runnable>();
    private volatile ChildServiceTarget childTarget;
    private volatile long lifecycleTime;
    private static final String[] NO_STRINGS = new String[0];
    static final int MAX_DEPENDENCIES = 16383;
    private static final ServiceName[] NO_NAMES = new ServiceName[0];

    ServiceControllerImpl(Value<? extends Service<S>> serviceValue, Dependency[] dependencies, ValueInjection<?>[] injections, ValueInjection<?>[] outInjections, ServiceRegistrationImpl primaryRegistration, ServiceRegistrationImpl[] aliasRegistrations, Set<StabilityMonitor> monitors, Set<? extends ServiceListener<? super S>> listeners, Set<LifecycleListener> lifecycleListeners, ServiceControllerImpl<?> parent) {
        assert (dependencies.length <= 16383);
        this.serviceValue = serviceValue;
        this.dependencies = dependencies;
        this.injections = injections;
        this.outInjections = outInjections;
        this.primaryRegistration = primaryRegistration;
        this.aliasRegistrations = aliasRegistrations;
        this.listeners = new IdentityHashSet<ServiceListener<S>>(listeners);
        this.lifecycleListeners = new IdentityHashSet<LifecycleListener>(lifecycleListeners);
        this.monitors = new IdentityHashSet<StabilityMonitor>(monitors);
        for (StabilityMonitor monitor : monitors) {
            monitor.addControllerNoCallback(this);
        }
        this.parent = parent;
        int depCount = dependencies.length;
        this.stoppingDependencies = parent == null ? depCount : depCount + 1;
        this.children = new IdentityHashSet();
        this.unavailableDependencies = new IdentityHashSet();
    }

    ServiceController.Substate getSubstateLocked() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startInstallation() {
        Object lock = this.primaryRegistration.getLock();
        ServiceRegistrationImpl[] serviceRegistrationImplArray = lock;
        synchronized (lock) {
            ((Lockable)lock).acquireWrite();
            try {
                this.primaryRegistration.setInstance(this);
            }
            finally {
                ((Lockable)lock).releaseWrite();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            for (ServiceRegistrationImpl aliasRegistration : this.aliasRegistrations) {
                Object object = lock = aliasRegistration.getLock();
                synchronized (object) {
                    ((Lockable)lock).acquireWrite();
                    try {
                        aliasRegistration.setInstance(this);
                    }
                    finally {
                        ((Lockable)lock).releaseWrite();
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startConfiguration() {
        Lockable lock;
        for (Dependency dependency : this.dependencies) {
            Lockable lockable = lock = dependency.getLock();
            synchronized (lockable) {
                lock.acquireWrite();
                try {
                    dependency.addDependent(this);
                }
                finally {
                    lock.releaseWrite();
                }
            }
        }
        if (this.parent != null) {
            Lockable lockable = lock = this.parent.primaryRegistration.getLock();
            synchronized (lockable) {
                lock.acquireWrite();
                try {
                    this.parent.addChild(this);
                }
                finally {
                    lock.releaseWrite();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitInstallation(ServiceController.Mode initialMode) {
        List<Runnable> tasks;
        assert (this.state == ServiceController.Substate.NEW);
        assert (initialMode != null);
        assert (!Thread.holdsLock(this));
        ArrayList<Runnable> listenerAddedTasks = new ArrayList<Runnable>();
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.getServiceContainer().isShutdown()) {
                throw new IllegalStateException("Container is down");
            }
            boolean leavingRestState = this.isStableRestState();
            this.getListenerTasks(ListenerNotification.LISTENER_ADDED, listenerAddedTasks);
            this.internalSetMode(initialMode);
            this.addAsyncTasks(listenerAddedTasks.size());
            this.updateStabilityState(leavingRestState);
        }
        for (Runnable listenerAddedTask : listenerAddedTasks) {
            listenerAddedTask.run();
        }
        ServiceControllerImpl serviceControllerImpl2 = this;
        synchronized (serviceControllerImpl2) {
            if (this.getServiceContainer().isShutdown()) {
                throw new IllegalStateException("Container is down");
            }
            boolean leavingRestState = this.isStableRestState();
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackInstallation() {
        RemoveTask removeTask;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            this.mode = ServiceController.Mode.REMOVE;
            this.state = ServiceController.Substate.CANCELLED;
            removeTask = new RemoveTask();
            this.incrementAsyncTasks();
            this.updateStabilityState(leavingRestState);
        }
        removeTask.run();
    }

    boolean isInstallationCommitted() {
        assert (Thread.holdsLock(this));
        return this.state.compareTo(ServiceController.Substate.CANCELLED) > 0;
    }

    private boolean ignoreNotification() {
        assert (Thread.holdsLock(this));
        return this.state.compareTo(ServiceController.Substate.REMOVING) >= 0 || this.state.compareTo(ServiceController.Substate.CANCELLED) <= 0;
    }

    private boolean shouldStart() {
        assert (Thread.holdsLock(this));
        return this.mode == ServiceController.Mode.ACTIVE || this.mode == ServiceController.Mode.PASSIVE || this.demandedByCount > 0 && (this.mode == ServiceController.Mode.ON_DEMAND || this.mode == ServiceController.Mode.LAZY);
    }

    private boolean shouldStop() {
        assert (Thread.holdsLock(this));
        return this.mode == ServiceController.Mode.REMOVE || this.demandedByCount == 0 && this.mode == ServiceController.Mode.ON_DEMAND || this.mode == ServiceController.Mode.NEVER;
    }

    private boolean isStableRestState() {
        assert (Thread.holdsLock(this));
        return this.asyncTasks == 0 && this.state.isRestState();
    }

    private void updateStabilityState(boolean leavingStableRestState) {
        boolean enteringStableRestState;
        assert (Thread.holdsLock(this));
        boolean bl = enteringStableRestState = this.state.isRestState() && this.asyncTasks == 0;
        if (leavingStableRestState) {
            if (!enteringStableRestState) {
                this.primaryRegistration.getContainer().incrementUnstableServices();
                for (StabilityMonitor monitor : this.monitors) {
                    monitor.incrementUnstableServices();
                }
            }
        } else if (enteringStableRestState) {
            this.primaryRegistration.getContainer().decrementUnstableServices();
            for (StabilityMonitor monitor : this.monitors) {
                monitor.decrementUnstableServices();
            }
            if (this.shutdownListener != null && this.state == ServiceController.Substate.REMOVED) {
                this.shutdownListener.controllerDied();
            }
        }
    }

    private ServiceController.Transition getTransition() {
        assert (Thread.holdsLock(this));
        switch (this.state) {
            case NEW: {
                if (this.getServiceContainer().isShutdown()) break;
                return ServiceController.Transition.NEW_to_DOWN;
            }
            case DOWN: {
                if (this.mode == ServiceController.Mode.REMOVE) {
                    return ServiceController.Transition.DOWN_to_REMOVING;
                }
                if (this.mode == ServiceController.Mode.NEVER) {
                    return ServiceController.Transition.DOWN_to_WONT_START;
                }
                if (this.shouldStart() && (this.mode != ServiceController.Mode.PASSIVE || this.stoppingDependencies == 0)) {
                    return ServiceController.Transition.DOWN_to_START_REQUESTED;
                }
                return ServiceController.Transition.DOWN_to_WAITING;
            }
            case WAITING: {
                if ((this.mode == ServiceController.Mode.ON_DEMAND || this.mode == ServiceController.Mode.LAZY) && this.demandedByCount <= 0 || this.mode == ServiceController.Mode.PASSIVE && this.stoppingDependencies != 0) break;
                return ServiceController.Transition.WAITING_to_DOWN;
            }
            case WONT_START: {
                if (this.mode == ServiceController.Mode.NEVER) break;
                return ServiceController.Transition.WONT_START_to_DOWN;
            }
            case STOPPING: {
                if (!this.children.isEmpty()) break;
                return ServiceController.Transition.STOPPING_to_DOWN;
            }
            case STOP_REQUESTED: {
                if (this.shouldStart() && this.stoppingDependencies == 0) {
                    return ServiceController.Transition.STOP_REQUESTED_to_UP;
                }
                if (this.runningDependents != 0) break;
                return ServiceController.Transition.STOP_REQUESTED_to_STOPPING;
            }
            case UP: {
                if (!this.shouldStop() && this.stoppingDependencies <= 0) break;
                return ServiceController.Transition.UP_to_STOP_REQUESTED;
            }
            case START_FAILED: {
                if (!this.children.isEmpty()) break;
                if (this.shouldStart() && this.stoppingDependencies == 0) {
                    if (this.startException != null) break;
                    return ServiceController.Transition.START_FAILED_to_STARTING;
                }
                if (this.runningDependents != 0) break;
                return ServiceController.Transition.START_FAILED_to_DOWN;
            }
            case START_INITIATING: {
                if (this.shouldStart() && this.runningDependents == 0 && this.stoppingDependencies == 0 && this.failCount == 0) {
                    return ServiceController.Transition.START_INITIATING_to_STARTING;
                }
                return ServiceController.Transition.START_INITIATING_to_START_REQUESTED;
            }
            case STARTING: {
                if (this.startException == null) {
                    return ServiceController.Transition.STARTING_to_UP;
                }
                return ServiceController.Transition.STARTING_to_START_FAILED;
            }
            case START_REQUESTED: {
                if (this.shouldStart()) {
                    if (this.mode == ServiceController.Mode.PASSIVE && this.stoppingDependencies > 0) {
                        return ServiceController.Transition.START_REQUESTED_to_DOWN;
                    }
                    if (!this.unavailableDependencies.isEmpty() || this.failCount > 0) {
                        return ServiceController.Transition.START_REQUESTED_to_PROBLEM;
                    }
                    if (this.stoppingDependencies != 0 || this.runningDependents != 0) break;
                    return ServiceController.Transition.START_REQUESTED_to_START_INITIATING;
                }
                return ServiceController.Transition.START_REQUESTED_to_DOWN;
            }
            case PROBLEM: {
                if (this.shouldStart() && (!this.unavailableDependencies.isEmpty() || this.failCount != 0) && this.mode != ServiceController.Mode.PASSIVE) break;
                return ServiceController.Transition.PROBLEM_to_START_REQUESTED;
            }
            case REMOVING: {
                return ServiceController.Transition.REMOVING_to_REMOVED;
            }
            case CANCELLED: {
                return ServiceController.Transition.CANCELLED_to_REMOVED;
            }
        }
        return null;
    }

    private boolean postTransitionTasks(List<Runnable> tasks) {
        assert (Thread.holdsLock(this));
        if (this.listenerTransitionTasks.size() > 0) {
            tasks.addAll(this.listenerTransitionTasks);
            this.listenerTransitionTasks.clear();
            return true;
        }
        return false;
    }

    private List<Runnable> transition() {
        assert (Thread.holdsLock(this));
        if (this.asyncTasks != 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        if (this.postTransitionTasks(tasks)) {
            return tasks;
        }
        this.execFlags = 0;
        do {
            switch (this.mode) {
                case NEVER: 
                case REMOVE: {
                    if (!this.dependenciesDemanded) break;
                    tasks.add(new UndemandDependenciesTask());
                    this.dependenciesDemanded = false;
                    break;
                }
                case LAZY: {
                    if (this.state == ServiceController.Substate.UP) {
                        if (this.dependenciesDemanded) break;
                        tasks.add(new DemandDependenciesTask());
                        this.dependenciesDemanded = true;
                        break;
                    }
                }
                case ON_DEMAND: 
                case PASSIVE: {
                    if (this.demandedByCount > 0 && !this.dependenciesDemanded) {
                        tasks.add(new DemandDependenciesTask());
                        this.dependenciesDemanded = true;
                        break;
                    }
                    if (this.demandedByCount != 0 || !this.dependenciesDemanded) break;
                    tasks.add(new UndemandDependenciesTask());
                    this.dependenciesDemanded = false;
                    break;
                }
                case ACTIVE: {
                    if (this.dependenciesDemanded) break;
                    tasks.add(new DemandDependenciesTask());
                    this.dependenciesDemanded = true;
                }
            }
            ServiceController.Transition transition = this.getTransition();
            if (transition == null) {
                return tasks;
            }
            this.getListenerTasks(transition, this.listenerTransitionTasks);
            switch (transition) {
                case NEW_to_DOWN: {
                    this.getListenerTasks(LifecycleEvent.DOWN, this.listenerTransitionTasks);
                    tasks.add(new DependencyAvailableTask());
                    break;
                }
                case DOWN_to_WAITING: {
                    tasks.add(new DependencyUnavailableTask());
                    break;
                }
                case WAITING_to_DOWN: {
                    tasks.add(new DependencyAvailableTask());
                    break;
                }
                case DOWN_to_WONT_START: {
                    tasks.add(new DependencyUnavailableTask());
                    break;
                }
                case WONT_START_to_DOWN: {
                    tasks.add(new DependencyAvailableTask());
                    break;
                }
                case STOPPING_to_DOWN: {
                    this.getListenerTasks(LifecycleEvent.DOWN, this.listenerTransitionTasks);
                    tasks.add(new DependentStoppedTask());
                    break;
                }
                case START_REQUESTED_to_DOWN: {
                    break;
                }
                case START_REQUESTED_to_START_INITIATING: {
                    this.lifecycleTime = System.nanoTime();
                    tasks.add(new DependentStartedTask());
                    break;
                }
                case START_REQUESTED_to_PROBLEM: {
                    tasks.add(new DependencyUnavailableTask());
                    this.getPrimaryRegistration().getContainer().addProblem(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.addProblem(this);
                    }
                    break;
                }
                case UP_to_STOP_REQUESTED: {
                    this.lifecycleTime = System.nanoTime();
                    if (this.mode == ServiceController.Mode.LAZY && this.demandedByCount == 0) {
                        assert (this.dependenciesDemanded);
                        tasks.add(new UndemandDependenciesTask());
                        this.dependenciesDemanded = false;
                    }
                    tasks.add(new DependencyStoppedTask());
                    break;
                }
                case STARTING_to_UP: {
                    this.getListenerTasks(LifecycleEvent.UP, this.listenerTransitionTasks);
                    tasks.add(new DependencyStartedTask());
                    break;
                }
                case STARTING_to_START_FAILED: {
                    this.getListenerTasks(LifecycleEvent.FAILED, this.listenerTransitionTasks);
                    this.getPrimaryRegistration().getContainer().addFailed(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.addFailed(this);
                    }
                    Object childTarget = this.childTarget;
                    if (childTarget != null) {
                        ((ChildServiceTarget)childTarget).valid = false;
                        this.childTarget = null;
                    }
                    tasks.add(new DependencyFailedTask());
                    tasks.add(new RemoveChildrenTask());
                    tasks.add(new StopTask(false));
                    break;
                }
                case START_FAILED_to_STARTING: {
                    this.getPrimaryRegistration().getContainer().removeFailed(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeFailed(this);
                    }
                    tasks.add(new DependencyRetryingTask());
                    tasks.add(new StartTask());
                    break;
                }
                case START_INITIATING_to_STARTING: {
                    tasks.add(new StartTask());
                    break;
                }
                case START_INITIATING_to_START_REQUESTED: {
                    tasks.add(new DependentStoppedTask());
                    break;
                }
                case START_FAILED_to_DOWN: {
                    this.getListenerTasks(LifecycleEvent.DOWN, this.listenerTransitionTasks);
                    this.getPrimaryRegistration().getContainer().removeFailed(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeFailed(this);
                    }
                    this.startException = null;
                    tasks.add(new DependencyRetryingTask());
                    tasks.add(new DependentStoppedTask());
                    break;
                }
                case STOP_REQUESTED_to_UP: {
                    tasks.add(new DependencyStartedTask());
                    break;
                }
                case STOP_REQUESTED_to_STOPPING: {
                    Object childTarget = this.childTarget;
                    if (childTarget != null) {
                        ((ChildServiceTarget)childTarget).valid = false;
                        this.childTarget = null;
                    }
                    tasks.add(new StopTask(true));
                    tasks.add(new RemoveChildrenTask());
                    break;
                }
                case DOWN_to_REMOVING: {
                    tasks.add(new DependencyUnavailableTask());
                    break;
                }
                case CANCELLED_to_REMOVED: {
                    this.getListenerTasks(LifecycleEvent.REMOVED, this.listenerTransitionTasks);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeControllerNoCallback(this);
                    }
                    this.listeners.clear();
                    this.lifecycleListeners.clear();
                    break;
                }
                case REMOVING_to_REMOVED: {
                    this.getListenerTasks(LifecycleEvent.REMOVED, this.listenerTransitionTasks);
                    tasks.add(new RemoveTask());
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeControllerNoCallback(this);
                    }
                    this.listeners.clear();
                    this.lifecycleListeners.clear();
                    break;
                }
                case DOWN_to_START_REQUESTED: {
                    break;
                }
                case PROBLEM_to_START_REQUESTED: {
                    tasks.add(new DependencyAvailableTask());
                    this.getPrimaryRegistration().getContainer().removeProblem(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeProblem(this);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.state = transition.getAfter();
        } while (tasks.isEmpty() && this.listenerTransitionTasks.isEmpty());
        this.notifyAll();
        if (tasks.size() <= 0) {
            this.postTransitionTasks(tasks);
        }
        return tasks;
    }

    private void getListenerTasks(ServiceController.Transition transition, List<Runnable> tasks) {
        for (ServiceListener<? super S> serviceListener : this.listeners) {
            tasks.add(new ListenerTask(serviceListener, transition));
        }
    }

    private void getListenerTasks(ListenerNotification notification, List<Runnable> tasks) {
        for (ServiceListener<? super S> serviceListener : this.listeners) {
            tasks.add(new ListenerTask(serviceListener, notification));
        }
    }

    private void getListenerTasks(LifecycleEvent event, List<Runnable> tasks) {
        for (LifecycleListener listener : this.lifecycleListeners) {
            tasks.add(new LifecycleListenerTask(listener, event));
        }
    }

    void doExecute(List<Runnable> tasks) {
        assert (!Thread.holdsLock(this));
        if (tasks.isEmpty()) {
            return;
        }
        Executor executor = this.primaryRegistration.getContainer().getExecutor();
        for (Runnable task : tasks) {
            try {
                executor.execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
        }
    }

    @Override
    public void setMode(ServiceController.Mode newMode) {
        this.internalSetMode(null, newMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalSetMode(ServiceController.Mode expectedMode, ServiceController.Mode newMode) {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        if (newMode == null) {
            throw new IllegalArgumentException("newMode is null");
        }
        if (newMode != ServiceController.Mode.REMOVE && this.primaryRegistration.getContainer().isShutdown()) {
            throw new IllegalArgumentException("Container is shutting down");
        }
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            ServiceController.Mode oldMode = this.mode;
            if (expectedMode != null && expectedMode != oldMode) {
                return false;
            }
            if (oldMode == newMode) {
                return true;
            }
            this.internalSetMode(newMode);
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
        return true;
    }

    private void internalSetMode(ServiceController.Mode newMode) {
        assert (Thread.holdsLock(this));
        ServiceController.Mode oldMode = this.mode;
        if (oldMode == ServiceController.Mode.REMOVE && this.state.compareTo(ServiceController.Substate.REMOVING) >= 0) {
            throw new IllegalStateException("Service already removed");
        }
        this.mode = newMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyAvailable(ServiceName dependencyName) {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            assert (this.unavailableDependencies.contains(dependencyName));
            this.unavailableDependencies.remove(dependencyName);
            if (this.ignoreNotification() || !this.unavailableDependencies.isEmpty()) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyUnavailable(ServiceName dependencyName) {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            assert (!this.unavailableDependencies.contains(dependencyName));
            this.unavailableDependencies.add(dependencyName);
            if (this.ignoreNotification() || this.unavailableDependencies.size() != 1) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    @Override
    public ServiceControllerImpl<?> getDependentController() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyUp() {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            assert (this.stoppingDependencies > 0);
            --this.stoppingDependencies;
            if (this.ignoreNotification() || this.stoppingDependencies != 0) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyDown() {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            ++this.stoppingDependencies;
            if (this.ignoreNotification() || this.stoppingDependencies != 1) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyFailed() {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            ++this.failCount;
            if (this.ignoreNotification() || this.failCount != 1) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencySucceeded() {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            assert (this.failCount > 0);
            --this.failCount;
            if (this.ignoreNotification() || this.failCount != 0) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    void dependentStarted() {
        this.dependentsStarted(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentsStarted(int count) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.runningDependents += count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentStopped() {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            assert (this.runningDependents > 0);
            --this.runningDependents;
            if (this.ignoreNotification() || this.runningDependents != 0) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    void newDependent(ServiceName dependencyName, Dependent dependent) {
        assert (Thread.holdsLock(this));
        if (this.state == ServiceController.Substate.START_FAILED && this.finishedTask(16)) {
            dependent.dependencyFailed();
        } else if ((this.state == ServiceController.Substate.STARTING || this.state == ServiceController.Substate.DOWN) && this.unfinishedTask(32)) {
            dependent.dependencyFailed();
        }
        if ((this.state == ServiceController.Substate.WAITING || this.state == ServiceController.Substate.WONT_START || this.state == ServiceController.Substate.REMOVING || this.state == ServiceController.Substate.PROBLEM) && this.finishedTask(2)) {
            dependent.dependencyUnavailable(dependencyName);
        } else if ((this.state == ServiceController.Substate.DOWN || this.state == ServiceController.Substate.START_REQUESTED) && this.unfinishedTask(1)) {
            dependent.dependencyUnavailable(dependencyName);
        } else if (this.state == ServiceController.Substate.NEW || this.state == ServiceController.Substate.CANCELLED || this.state == ServiceController.Substate.REMOVED) {
            dependent.dependencyUnavailable(dependencyName);
        } else if (this.state == ServiceController.Substate.UP && this.finishedTask(4)) {
            dependent.dependencyUp();
        } else if (this.state == ServiceController.Substate.STOP_REQUESTED && this.unfinishedTask(8)) {
            dependent.dependencyUp();
        }
    }

    private boolean unfinishedTask(int taskFlag) {
        assert (Thread.holdsLock(this));
        boolean taskScheduled = (this.execFlags & taskFlag << 16) != 0;
        boolean taskRunning = (this.execFlags & taskFlag) == 0;
        return taskScheduled && taskRunning;
    }

    private boolean finishedTask(int taskFlag) {
        assert (Thread.holdsLock(this));
        boolean taskUnscheduled = (this.execFlags & taskFlag << 16) == 0;
        boolean taskFinished = (this.execFlags & taskFlag) != 0;
        return taskUnscheduled || taskFinished;
    }

    void addDemand() {
        this.addDemands(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDemands(int demandedByCount) {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean propagate;
            boolean leavingRestState = this.isStableRestState();
            int cnt = this.demandedByCount;
            this.demandedByCount += demandedByCount;
            if (this.ignoreNotification()) {
                return;
            }
            boolean notStartedLazy = this.mode == ServiceController.Mode.LAZY && (this.state.getState() != ServiceController.State.UP || this.state == ServiceController.Substate.STOP_REQUESTED);
            boolean bl = propagate = cnt == 0 && (this.mode == ServiceController.Mode.ON_DEMAND || notStartedLazy || this.mode == ServiceController.Mode.PASSIVE);
            if (!propagate) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDemand() {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean propagate;
            boolean leavingRestState = this.isStableRestState();
            assert (this.demandedByCount > 0);
            int cnt = --this.demandedByCount;
            if (this.ignoreNotification()) {
                return;
            }
            boolean notStartedLazy = this.mode == ServiceController.Mode.LAZY && (this.state.getState() != ServiceController.State.UP || this.state == ServiceController.Substate.STOP_REQUESTED);
            boolean bl = propagate = cnt == 0 && (this.mode == ServiceController.Mode.ON_DEMAND || notStartedLazy || this.mode == ServiceController.Mode.PASSIVE);
            if (!propagate) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(ServiceControllerImpl<?> child) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.state.getState() != ServiceController.State.STARTING && this.state.getState() != ServiceController.State.UP) {
                throw new IllegalStateException("Children cannot be added in state " + (Object)((Object)this.state.getState()));
            }
            this.children.add(child);
            this.newDependent(this.primaryRegistration.getName(), child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(ServiceControllerImpl<?> child) {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (!this.children.remove(child)) {
                return;
            }
            if (this.children.size() > 0) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    IdentityHashSet<ServiceControllerImpl<?>> getChildren() {
        assert (Thread.holdsLock(this));
        return this.children;
    }

    @Override
    public ServiceControllerImpl<?> getParent() {
        return this.parent;
    }

    @Override
    public ServiceContainerImpl getServiceContainer() {
        return this.primaryRegistration.getContainer();
    }

    @Override
    public ServiceController.State getState() {
        return this.state.getState();
    }

    @Override
    public S getValue() throws IllegalStateException {
        return (S)this.serviceValue.getValue().getValue();
    }

    @Override
    public S awaitValue() throws IllegalStateException, InterruptedException {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            while (true) {
                switch (this.state.getState()) {
                    case UP: {
                        return (S)this.serviceValue.getValue().getValue();
                    }
                    case START_FAILED: {
                        throw new IllegalStateException("Failed to start service", this.startException);
                    }
                    case REMOVED: {
                        throw new IllegalStateException("Service was removed");
                    }
                }
                this.wait();
            }
        }
    }

    @Override
    public S awaitValue(long time, TimeUnit unit) throws IllegalStateException, InterruptedException, TimeoutException {
        assert (!Thread.holdsLock(this));
        long then = System.nanoTime();
        long remaining = unit.toNanos(time);
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            long now;
            do {
                switch (this.state.getState()) {
                    case UP: {
                        return (S)this.serviceValue.getValue().getValue();
                    }
                    case START_FAILED: {
                        throw new IllegalStateException("Failed to start service", this.startException);
                    }
                    case REMOVED: {
                        throw new IllegalStateException("Service was removed");
                    }
                }
                this.wait(remaining / 1000000L, (int)(remaining % 1000000L));
            } while ((remaining -= (now = System.nanoTime()) - (then = now)) > 0L);
            throw new TimeoutException("Operation timed out");
        }
    }

    @Override
    public Service<S> getService() throws IllegalStateException {
        return this.serviceValue.getValue();
    }

    @Override
    public ServiceName getName() {
        return this.primaryRegistration.getName();
    }

    @Override
    public ServiceName[] getAliases() {
        ServiceRegistrationImpl[] aliasRegistrations = this.aliasRegistrations;
        int len = aliasRegistrations.length;
        if (len == 0) {
            return NO_NAMES;
        }
        ServiceName[] names = new ServiceName[len];
        for (int i = 0; i < len; ++i) {
            names[i] = aliasRegistrations[i].getName();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(ContainerShutdownListener listener) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.state == ServiceController.Substate.REMOVED && this.asyncTasks == 0) {
                return;
            }
            if (this.shutdownListener != null) {
                return;
            }
            this.shutdownListener = listener;
            this.shutdownListener.controllerAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(LifecycleListener listener) {
        List<Runnable> tasks;
        if (listener == null) {
            return;
        }
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (this.lifecycleListeners.contains(listener)) {
                return;
            }
            this.lifecycleListeners.add(listener);
            if (this.state == ServiceController.Substate.UP) {
                this.listenerTransitionTasks.add(new LifecycleListenerTask(listener, LifecycleEvent.UP));
            } else if (this.state == ServiceController.Substate.DOWN) {
                this.listenerTransitionTasks.add(new LifecycleListenerTask(listener, LifecycleEvent.DOWN));
            } else if (this.state == ServiceController.Substate.START_FAILED) {
                this.listenerTransitionTasks.add(new LifecycleListenerTask(listener, LifecycleEvent.FAILED));
            } else if (this.state == ServiceController.Substate.REMOVED) {
                this.listenerTransitionTasks.add(new LifecycleListenerTask(listener, LifecycleEvent.REMOVED));
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ServiceListener<? super S> listener) {
        ListenerTask listenerAddedTask;
        assert (!Thread.holdsLock(this));
        ListenerTask listenerRemovedTask = null;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (this.listeners.contains(listener)) {
                throw new IllegalArgumentException("Listener " + listener + " already present on controller for " + this.primaryRegistration.getName());
            }
            this.listeners.add(listener);
            listenerAddedTask = new ListenerTask(listener, ListenerNotification.LISTENER_ADDED);
            this.incrementAsyncTasks();
            if (this.state == ServiceController.Substate.REMOVED) {
                listenerRemovedTask = new ListenerTask(listener, ServiceController.Transition.REMOVING_to_REMOVED);
                this.incrementAsyncTasks();
            }
            this.updateStabilityState(leavingRestState);
        }
        try {
            listenerAddedTask.run();
        }
        finally {
            if (listenerRemovedTask != null) {
                listenerRemovedTask.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(LifecycleListener listener) {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.lifecycleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ServiceListener<? super S> listener) {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartException getStartException() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.startException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retry() {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (this.failCount > 0 || this.state.getState() != ServiceController.State.START_FAILED) {
                return;
            }
            this.startException = null;
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    @Override
    public synchronized Set<ServiceName> getImmediateUnavailableDependencies() {
        return this.unavailableDependencies.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceController.Mode getMode() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.mode;
        }
    }

    @Override
    public boolean compareAndSetMode(ServiceController.Mode expectedMode, ServiceController.Mode newMode) {
        if (expectedMode == null) {
            throw new IllegalArgumentException("expectedMode is null");
        }
        return this.internalSetMode(expectedMode, newMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceStatus getStatus() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            String[] dependencyNames;
            String[] aliases;
            String parentName = this.parent == null ? null : this.parent.getName().getCanonicalName();
            String name = this.primaryRegistration.getName().getCanonicalName();
            ServiceRegistrationImpl[] aliasRegistrations = this.aliasRegistrations;
            int aliasLength = aliasRegistrations.length;
            if (aliasLength == 0) {
                aliases = NO_STRINGS;
            } else {
                aliases = new String[aliasLength];
                for (int i = 0; i < aliasLength; ++i) {
                    aliases[i] = aliasRegistrations[i].getName().getCanonicalName();
                }
            }
            String serviceClass = "<unknown>";
            try {
                Service<S> value = this.serviceValue.getValue();
                if (value != null) {
                    serviceClass = value.getClass().getName();
                }
            }
            catch (RuntimeException value) {
                // empty catch block
            }
            Dependency[] dependencies = this.dependencies;
            int dependenciesLength = dependencies.length;
            if (dependenciesLength == 0) {
                dependencyNames = NO_STRINGS;
            } else {
                dependencyNames = new String[dependenciesLength];
                for (int i = 0; i < dependenciesLength; ++i) {
                    dependencyNames[i] = dependencies[i].getName().getCanonicalName();
                }
            }
            StartException startException = this.startException;
            return new ServiceStatus(parentName, name, aliases, serviceClass, this.mode.name(), this.state.getState().name(), this.state.name(), dependencyNames, this.failCount != 0, startException != null ? startException.toString() : null, !this.unavailableDependencies.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    String dumpServiceDetails() {
        void var3_7;
        ServiceControllerImpl<?> serviceControllerImpl;
        Object dependents;
        StringBuilder b = new StringBuilder();
        ServiceRegistrationImpl object = this.primaryRegistration;
        synchronized (object) {
            dependents = this.primaryRegistration.getDependents().clone();
        }
        b.append("Service Name: ").append(this.primaryRegistration.getName().toString()).append(" - Dependents: ").append(((IdentityHashSet)dependents).size()).append('\n');
        Iterator iterator = ((IdentityHashSet)dependents).iterator();
        while (iterator.hasNext()) {
            ServiceControllerImpl<?> controller;
            Dependent dependent = (Dependent)iterator.next();
            serviceControllerImpl = controller = dependent.getDependentController();
            synchronized (serviceControllerImpl) {
                b.append("        ").append(controller.getName().toString()).append(" - State: ").append((Object)controller.state.getState()).append(" (Substate: ").append((Object)controller.state).append(")\n");
            }
        }
        b.append("Service Aliases: ").append(this.aliasRegistrations.length).append('\n');
        for (Value<Object> registration : this.aliasRegistrations) {
            Object object2 = registration;
            synchronized (object2) {
                dependents = registration.getDependents().clone();
            }
            b.append("    ").append(registration.getName().toString()).append(" - Dependents: ").append(((IdentityHashSet)dependents).size()).append('\n');
            object2 = ((IdentityHashSet)dependents).iterator();
            while (object2.hasNext()) {
                Dependent dependent = (Dependent)object2.next();
                ServiceControllerImpl<?> controller = dependent.getDependentController();
                b.append("        ").append(controller.getName().toString()).append(" - State: ").append((Object)controller.state.getState()).append(" (Substate: ").append((Object)controller.state).append(")\n");
            }
        }
        ServiceControllerImpl serviceControllerImpl2 = this;
        synchronized (serviceControllerImpl2) {
            b.append("Children: ").append(this.children.size()).append('\n');
            for (ServiceControllerImpl<?> child : this.children) {
                Value<Object> registration;
                registration = child;
                synchronized (registration) {
                    b.append("    ").append(child.getName().toString()).append(" - State: ").append((Object)child.state.getState()).append(" (Substate: ").append((Object)child.state).append(")\n");
                }
            }
            ServiceController.Substate state = this.state;
            b.append("State: ").append((Object)state.getState()).append(" (Substate: ").append((Object)state).append(")\n");
            if (this.parent != null) {
                b.append("Parent Name: ").append(this.parent.getPrimaryRegistration().getName().toString()).append('\n');
            }
            b.append("Service Mode: ").append((Object)this.mode).append('\n');
            if (this.startException != null) {
                b.append("Start Exception: ").append(this.startException.getClass().getName()).append(" (Message: ").append(this.startException.getMessage()).append(")\n");
            }
            String serviceValueString = "(indeterminate)";
            try {
                serviceValueString = this.serviceValue.toString();
            }
            catch (Throwable registration) {
                // empty catch block
            }
            b.append("Service Value: ").append(serviceValueString).append('\n');
            String serviceObjectString = "(indeterminate)";
            Object serviceObjectClass = "(indeterminate)";
            try {
                Service<S> serviceObject = this.serviceValue.getValue();
                if (serviceObject != null) {
                    serviceObjectClass = serviceObject.getClass();
                    serviceObjectString = serviceObject.toString();
                }
            }
            catch (Throwable serviceObject) {
                // empty catch block
            }
            b.append("Service Object: ").append(serviceObjectString).append('\n');
            b.append("Service Object Class: ").append(serviceObjectClass).append('\n');
            b.append("Demanded By: ").append(this.demandedByCount).append('\n');
            b.append("Stopping Dependencies: ").append(this.stoppingDependencies).append('\n');
            b.append("Running Dependents: ").append(this.runningDependents).append('\n');
            b.append("Fail Count: ").append(this.failCount).append('\n');
            b.append("Unavailable Dep Count: ").append(this.unavailableDependencies.size()).append('\n');
            for (ServiceName name : this.unavailableDependencies) {
                b.append("    ").append(name.toString()).append('\n');
            }
            b.append("Dependencies Demanded: ").append(this.dependenciesDemanded ? "yes" : "no").append('\n');
            b.append("Async Tasks: ").append(this.asyncTasks).append('\n');
            if (this.lifecycleTime != 0L) {
                long elapsedNanos = System.nanoTime() - this.lifecycleTime;
                long now = System.currentTimeMillis();
                long stamp = now - elapsedNanos / 1000000L;
                b.append("Lifecycle Timestamp: ").append(this.lifecycleTime).append(String.format(" = %tb %<td %<tH:%<tM:%<tS.%<tL%n", stamp));
            }
        }
        b.append("Dependencies: ").append(this.dependencies.length).append('\n');
        boolean bl = false;
        while (var3_7 < this.dependencies.length) {
            Dependency dependency = this.dependencies[var3_7];
            ServiceControllerImpl<?> controller = dependency.getDependencyController();
            b.append("    ").append(dependency.getName().toString());
            if (controller == null) {
                b.append(" (missing)\n");
            } else {
                serviceControllerImpl = controller;
                synchronized (serviceControllerImpl) {
                    b.append(" - State: ").append((Object)controller.state.getState()).append(" (Substate: ").append((Object)controller.state).append(")\n");
                }
            }
            ++var3_7;
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMonitor(StabilityMonitor stabilityMonitor) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.monitors.add(stabilityMonitor) && !this.isStableRestState()) {
                stabilityMonitor.incrementUnstableServices();
                if (this.state == ServiceController.Substate.START_FAILED) {
                    stabilityMonitor.addFailed(this);
                } else if (this.state == ServiceController.Substate.PROBLEM) {
                    stabilityMonitor.addProblem(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMonitor(StabilityMonitor stabilityMonitor) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.monitors.remove(stabilityMonitor) && !this.isStableRestState()) {
                stabilityMonitor.removeProblem(this);
                stabilityMonitor.removeFailed(this);
                stabilityMonitor.decrementUnstableServices();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMonitorNoCallback(StabilityMonitor stabilityMonitor) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.monitors.remove(stabilityMonitor);
        }
    }

    Set<StabilityMonitor> getMonitors() {
        assert (Thread.holdsLock(this));
        return this.monitors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceController.Substate getSubstate() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.state;
        }
    }

    ServiceRegistrationImpl getPrimaryRegistration() {
        return this.primaryRegistration;
    }

    ServiceRegistrationImpl[] getAliasRegistrations() {
        return this.aliasRegistrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInjections() {
        int i;
        int injectionsLength = this.injections.length;
        boolean ok = false;
        try {
            for (i = 0; i < injectionsLength; ++i) {
                ValueInjection<?> injection = this.injections[i];
                ServiceControllerImpl.doInject(injection);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                while (i >= 0) {
                    this.injections[i].getTarget().uninject();
                    --i;
                }
            }
        }
    }

    private void performOutInjections() {
        for (ValueInjection<?> injection : this.outInjections) {
            try {
                ServiceControllerImpl.doInject(injection);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.exceptionAfterComplete(t, this.primaryRegistration.getName());
            }
        }
    }

    private static <T> void doInject(ValueInjection<T> injection) {
        injection.getTarget().inject(injection.getSource().getValue());
    }

    public String toString() {
        return String.format("Controller for %s@%x", this.getName(), this.hashCode());
    }

    private void addAsyncTasks(int size) {
        assert (Thread.holdsLock(this));
        assert (size >= 0);
        if (size > 0) {
            this.asyncTasks += size;
        }
    }

    private void incrementAsyncTasks() {
        assert (Thread.holdsLock(this));
        ++this.asyncTasks;
    }

    private void decrementAsyncTasks() {
        assert (Thread.holdsLock(this));
        assert (this.asyncTasks > 0);
        --this.asyncTasks;
    }

    private final class ChildServiceTarget
    extends ServiceTargetImpl {
        private volatile boolean valid;

        private ChildServiceTarget(ServiceTargetImpl parentTarget) {
            super(parentTarget);
            this.valid = true;
        }

        @Override
        <T> ServiceController<T> install(ServiceBuilderImpl<T> serviceBuilder) throws ServiceRegistryException {
            if (!this.valid) {
                throw new IllegalStateException("Service target is no longer valid");
            }
            return super.install(serviceBuilder);
        }

        @Override
        protected <T> ServiceBuilder<T> createServiceBuilder(ServiceName name, Value<? extends Service<T>> value, ServiceControllerImpl<?> parent) throws IllegalArgumentException {
            return super.createServiceBuilder(name, value, ServiceControllerImpl.this);
        }

        @Override
        public ServiceTarget subTarget() {
            return new ChildServiceTarget(this);
        }
    }

    private final class StopContextImpl
    implements StopContext {
        private ContextState state = ContextState.SYNC;
        private final Object lock = new Object();

        private StopContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asynchronous() throws IllegalStateException {
            Object object = this.lock;
            synchronized (object) {
                if (this.state == ContextState.SYNC) {
                    this.state = ContextState.ASYNC;
                } else if (this.state == ContextState.SYNC_ASYNC_COMPLETE) {
                    this.state = ContextState.COMPLETE;
                } else if (this.state == ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() throws IllegalStateException {
            ValueInjection[] valueInjectionArray = this.lock;
            synchronized (this.lock) {
                List tasks;
                if (this.state == ContextState.COMPLETE || this.state == ContextState.SYNC_ASYNC_COMPLETE) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                if (this.state == ContextState.ASYNC) {
                    this.state = ContextState.COMPLETE;
                }
                if (this.state == ContextState.SYNC) {
                    this.state = ContextState.SYNC_ASYNC_COMPLETE;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                for (ValueInjection injection : ServiceControllerImpl.this.injections) {
                    injection.getTarget().uninject();
                }
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.decrementAsyncTasks();
                    tasks = ServiceControllerImpl.this.transition();
                    ServiceControllerImpl.this.addAsyncTasks(tasks.size());
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
                return;
            }
        }

        @Override
        public ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }

        @Override
        public void execute(final Runnable command) {
            ServiceControllerImpl.this.doExecute(Collections.singletonList(new Runnable(){

                @Override
                public void run() {
                    ClassLoader contextClassLoader = SecurityUtils.setTCCL(SecurityUtils.getCL(command.getClass()));
                    try {
                        command.run();
                    }
                    finally {
                        SecurityUtils.setTCCL(contextClassLoader);
                    }
                }
            }));
        }

        @Override
        public long getElapsedTime() {
            return System.nanoTime() - ServiceControllerImpl.this.lifecycleTime;
        }
    }

    private final class StartContextImpl
    implements StartContext {
        private ContextState state = ContextState.SYNC;
        private final Object lock = new Object();

        private StartContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(StartException reason) throws IllegalStateException {
            List tasks;
            Object object = this.lock;
            synchronized (object) {
                if (this.state == ContextState.COMPLETE || this.state == ContextState.FAILED || this.state == ContextState.SYNC_ASYNC_COMPLETE || this.state == ContextState.SYNC_ASYNC_FAILED) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                if (this.state == ContextState.ASYNC) {
                    this.state = ContextState.FAILED;
                }
                if (this.state == ContextState.SYNC) {
                    this.state = ContextState.SYNC_ASYNC_FAILED;
                }
            }
            if (reason == null) {
                reason = new StartException("Start failed, and additionally, a null cause was supplied");
            }
            ServiceName serviceName = ServiceControllerImpl.this.getName();
            reason.setServiceName(serviceName);
            ServiceLogger.FAIL.startFailed(reason, serviceName);
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                ServiceControllerImpl.this.startException = reason;
                ServiceControllerImpl.this.decrementAsyncTasks();
                tasks = ServiceControllerImpl.this.transition();
                ServiceControllerImpl.this.addAsyncTasks(tasks.size());
                ServiceControllerImpl.this.updateStabilityState(leavingRestState);
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServiceTarget getChildTarget() {
            Object object = this.lock;
            synchronized (object) {
                if (this.state == ContextState.COMPLETE || this.state == ContextState.FAILED) {
                    throw new IllegalStateException("Lifecycle context is no longer valid");
                }
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    if (ServiceControllerImpl.this.childTarget == null) {
                        ServiceControllerImpl.this.childTarget = new ChildServiceTarget(ServiceControllerImpl.this.getServiceContainer());
                    }
                    return ServiceControllerImpl.this.childTarget;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asynchronous() throws IllegalStateException {
            Object object = this.lock;
            synchronized (object) {
                if (this.state == ContextState.SYNC) {
                    this.state = ContextState.ASYNC;
                } else if (this.state == ContextState.SYNC_ASYNC_COMPLETE) {
                    this.state = ContextState.COMPLETE;
                } else if (this.state == ContextState.SYNC_ASYNC_FAILED) {
                    this.state = ContextState.FAILED;
                } else if (this.state == ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() throws IllegalStateException {
            List tasks;
            Object object = this.lock;
            synchronized (object) {
                if (this.state == ContextState.COMPLETE || this.state == ContextState.FAILED || this.state == ContextState.SYNC_ASYNC_COMPLETE || this.state == ContextState.SYNC_ASYNC_FAILED) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                if (this.state == ContextState.ASYNC) {
                    this.state = ContextState.COMPLETE;
                }
                if (this.state == ContextState.SYNC) {
                    this.state = ContextState.SYNC_ASYNC_COMPLETE;
                }
            }
            ServiceControllerImpl.this.performOutInjections();
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                ServiceControllerImpl.this.decrementAsyncTasks();
                tasks = ServiceControllerImpl.this.transition();
                ServiceControllerImpl.this.addAsyncTasks(tasks.size());
                ServiceControllerImpl.this.updateStabilityState(leavingRestState);
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        @Override
        public long getElapsedTime() {
            return System.nanoTime() - ServiceControllerImpl.this.lifecycleTime;
        }

        @Override
        public ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }

        @Override
        public void execute(final Runnable command) {
            ServiceControllerImpl.this.doExecute(Collections.singletonList(new Runnable(){

                @Override
                public void run() {
                    ClassLoader contextClassLoader = SecurityUtils.setTCCL(SecurityUtils.getCL(command.getClass()));
                    try {
                        command.run();
                    }
                    finally {
                        SecurityUtils.setTCCL(contextClassLoader);
                    }
                }
            }));
        }
    }

    private final class RemoveTask
    extends ControllerTask {
        private RemoveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean execute() {
            Lockable lockable;
            Lockable lock;
            assert (ServiceControllerImpl.this.getMode() == ServiceController.Mode.REMOVE);
            assert (ServiceControllerImpl.this.getSubstate() == ServiceController.Substate.REMOVED || ServiceControllerImpl.this.getSubstate() == ServiceController.Substate.CANCELLED);
            Lockable object = lock = ServiceControllerImpl.this.primaryRegistration.getLock();
            synchronized (object) {
                lock.acquireWrite();
                try {
                    ServiceControllerImpl.this.primaryRegistration.clearInstance(ServiceControllerImpl.this);
                }
                finally {
                    lock.releaseWrite();
                }
            }
            for (ServiceRegistrationImpl aliasRegistration : ServiceControllerImpl.this.aliasRegistrations) {
                lockable = lock = aliasRegistration.getLock();
                synchronized (lockable) {
                    lock.acquireWrite();
                    try {
                        aliasRegistration.clearInstance(ServiceControllerImpl.this);
                    }
                    finally {
                        lock.releaseWrite();
                    }
                }
            }
            for (Dependency dependency : ServiceControllerImpl.this.dependencies) {
                lockable = lock = dependency.getLock();
                synchronized (lockable) {
                    lock.acquireWrite();
                    try {
                        dependency.removeDependent(ServiceControllerImpl.this);
                    }
                    finally {
                        lock.releaseWrite();
                    }
                }
            }
            if (ServiceControllerImpl.this.parent != null) {
                Lockable lockable2 = lock = ((ServiceControllerImpl)ServiceControllerImpl.this.parent).primaryRegistration.getLock();
                synchronized (lockable2) {
                    lock.acquireWrite();
                    try {
                        ServiceControllerImpl.this.parent.removeChild(ServiceControllerImpl.this);
                    }
                    finally {
                        lock.releaseWrite();
                    }
                }
            }
            return true;
        }
    }

    private final class RemoveChildrenTask
    extends ControllerTask {
        private RemoveChildrenTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean execute() {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                for (ServiceControllerImpl child : ServiceControllerImpl.this.children) {
                    child.setMode(ServiceController.Mode.REMOVE);
                }
            }
            return true;
        }
    }

    private final class LifecycleListenerTask
    extends ControllerTask {
        private final LifecycleListener listener;
        private final LifecycleEvent event;

        LifecycleListenerTask(LifecycleListener listener, LifecycleEvent event) {
            this.listener = listener;
            this.event = event;
        }

        @Override
        boolean execute() {
            ClassLoader oldCL = SecurityUtils.setTCCL(SecurityUtils.getCL(this.listener.getClass()));
            try {
                this.listener.handleEvent(ServiceControllerImpl.this, this.event);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.listenerFailed(t, this.listener);
            }
            finally {
                SecurityUtils.setTCCL(oldCL);
            }
            return true;
        }
    }

    private final class ListenerTask
    extends ControllerTask {
        private final ListenerNotification notification;
        private final ServiceListener<? super S> listener;
        private final ServiceController.Transition transition;

        ListenerTask(ServiceListener<? super S> listener, ServiceController.Transition transition) {
            this.listener = listener;
            this.transition = transition;
            this.notification = ListenerNotification.TRANSITION;
        }

        ListenerTask(ServiceListener<? super S> listener, ListenerNotification notification) {
            this.listener = listener;
            this.transition = null;
            this.notification = notification;
        }

        @Override
        boolean execute() {
            this.invokeListener(this.listener, this.notification, this.transition);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void invokeListener(ServiceListener<? super S> listener, ListenerNotification notification, ServiceController.Transition transition) {
            ClassLoader contextClassLoader = SecurityUtils.setTCCL(SecurityUtils.getCL(listener.getClass()));
            try {
                switch (notification) {
                    case TRANSITION: {
                        listener.transition(ServiceControllerImpl.this, transition);
                        return;
                    }
                    case LISTENER_ADDED: {
                        listener.listenerAdded(ServiceControllerImpl.this);
                        return;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.listenerFailed(t, listener);
                return;
            }
            finally {
                SecurityUtils.setTCCL(contextClassLoader);
            }
        }
    }

    private final class StopTask
    extends ControllerTask {
        private final boolean stopService;

        StopTask(boolean stopService) {
            this.stopService = stopService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean execute() {
            ServiceName serviceName = ServiceControllerImpl.this.primaryRegistration.getName();
            StopContextImpl context = new StopContextImpl();
            boolean ok = false;
            try {
                if (this.stopService) {
                    try {
                        Service service = (Service)ServiceControllerImpl.this.serviceValue.getValue();
                        if (service != null) {
                            this.stopService(service, context);
                            ok = true;
                        }
                        ServiceLogger.ROOT.stopServiceMissing(serviceName);
                    }
                    catch (Throwable t) {
                        ServiceLogger.FAIL.stopFailed(t, serviceName);
                    }
                }
            }
            finally {
                Object object = context.lock;
                synchronized (object) {
                    if (ok && context.state != ContextState.SYNC) {
                        return false;
                    }
                    context.state = ContextState.COMPLETE;
                }
                this.uninject(serviceName, ServiceControllerImpl.this.injections);
                this.uninject(serviceName, ServiceControllerImpl.this.outInjections);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopService(Service<? extends S> service, StopContext context) {
            ClassLoader contextClassLoader = SecurityUtils.setTCCL(SecurityUtils.getCL(service.getClass()));
            try {
                service.stop(context);
            }
            finally {
                SecurityUtils.setTCCL(contextClassLoader);
            }
        }

        private void uninject(ServiceName serviceName, ValueInjection<?>[] injections) {
            for (ValueInjection<?> injection : injections) {
                try {
                    injection.getTarget().uninject();
                }
                catch (Throwable t) {
                    ServiceLogger.ROOT.uninjectFailed(t, serviceName, injection);
                }
            }
        }
    }

    private final class StartTask
    extends ControllerTask {
        private StartTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean execute() {
            ServiceName serviceName = ServiceControllerImpl.this.primaryRegistration.getName();
            StartContextImpl context = new StartContextImpl();
            try {
                ServiceControllerImpl.this.performInjections();
                Service service = (Service)ServiceControllerImpl.this.serviceValue.getValue();
                if (service == null) {
                    throw new IllegalArgumentException("Service is null");
                }
                this.startService(service, context);
                Object object = context.lock;
                synchronized (object) {
                    if (context.state != ContextState.SYNC) {
                        return false;
                    }
                    context.state = ContextState.COMPLETE;
                }
                ServiceControllerImpl.this.performOutInjections();
                return true;
            }
            catch (StartException e) {
                e.setServiceName(serviceName);
                return this.startFailed(e, serviceName, context);
            }
            catch (Throwable t) {
                StartException e = new StartException("Failed to start service", t, serviceName);
                return this.startFailed(e, serviceName, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startService(Service<? extends S> service, StartContext context) throws StartException {
            ClassLoader contextClassLoader = SecurityUtils.setTCCL(SecurityUtils.getCL(service.getClass()));
            try {
                service.start(context);
            }
            finally {
                SecurityUtils.setTCCL(contextClassLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean startFailed(StartException e, ServiceName serviceName, StartContextImpl context) {
            ServiceLogger.FAIL.startFailed(e, serviceName);
            Object object = context.lock;
            synchronized (object) {
                ContextState oldState = context.state;
                if (oldState != ContextState.SYNC && oldState != ContextState.ASYNC) {
                    ServiceLogger.FAIL.exceptionAfterComplete(e, serviceName);
                    return false;
                }
                context.state = ContextState.FAILED;
            }
            object = ServiceControllerImpl.this;
            synchronized (object) {
                ServiceControllerImpl.this.startException = e;
            }
            return true;
        }
    }

    private final class DependencyRetryingTask
    extends DependentsControllerTask {
        private DependencyRetryingTask() {
            super(32);
        }

        @Override
        void inform(Dependent dependent) {
            dependent.dependencySucceeded();
        }
    }

    private final class DependencyFailedTask
    extends DependentsControllerTask {
        private DependencyFailedTask() {
            super(16);
        }

        @Override
        void inform(Dependent dependent) {
            dependent.dependencyFailed();
        }
    }

    private final class DependencyStoppedTask
    extends DependentsControllerTask {
        private DependencyStoppedTask() {
            super(8);
        }

        @Override
        void inform(Dependent dependent) {
            dependent.dependencyDown();
        }
    }

    private final class DependencyStartedTask
    extends DependentsControllerTask {
        private DependencyStartedTask() {
            super(4);
        }

        @Override
        void inform(Dependent dependent) {
            dependent.dependencyUp();
        }
    }

    private final class DependencyUnavailableTask
    extends DependentsControllerTask {
        DependencyUnavailableTask() {
            super(2);
        }

        @Override
        void inform(Dependent dependent, ServiceName name) {
            dependent.dependencyUnavailable(name);
        }
    }

    private final class DependencyAvailableTask
    extends DependentsControllerTask {
        DependencyAvailableTask() {
            super(1);
        }

        @Override
        void inform(Dependent dependent, ServiceName name) {
            dependent.dependencyAvailable(name);
        }
    }

    private final class DependentStoppedTask
    extends DependenciesControllerTask {
        private DependentStoppedTask() {
        }

        @Override
        void inform(Dependency dependency) {
            dependency.dependentStopped();
        }

        @Override
        void inform(ServiceControllerImpl parent) {
            parent.dependentStopped();
        }
    }

    private final class DependentStartedTask
    extends DependenciesControllerTask {
        private DependentStartedTask() {
        }

        @Override
        void inform(Dependency dependency) {
            dependency.dependentStarted();
        }

        @Override
        void inform(ServiceControllerImpl parent) {
            parent.dependentStarted();
        }
    }

    private final class UndemandDependenciesTask
    extends DependenciesControllerTask {
        private UndemandDependenciesTask() {
        }

        @Override
        void inform(Dependency dependency) {
            dependency.removeDemand();
        }

        @Override
        void inform(ServiceControllerImpl parent) {
            parent.removeDemand();
        }
    }

    private final class DemandDependenciesTask
    extends DependenciesControllerTask {
        private DemandDependenciesTask() {
        }

        @Override
        void inform(Dependency dependency) {
            dependency.addDemand();
        }

        @Override
        void inform(ServiceControllerImpl parent) {
            parent.addDemand();
        }
    }

    private abstract class DependentsControllerTask
    extends ControllerTask {
        private final int execFlag;

        private DependentsControllerTask(int execFlag) {
            this.execFlag = execFlag;
            ServiceControllerImpl.this.execFlags = ServiceControllerImpl.this.execFlags | execFlag << 16;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean execute() {
            for (Dependent dependent : ServiceControllerImpl.this.primaryRegistration.getDependents()) {
                this.inform(dependent, ServiceControllerImpl.this.primaryRegistration.getName());
            }
            for (ServiceRegistrationImpl aliasRegistration : ServiceControllerImpl.this.aliasRegistrations) {
                for (Dependent dependent : aliasRegistration.getDependents()) {
                    this.inform(dependent, aliasRegistration.getName());
                }
            }
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                for (Dependent child : ServiceControllerImpl.this.children) {
                    this.inform(child, ServiceControllerImpl.this.primaryRegistration.getName());
                }
                ServiceControllerImpl.this.execFlags = ServiceControllerImpl.this.execFlags | this.execFlag;
            }
            return true;
        }

        void inform(Dependent dependent, ServiceName serviceName) {
            this.inform(dependent);
        }

        void inform(Dependent dependent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void beforeExecute() {
            Object lock = ServiceControllerImpl.this.primaryRegistration.getLock();
            ServiceRegistrationImpl[] serviceRegistrationImplArray = lock;
            synchronized (lock) {
                ((Lockable)lock).acquireRead();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                for (ServiceRegistrationImpl aliasRegistration : ServiceControllerImpl.this.aliasRegistrations) {
                    Object object = lock = aliasRegistration.getLock();
                    synchronized (object) {
                        ((Lockable)lock).acquireRead();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void afterExecute() {
            Object lock = ServiceControllerImpl.this.primaryRegistration.getLock();
            ServiceRegistrationImpl[] serviceRegistrationImplArray = lock;
            synchronized (lock) {
                ((Lockable)lock).releaseRead();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                for (ServiceRegistrationImpl aliasRegistration : ServiceControllerImpl.this.aliasRegistrations) {
                    Object object = lock = aliasRegistration.getLock();
                    synchronized (object) {
                        ((Lockable)lock).releaseRead();
                    }
                }
                return;
            }
        }
    }

    private abstract class DependenciesControllerTask
    extends ControllerTask {
        private DependenciesControllerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean execute() {
            for (Dependency dependency : ServiceControllerImpl.this.dependencies) {
                Lockable lock;
                Lockable lockable = lock = dependency.getLock();
                synchronized (lockable) {
                    lock.acquireWrite();
                    try {
                        this.inform(dependency);
                    }
                    finally {
                        lock.releaseWrite();
                    }
                }
            }
            if (ServiceControllerImpl.this.parent != null) {
                this.inform(ServiceControllerImpl.this.parent);
            }
            return true;
        }

        abstract void inform(Dependency var1);

        abstract void inform(ServiceControllerImpl var1);
    }

    private abstract class ControllerTask
    implements Runnable {
        private ControllerTask() {
            assert (Thread.holdsLock(ServiceControllerImpl.this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            assert (!Thread.holdsLock(ServiceControllerImpl.this));
            try {
                List tasks;
                this.beforeExecute();
                if (!this.execute()) {
                    return;
                }
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.decrementAsyncTasks();
                    tasks = ServiceControllerImpl.this.transition();
                    ServiceControllerImpl.this.addAsyncTasks(tasks.size());
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
            finally {
                this.afterExecute();
            }
        }

        void afterExecute() {
        }

        void beforeExecute() {
        }

        abstract boolean execute();
    }

    static enum ContextState {
        SYNC_ASYNC_COMPLETE,
        SYNC_ASYNC_FAILED,
        SYNC,
        ASYNC,
        COMPLETE,
        FAILED;

    }

    private static enum ListenerNotification {
        LISTENER_ADDED,
        TRANSITION;

    }
}

