/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.Injectors;
import org.jboss.msc.service.AbstractServiceBuilder;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.WritableValueImpl;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

final class ObsoleteServiceBuilderImpl<T>
extends AbstractServiceBuilder<T> {
    private final Service service;
    private final Map<ServiceName, WritableValueImpl> provides = new LinkedHashMap<ServiceName, WritableValueImpl>();
    private final Set<ServiceName> aliases = new HashSet<ServiceName>();
    private ServiceController.Mode initialMode = ServiceController.Mode.ACTIVE;
    private final IdentityHashSet<StabilityMonitor> monitors = new IdentityHashSet();
    private final Map<ServiceName, AbstractServiceBuilder.Dependency> dependencies = new HashMap<ServiceName, AbstractServiceBuilder.Dependency>(0);
    private final Set<ServiceListener<? super T>> listeners = new IdentityHashSet<ServiceListener<? super T>>(0);
    private final Set<LifecycleListener> lifecycleListeners = new IdentityHashSet<LifecycleListener>(0);
    private final List<ValueInjection<?>> valueInjections = new ArrayList(0);
    private final List<Injector<? super T>> outInjections = new ArrayList<Injector<? super T>>(0);
    private boolean installed = false;

    ObsoleteServiceBuilderImpl(ServiceName serviceId, ServiceTargetImpl serviceTarget, org.jboss.msc.service.Service<T> service, ServiceControllerImpl<?> parent) {
        super(serviceId, serviceTarget, parent);
        if (service == null) {
            throw new IllegalArgumentException("Service can not be null");
        }
        this.service = service;
        this.provides.put(serviceId, null);
    }

    @Override
    public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
        if (aliases != null) {
            for (ServiceName alias : aliases) {
                if (alias == null || this.provides.keySet().contains(alias)) continue;
                this.provides.put(alias, null);
                this.aliases.add(alias);
            }
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
        this.checkAlreadyInstalled();
        if (mode == null) {
            throw new IllegalArgumentException("Initial mode is null");
        }
        if (mode == ServiceController.Mode.REMOVE) {
            throw new IllegalArgumentException("Initial mode cannot be set to REMOVE");
        }
        this.initialMode = mode;
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceName ... newDependencies) {
        return this.addDependencies(ServiceBuilder.DependencyType.REQUIRED, newDependencies);
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... newDependencies) {
        this.checkAlreadyInstalled();
        if (newDependencies != null) {
            for (ServiceName dependency : newDependencies) {
                if (dependency == null) {
                    throw new IllegalArgumentException("dependency is null");
                }
                if (this.provides.keySet().contains(dependency)) continue;
                this.doAddDependency(dependency, dependencyType);
            }
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(Iterable<ServiceName> newDependencies) {
        return this.addDependencies(ServiceBuilder.DependencyType.REQUIRED, newDependencies);
    }

    @Override
    void addDependenciesNoCheck(Iterable<ServiceName> newDependencies) {
        this.addDependenciesNoCheck(newDependencies, ServiceBuilder.DependencyType.REQUIRED);
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> newDependencies) {
        this.checkAlreadyInstalled();
        this.addDependenciesNoCheck(newDependencies, dependencyType);
        return this;
    }

    void addDependenciesNoCheck(Iterable<ServiceName> newDependencies, ServiceBuilder.DependencyType dependencyType) {
        if (newDependencies != null) {
            for (ServiceName dependency : newDependencies) {
                if (dependency == null || this.provides.keySet().contains(dependency)) continue;
                this.doAddDependency(dependency, dependencyType);
            }
        }
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency) {
        return this.addDependency(ServiceBuilder.DependencyType.REQUIRED, dependency);
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency) {
        this.checkAlreadyInstalled();
        if (!this.provides.keySet().contains(dependency)) {
            this.doAddDependency(dependency, dependencyType);
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
        return this.addDependency(ServiceBuilder.DependencyType.REQUIRED, dependency, target);
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Injector<Object> target) {
        this.checkAlreadyInstalled();
        this.doAddDependency(dependency, dependencyType).getInjectorList().add(target);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        return this.addDependency(ServiceBuilder.DependencyType.REQUIRED, dependency, type, target);
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Class<I> type, Injector<I> target) {
        this.checkAlreadyInstalled();
        this.doAddDependency(dependency, dependencyType).getInjectorList().add(Injectors.cast(target, type));
        return this;
    }

    private AbstractServiceBuilder.Dependency doAddDependency(ServiceName name, ServiceBuilder.DependencyType type) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        AbstractServiceBuilder.Dependency existing = this.dependencies.get(name);
        if (existing != null) {
            if (type == ServiceBuilder.DependencyType.REQUIRED) {
                existing.setDependencyType(ServiceBuilder.DependencyType.REQUIRED);
            }
            return existing;
        }
        AbstractServiceBuilder.Dependency newDep = new AbstractServiceBuilder.Dependency(name, type);
        if (this.dependencies.size() == 16383) {
            throw new IllegalArgumentException("Too many dependencies specified (max is 16383)");
        }
        this.dependencies.put(name, newDep);
        return newDep;
    }

    @Override
    public <I> ServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
        return this.addInjectionValue(target, new ImmediateValue<I>(value));
    }

    @Override
    public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
        this.checkAlreadyInstalled();
        this.valueInjections.add(new ValueInjection<I>(value, target));
        return this;
    }

    @Override
    public ServiceBuilder<T> addInjection(Injector<? super T> target) {
        this.checkAlreadyInstalled();
        this.outInjections.add(target);
        return this;
    }

    @Override
    public ServiceBuilder<T> addMonitor(StabilityMonitor monitor) {
        this.checkAlreadyInstalled();
        if (monitor != null) {
            this.monitors.add(monitor);
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addMonitors(StabilityMonitor ... monitors) {
        this.checkAlreadyInstalled();
        if (monitors != null) {
            for (StabilityMonitor monitor : monitors) {
                if (monitor == null) continue;
                this.monitors.add(monitor);
            }
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(LifecycleListener listener) {
        this.checkAlreadyInstalled();
        this.lifecycleListeners.add(listener);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener<? super T> listener) {
        this.checkAlreadyInstalled();
        this.listeners.add(listener);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener<? super T> ... serviceListeners) {
        this.checkAlreadyInstalled();
        for (ServiceListener<? super T> listener : serviceListeners) {
            this.listeners.add(listener);
        }
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> serviceListeners) {
        this.checkAlreadyInstalled();
        this.listeners.addAll(serviceListeners);
        return this;
    }

    @Override
    void addServiceListenersNoCheck(Set<? extends ServiceListener<? super T>> listeners) {
        this.listeners.addAll(listeners);
    }

    @Override
    void addLifecycleListenersNoCheck(Set<LifecycleListener> listeners) {
        this.lifecycleListeners.addAll(listeners);
    }

    @Override
    void addMonitorsNoCheck(Collection<? extends StabilityMonitor> monitors) {
        this.monitors.addAll(monitors);
    }

    private void checkAlreadyInstalled() {
        if (this.installed) {
            throw new IllegalStateException("ServiceBuilder already installed");
        }
    }

    @Override
    public ServiceController<T> install() throws ServiceRegistryException {
        if (this.installed) {
            throw new IllegalStateException("ServiceBuilder is already installed");
        }
        this.installed = true;
        return this.getServiceTarget().install(this);
    }

    @Override
    Service getService() {
        return this.service;
    }

    @Override
    Collection<ServiceName> getServiceAliases() {
        return this.aliases;
    }

    @Override
    Map<ServiceName, WritableValueImpl> getProvides() {
        return this.provides;
    }

    @Override
    Map<ServiceName, AbstractServiceBuilder.Dependency> getDependencies() {
        return this.dependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Set<StabilityMonitor> getMonitors() {
        for (ServiceController<Object> parent = this.getParent(); parent != null; parent = parent.getParent()) {
            ServiceControllerImpl<?> serviceControllerImpl = parent;
            synchronized (serviceControllerImpl) {
                this.addMonitorsNoCheck(parent.getMonitors());
                continue;
            }
        }
        return this.monitors;
    }

    @Override
    Set<ServiceListener<? super T>> getServiceListeners() {
        return this.listeners;
    }

    @Override
    Set<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    @Override
    List<ValueInjection<?>> getValueInjections() {
        return this.valueInjections;
    }

    @Override
    ServiceController.Mode getInitialMode() {
        return this.initialMode;
    }

    @Override
    List<Injector<? super T>> getOutInjections() {
        return this.outInjections;
    }

    @Override
    public <V> Supplier<V> requires(ServiceName name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> Consumer<V> provides(ServiceName ... names) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServiceBuilder<T> setInstance(Service service) {
        throw new UnsupportedOperationException();
    }
}

