/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.modules.management.ObjectProperties;
import org.jboss.modules.ref.Reaper;
import org.jboss.modules.ref.Reference;
import org.jboss.modules.ref.WeakReference;
import org.jboss.msc.Version;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.CircularDependencyException;
import org.jboss.msc.service.ContainerShutdownListener;
import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.OptionalDependencyImpl;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceBuilderImpl;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistrationImpl;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.WritableValueImpl;
import org.jboss.msc.service.management.ServiceContainerMXBean;
import org.jboss.msc.service.management.ServiceStatus;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.EnhancedQueueExecutor;

final class ServiceContainerImpl
extends ServiceTargetImpl
implements ServiceContainer {
    private static final AtomicInteger SERIAL = new AtomicInteger(1);
    private final ConcurrentMap<ServiceName, ServiceRegistrationImpl> registry = new ConcurrentHashMap<ServiceName, ServiceRegistrationImpl>(512);
    private final long start = System.nanoTime();
    private final Set<ServiceController<?>> problems = new IdentityHashSet();
    private final Set<ServiceController<?>> failed = new IdentityHashSet();
    private final Object lock = new Object();
    private int unstableServices;
    private long shutdownInitiated;
    private final List<ServiceContainer.TerminateListener> terminateListeners = new ArrayList<ServiceContainer.TerminateListener>(1);
    private final boolean autoShutdown;
    private volatile ServiceContainer.TerminateListener.Info terminateInfo;
    private volatile boolean down;
    private final ContainerExecutor executor;
    private final String name;
    private final MBeanServer mBeanServer;
    private final ObjectName objectName;
    private final ServiceContainerMXBean containerMXBean = new ServiceContainerMXBean(){

        @Override
        public ServiceStatus getServiceStatus(String name) {
            ServiceControllerImpl<?> instance;
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)ServiceContainerImpl.this.registry.get(ServiceName.parse(name));
            if (registration != null && (instance = registration.getDependencyController()) != null) {
                return instance.getStatus();
            }
            return null;
        }

        @Override
        public List<String> queryServiceNames() {
            Set names = ServiceContainerImpl.this.registry.keySet();
            ArrayList<String> list = new ArrayList<String>(names.size());
            for (ServiceName serviceName : names) {
                list.add(serviceName.getCanonicalName());
            }
            Collections.sort(list);
            return list;
        }

        @Override
        public List<ServiceStatus> queryServiceStatuses() {
            Collection registrations = ServiceContainerImpl.this.registry.values();
            ArrayList<ServiceStatus> list = new ArrayList<ServiceStatus>(registrations.size());
            for (ServiceRegistrationImpl registration : registrations) {
                ServiceControllerImpl<?> instance = registration.getDependencyController();
                if (instance == null) continue;
                list.add(instance.getStatus());
            }
            Collections.sort(list, new Comparator<ServiceStatus>(){

                @Override
                public int compare(ServiceStatus o1, ServiceStatus o2) {
                    return o1.getServiceName().compareTo(o2.getServiceName());
                }
            });
            return list;
        }

        @Override
        public void setServiceMode(String name, String mode) {
            ServiceControllerImpl<?> instance;
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)ServiceContainerImpl.this.registry.get(ServiceName.parse(name));
            if (registration != null && (instance = registration.getDependencyController()) != null) {
                instance.setMode(ServiceController.Mode.valueOf(mode.toUpperCase(Locale.US)));
            }
        }

        @Override
        public void dumpServices() {
            ServiceContainerImpl.this.dumpServices();
        }

        @Override
        public String dumpServicesToString() {
            PrintStream ps;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ps = new PrintStream((OutputStream)baos, false, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            ServiceContainerImpl.this.dumpServices(ps);
            ps.flush();
            try {
                return new String(baos.toByteArray(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String dumpServicesToGraphDescription() {
            String serviceName;
            List<ServiceStatus> statuses = this.queryServiceStatuses();
            HashMap<String, String> aliases = new HashMap<String, String>();
            StringBuilder builder = new StringBuilder();
            builder.append("digraph Services {\n    node [shape=record];\n    graph [rankdir=\"RL\"];\n");
            for (ServiceStatus status : statuses) {
                serviceName = status.getServiceName();
                String[] aliasesStrings = status.getAliases();
                if (aliasesStrings != null) {
                    for (String alias : aliasesStrings) {
                        aliases.put(alias, serviceName);
                        aliases.put(serviceName, serviceName);
                    }
                }
                builder.append("    ");
                String quoted = serviceName.replace("\"", "\\\"");
                builder.append('\"').append(quoted).append('\"');
                builder.append(' ');
                builder.append("[label=\"");
                builder.append(quoted);
                builder.append('|');
                builder.append(status.getStateName()).append("\\ (").append(status.getSubstateName()).append(")");
                builder.append("\"]");
                builder.append(";\n");
            }
            builder.append('\n');
            for (ServiceStatus status : statuses) {
                serviceName = status.getServiceName();
                String[] dependencies = status.getDependencies();
                HashSet<String> filteredDependencies = new HashSet<String>(Arrays.asList(dependencies));
                String parentName = status.getParentName();
                if (parentName != null) {
                    filteredDependencies.add(parentName);
                }
                for (String dependency : filteredDependencies) {
                    builder.append("    ").append('\"').append(serviceName.replace("\"", "\\\"")).append('\"');
                    String dep = (String)aliases.get(dependency);
                    if (dep == null) {
                        dep = dependency;
                    }
                    builder.append(" -> \"").append(dep.replace("\"", "\\\"")).append('\"');
                    builder.append(";\n");
                }
            }
            builder.append("}\n");
            return builder.toString();
        }

        @Override
        public String dumpServiceDetails(String serviceName) {
            ServiceControllerImpl<?> instance;
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)ServiceContainerImpl.this.registry.get(ServiceName.parse(serviceName));
            if (registration != null && (instance = registration.getDependencyController()) != null) {
                return instance.dumpServiceDetails();
            }
            return null;
        }

        @Override
        public void dumpServicesByStatus(String status) {
            System.out.printf("Services for %s with status:%s\n", ServiceContainerImpl.this.getName(), status);
            Collection<ServiceStatus> services = this.queryServicesByStatus(status);
            if (services.isEmpty()) {
                System.out.printf("There are no services with status: %s\n", status);
            } else {
                this.printServiceStatus(services, System.out);
            }
        }

        @Override
        public String dumpServicesToStringByStatus(String status) {
            Collection<ServiceStatus> services = this.queryServicesByStatus(status);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = null;
            try {
                ps = new PrintStream((OutputStream)baos, false, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            ps.printf("Services for %s with status:%s\n", ServiceContainerImpl.this.getName(), status);
            if (services.isEmpty()) {
                ps.printf("There are no services with status: %s\n", status);
            } else {
                this.printServiceStatus(services, ps);
            }
            ps.flush();
            try {
                return new String(baos.toByteArray(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }

        private Collection<ServiceStatus> queryServicesByStatus(String status) {
            Collection registrations = ServiceContainerImpl.this.registry.values();
            ArrayList<ServiceStatus> list = new ArrayList<ServiceStatus>(registrations.size());
            for (ServiceRegistrationImpl registration : registrations) {
                ServiceStatus serviceStatus;
                ServiceControllerImpl<?> instance = registration.getDependencyController();
                if (instance == null || !(serviceStatus = instance.getStatus()).getStateName().equals(status)) continue;
                list.add(serviceStatus);
            }
            return list;
        }

        private void printServiceStatus(Collection<ServiceStatus> serviceStatuses, PrintStream out) {
            if (serviceStatuses == null || serviceStatuses.isEmpty()) {
                return;
            }
            for (ServiceStatus status : serviceStatuses) {
                out.printf("%s\n", status);
            }
        }
    };
    private static final AtomicInteger executorSeq;
    private static final Thread.UncaughtExceptionHandler HANDLER;
    private static final ThreadPoolExecutor.CallerRunsPolicy POLICY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceContainerImpl(String name, int coreSize, long timeOut, TimeUnit timeOutUnit, boolean autoShutdown) {
        Set set;
        this.autoShutdown = autoShutdown;
        int serialNo = SERIAL.getAndIncrement();
        if (name == null) {
            name = String.format("anonymous-%d", serialNo);
        }
        this.name = name;
        this.executor = new ContainerExecutor(coreSize, coreSize, timeOut, timeOutUnit);
        ObjectName objectName = null;
        MBeanServer mBeanServer = null;
        try {
            objectName = new ObjectName("jboss.msc", (Hashtable<String, String>)ObjectProperties.properties((ObjectProperties.Property[])new ObjectProperties.Property[]{ObjectProperties.property((String)"type", (String)"container"), ObjectProperties.property((String)"name", (String)name)}));
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.registerMBean(this.containerMXBean, objectName);
        }
        catch (Exception e) {
            ServiceLogger.ROOT.mbeanFailed(e);
        }
        this.mBeanServer = mBeanServer;
        this.objectName = objectName;
        Set set2 = set = ShutdownHookHolder.containers;
        synchronized (set2) {
            if (ShutdownHookHolder.down) {
                this.terminateInfo = new ServiceContainer.TerminateListener.Info(System.nanoTime(), System.nanoTime());
                this.down = true;
            } else {
                set.add(new WeakReference((Object)this, null, (Reaper)new Reaper<ServiceContainerImpl, Void>(){

                    public void reap(Reference<ServiceContainerImpl, Void> reference) {
                        ShutdownHookHolder.containers.remove(reference);
                    }
                }));
            }
        }
        if (objectName != null && mBeanServer != null) {
            this.addTerminateListener(new ServiceContainer.TerminateListener(){

                @Override
                public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                    try {
                        ServiceContainerImpl.this.mBeanServer.unregisterMBean(ServiceContainerImpl.this.objectName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProblem(ServiceController<?> controller) {
        Object object = this.lock;
        synchronized (object) {
            this.problems.remove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFailed(ServiceController<?> controller) {
        Object object = this.lock;
        synchronized (object) {
            this.failed.remove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementUnstableServices() {
        Object object = this.lock;
        synchronized (object) {
            ++this.unstableServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProblem(ServiceController<?> controller) {
        Object object = this.lock;
        synchronized (object) {
            this.problems.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFailed(ServiceController<?> controller) {
        Object object = this.lock;
        synchronized (object) {
            this.failed.add(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementUnstableServices() {
        Object object = this.lock;
        synchronized (object) {
            if (--this.unstableServices == 0) {
                this.lock.notifyAll();
            }
            assert (this.unstableServices >= 0);
        }
    }

    boolean isAutoShutdown() {
        return this.autoShutdown;
    }

    @Override
    public String getName() {
        return this.name;
    }

    long getStart() {
        return this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTerminateListener(ServiceContainer.TerminateListener listener) {
        if (this.terminateInfo == null) {
            ServiceContainerImpl serviceContainerImpl = this;
            synchronized (serviceContainerImpl) {
                if (this.terminateInfo == null) {
                    this.terminateListeners.add(listener);
                    return;
                }
            }
        }
        try {
            listener.handleTermination(this.terminateInfo);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void awaitTermination() throws InterruptedException {
        LatchListener listener = new LatchListener(1);
        this.addTerminateListener(listener);
        listener.await();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        LatchListener listener = new LatchListener(1);
        this.addTerminateListener(listener);
        listener.await(timeout, unit);
    }

    @Override
    public void awaitStability() throws InterruptedException {
        this.awaitStability(null, null);
    }

    @Override
    public boolean awaitStability(long timeout, TimeUnit unit) throws InterruptedException {
        return this.awaitStability(timeout, unit, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitStability(Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problem) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.unstableServices != 0) {
                this.lock.wait();
            }
            if (failed != null) {
                failed.addAll(this.failed);
            }
            if (problem != null) {
                problem.addAll(this.problems);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitStability(long timeout, TimeUnit unit, Set<? super ServiceController<?>> failed, Set<? super ServiceController<?>> problem) throws InterruptedException {
        long now = System.nanoTime();
        long remaining = unit.toNanos(timeout);
        Object object = this.lock;
        synchronized (object) {
            while (this.unstableServices != 0) {
                if (remaining <= 0L) {
                    return false;
                }
                this.lock.wait(remaining / 1000000L, (int)(remaining % 1000000L));
                long l = -now;
                now = System.nanoTime();
                remaining -= l + now;
            }
            if (failed != null) {
                failed.addAll(this.failed);
            }
            if (problem != null) {
                problem.addAll(this.problems);
            }
            return true;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.down;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ServiceContainerImpl serviceContainerImpl = this;
        synchronized (serviceContainerImpl) {
            if (this.down) {
                return;
            }
            this.down = true;
            this.shutdownInitiated = System.nanoTime();
        }
        ContainerShutdownListener shutdownListener = new ContainerShutdownListener(new Runnable(){

            @Override
            public void run() {
                ServiceContainerImpl.this.executor.shutdown();
            }
        });
        for (ServiceRegistrationImpl registration : this.registry.values()) {
            ServiceControllerImpl<?> controller = registration.getDependencyController();
            if (controller == null) continue;
            controller.addListener(shutdownListener);
            try {
                controller.setMode(ServiceController.Mode.REMOVE);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        shutdownListener.done();
    }

    @Override
    public boolean isShutdownComplete() {
        return this.terminateInfo != null;
    }

    @Override
    public void dumpServices() {
        this.dumpServices(System.out);
    }

    @Override
    public void dumpServices(PrintStream out) {
        out.printf("Services for %s:\n", this.getName());
        ConcurrentMap<ServiceName, ServiceRegistrationImpl> registry = this.registry;
        if (registry.isEmpty()) {
            out.printf("(Registry is empty)\n", new Object[0]);
        } else {
            int i = 0;
            HashSet set = new HashSet();
            for (ServiceName name : new TreeSet(registry.keySet())) {
                ServiceControllerImpl<?> instance;
                ServiceRegistrationImpl registration = (ServiceRegistrationImpl)registry.get(name);
                if (registration == null || (instance = registration.getDependencyController()) == null || !set.add(instance)) continue;
                ++i;
                out.printf("%s\n", instance.getStatus());
            }
            out.printf("%s services displayed\n", i);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownComplete(long started) {
        ServiceContainerImpl serviceContainerImpl = this;
        synchronized (serviceContainerImpl) {
            this.terminateInfo = new ServiceContainer.TerminateListener.Info(started, System.nanoTime());
        }
        for (ServiceContainer.TerminateListener terminateListener : this.terminateListeners) {
            try {
                terminateListener.handleTermination(this.terminateInfo);
            }
            catch (Throwable throwable) {}
        }
    }

    Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ServiceRegistrationImpl getOrCreateRegistration(ServiceName name, boolean isDependent) {
        ServiceRegistrationImpl registration;
        boolean success;
        ConcurrentMap<ServiceName, ServiceRegistrationImpl> registry = this.registry;
        do {
            ServiceRegistrationImpl existing;
            if ((registration = (ServiceRegistrationImpl)registry.get(name)) == null && (existing = registry.putIfAbsent(name, registration = new ServiceRegistrationImpl(name))) != null) {
                registration = existing;
            }
            if (isDependent) {
                ServiceRegistrationImpl serviceRegistrationImpl = registration;
                synchronized (serviceRegistrationImpl) {
                    registration.acquireWrite();
                    try {
                        success = registration.addPendingDependent();
                    }
                    finally {
                        registration.releaseWrite();
                    }
                }
            }
            success = true;
        } while (!success);
        return registration;
    }

    void removeRegistration(ServiceRegistrationImpl registration) {
        this.registry.remove(registration.getName(), registration);
    }

    @Override
    public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
        ServiceController<?> controller = this.getService(serviceName);
        if (controller == null) {
            throw new ServiceNotFoundException("Service " + serviceName + " not found");
        }
        return controller;
    }

    @Override
    public ServiceController<?> getService(ServiceName serviceName) {
        ServiceRegistrationImpl registration = (ServiceRegistrationImpl)this.registry.get(serviceName);
        return registration == null ? null : registration.getDependencyController();
    }

    @Override
    public List<ServiceName> getServiceNames() {
        ArrayList<ServiceName> result = new ArrayList<ServiceName>(this.registry.size());
        for (Map.Entry registryEntry : this.registry.entrySet()) {
            if (((ServiceRegistrationImpl)registryEntry.getValue()).getDependencyController() == null) continue;
            result.add((ServiceName)registryEntry.getKey());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> ServiceController<T> install(ServiceBuilderImpl<T> serviceBuilder) throws DuplicateServiceException {
        this.apply(serviceBuilder);
        LinkedHashMap<ServiceRegistrationImpl, WritableValueImpl> provides = new LinkedHashMap<ServiceRegistrationImpl, WritableValueImpl>();
        for (Map.Entry<ServiceName, WritableValueImpl> entry : serviceBuilder.getProvides().entrySet()) {
            provides.put(this.getOrCreateRegistration(entry.getKey(), false), entry.getValue());
        }
        ArrayList outInjections = new ArrayList();
        InjectedValue<T> serviceValue = new InjectedValue<T>();
        for (Injector<T> outInjection : serviceBuilder.getOutInjections()) {
            outInjections.add(new ValueInjection(serviceValue, outInjection));
        }
        Map<ServiceName, ServiceBuilderImpl.Dependency> dependencyMap = serviceBuilder.getDependencies();
        HashSet<Dependency> requires = new HashSet<Dependency>();
        List<ValueInjection<?>> valueInjections = serviceBuilder.getValueInjections();
        for (ServiceBuilderImpl.Dependency dependencyDefinition : dependencyMap.values()) {
            Dependency dependency = dependencyDefinition.getRegistration();
            if (dependencyDefinition.getDependencyType() == ServiceBuilder.DependencyType.OPTIONAL) {
                dependency = new OptionalDependencyImpl(dependency);
            }
            requires.add(dependency);
            for (Injector<Object> injector : dependencyDefinition.getInjectorList()) {
                valueInjections.add(new ValueInjection<Object>(dependency, injector));
            }
        }
        ValueInjection[] valueInjectionArray = valueInjections.toArray(new ValueInjection[valueInjections.size()]);
        ValueInjection[] outInjectionArray = outInjections.toArray(new ValueInjection[outInjections.size()]);
        Collection<ServiceName> serviceAliases = serviceBuilder.getServiceAliases();
        ServiceName[] aliases = new ServiceName[serviceAliases.size()];
        int i = 0;
        for (ServiceName alias : serviceAliases) {
            aliases[i++] = alias;
        }
        ServiceControllerImpl<T> instance = new ServiceControllerImpl<T>(this, serviceBuilder.serviceId, aliases, serviceBuilder.getService(), requires, provides, valueInjectionArray, outInjectionArray, serviceBuilder.getMonitors(), serviceBuilder.getServiceListeners(), serviceBuilder.getLifecycleListeners(), serviceBuilder.parent);
        boolean ok = false;
        try {
            serviceValue.setValue(instance);
            Object object = this;
            synchronized (object) {
                if (this.down) {
                    ok = true;
                    throw new IllegalStateException("Container is down");
                }
                instance.startInstallation();
            }
            instance.startConfiguration();
            this.detectCircularity(instance);
            instance.commitInstallation(serviceBuilder.getInitialMode());
            ok = true;
            object = instance;
            return object;
        }
        finally {
            if (!ok) {
                instance.rollbackInstallation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void detectCircularity(ServiceControllerImpl<T> instance) throws CircularDependencyException {
        IdentityHashSet visited = new IdentityHashSet();
        ArrayDeque<ServiceName> visitStack = new ArrayDeque<ServiceName>();
        visitStack.push(instance.getName());
        Iterator<ServiceRegistrationImpl> iterator = instance.getRegistrations().iterator();
        while (iterator.hasNext()) {
            ServiceRegistrationImpl registration;
            ServiceRegistrationImpl serviceRegistrationImpl = registration = iterator.next();
            synchronized (serviceRegistrationImpl) {
                this.detectCircularity(registration.getDependents(), instance, visited, visitStack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectCircularity(Set<? extends Dependent> dependents, ServiceControllerImpl<?> instance, Set<ServiceControllerImpl<?>> visited, Deque<ServiceName> visitStack) {
        for (Dependent dependent : dependents) {
            ServiceControllerImpl<?> controller = dependent.getDependentController();
            if (controller == null) continue;
            if (controller == instance) {
                ServiceName[] cycle = new ServiceName[visitStack.size()];
                visitStack.toArray(cycle);
                int j = cycle.length - 1;
                for (int i = 0; i < j; ++i, --j) {
                    ServiceName temp = cycle[i];
                    cycle[i] = cycle[j];
                    cycle[j] = temp;
                }
                throw new CircularDependencyException("Container " + this.name + " has a circular dependency: " + Arrays.asList(cycle), cycle);
            }
            if (!visited.add(controller) || controller.getState() == ServiceController.State.REMOVED) continue;
            visitStack.push(controller.getName());
            ServiceControllerImpl<?> serviceControllerImpl = controller;
            synchronized (serviceControllerImpl) {
                this.detectCircularity(controller.getChildren(), instance, visited, visitStack);
            }
            for (ServiceRegistrationImpl registration : controller.getRegistrations()) {
                if (registration.getDependencyController() == null) continue;
                ServiceRegistrationImpl serviceRegistrationImpl = registration;
                synchronized (serviceRegistrationImpl) {
                    this.detectCircularity(registration.getDependents(), instance, visited, visitStack);
                }
            }
            visitStack.poll();
        }
    }

    static /* synthetic */ AtomicInteger access$700() {
        return executorSeq;
    }

    static {
        ServiceLogger.ROOT.greeting(Version.getVersionString());
        executorSeq = new AtomicInteger(1);
        HANDLER = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ServiceLogger.ROOT.uncaughtException(e, t);
            }
        };
        POLICY = new ThreadPoolExecutor.CallerRunsPolicy();
    }

    final class ContainerExecutor
    implements ExecutorService {
        private final ExecutorService delegate;

        ContainerExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
            ThreadFactory threadFactory = new ThreadFactory(){
                private final int id = ServiceContainerImpl.access$700().getAndIncrement();
                private final AtomicInteger threadSeq = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    return AccessController.doPrivileged(new ThreadAction(r, this.id, this.threadSeq));
                }
            };
            this.delegate = EnhancedQueueExecutor.DISABLE_HINT ? new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue(), threadFactory, POLICY){

                @Override
                protected void afterExecute(Runnable r, Throwable t) {
                    super.afterExecute(r, t);
                    if (t != null) {
                        HANDLER.uncaughtException(Thread.currentThread(), t);
                    }
                }

                @Override
                protected void terminated() {
                    ServiceContainerImpl.this.shutdownComplete(ServiceContainerImpl.this.shutdownInitiated);
                }
            } : new EnhancedQueueExecutor.Builder().setCorePoolSize(corePoolSize).setMaximumPoolSize(maximumPoolSize).setKeepAliveTime(keepAliveTime, unit).setTerminationTask(new Runnable(){

                @Override
                public void run() {
                    ServiceContainerImpl.this.shutdownComplete(ServiceContainerImpl.this.shutdownInitiated);
                }
            }).setThreadFactory(threadFactory).build();
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.delegate.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.delegate.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.delegate.submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(command);
        }
    }

    final class ThreadAction
    implements PrivilegedAction<ServiceThread> {
        private final Runnable r;
        private final int id;
        private final AtomicInteger threadSeq;

        ThreadAction(Runnable r, int id, AtomicInteger threadSeq) {
            this.r = r;
            this.id = id;
            this.threadSeq = threadSeq;
        }

        @Override
        public ServiceThread run() {
            ServiceThread thread = new ServiceThread(this.r, ServiceContainerImpl.this);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            thread.setName(String.format("MSC service thread %d-%d", this.id, this.threadSeq.getAndIncrement()));
            thread.setUncaughtExceptionHandler(HANDLER);
            return thread;
        }
    }

    static class ServiceThread
    extends Thread {
        private final ServiceContainerImpl container;

        ServiceThread(Runnable runnable, ServiceContainerImpl container) {
            super(runnable);
            this.container = container;
        }

        ServiceContainerImpl getContainer() {
            return this.container;
        }
    }

    static final class LatchListener
    extends CountDownLatch
    implements ServiceContainer.TerminateListener {
        LatchListener(int count) {
            super(count);
        }

        @Override
        public void handleTermination(ServiceContainer.TerminateListener.Info info) {
            this.countDown();
        }
    }

    private static final class ShutdownHookHolder {
        private static final Set<Reference<ServiceContainerImpl, Void>> containers;
        private static boolean down;

        private ShutdownHookHolder() {
        }

        static {
            down = false;
            containers = new HashSet<Reference<ServiceContainerImpl, Void>>();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread hook = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            LatchListener listener;
                            Set set;
                            Set set2 = set = containers;
                            synchronized (set2) {
                                down = true;
                                listener = new LatchListener(set.size());
                                for (Reference containerRef : set) {
                                    ServiceContainerImpl container = (ServiceContainerImpl)containerRef.get();
                                    if (container == null || !container.isAutoShutdown()) {
                                        listener.countDown();
                                        continue;
                                    }
                                    container.addTerminateListener(listener);
                                    container.shutdown();
                                }
                                set.clear();
                            }
                            while (true) {
                                try {
                                    listener.await();
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                        }
                    }, "MSC Shutdown Thread");
                    hook.setDaemon(false);
                    Runtime.getRuntime().addShutdownHook(hook);
                    return null;
                }
            });
        }
    }
}

