/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StabilityMonitor;

public class DelegatingServiceBuilder<T>
implements ServiceBuilder<T> {
    private final ServiceBuilder<T> delegate;

    public DelegatingServiceBuilder(ServiceBuilder<T> delegate) {
        this.delegate = delegate;
    }

    protected ServiceBuilder<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public <V> Supplier<V> requires(ServiceName name) {
        return this.getDelegate().requires(name);
    }

    @Override
    public <V> Consumer<V> provides(ServiceName ... names) {
        return this.getDelegate().provides(names);
    }

    @Override
    public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
        this.getDelegate().setInitialMode(mode);
        return this;
    }

    @Override
    public ServiceBuilder<T> setInstance(Service service) {
        this.getDelegate().setInstance(service);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(LifecycleListener listener) {
        this.getDelegate().addListener(listener);
        return this;
    }

    @Override
    public ServiceController<T> install() {
        return this.getDelegate().install();
    }

    @Override
    @Deprecated
    public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
        this.getDelegate().addAliases(aliases);
        return this;
    }

    @Override
    @Deprecated
    public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        this.getDelegate().addDependency(dependency, type, target);
        return this;
    }

    @Override
    @Deprecated
    public ServiceBuilder<T> addMonitor(StabilityMonitor monitor) {
        this.getDelegate().addMonitor(monitor);
        return this;
    }
}

