/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.msc.Service;
import org.jboss.msc.service.ContainerShutdownListener;
import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Lockable;
import org.jboss.msc.service.SecurityUtils;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceBuilderImpl;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistrationImpl;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.Substate;
import org.jboss.msc.service.Transition;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.WritableValueImpl;
import org.jboss.msc.service.management.ServiceStatus;

final class ServiceControllerImpl<S>
implements ServiceController<S>,
Dependent {
    private static final String ILLEGAL_CONTROLLER_STATE = "Illegal controller state";
    private static final int DEPENDENCY_AVAILABLE_TASK = 1;
    private static final int DEPENDENCY_UNAVAILABLE_TASK = 2;
    private static final int DEPENDENCY_STARTED_TASK = 4;
    private static final int DEPENDENCY_STOPPED_TASK = 8;
    private static final int DEPENDENCY_FAILED_TASK = 16;
    private static final int DEPENDENCY_RETRYING_TASK = 32;
    private final ServiceContainerImpl container;
    private final ServiceName serviceId;
    private final ServiceName[] serviceAliases;
    private final Service service;
    private final ValueInjection<?>[] injections;
    private final Set<LifecycleListener> lifecycleListeners;
    private ContainerShutdownListener shutdownListener;
    private final Set<StabilityMonitor> monitors;
    private final Set<Dependency> requires;
    private final Map<ServiceRegistrationImpl, WritableValueImpl> provides;
    private final ServiceControllerImpl<?> parent;
    private final Set<ServiceControllerImpl<?>> children;
    private StartException startException;
    private ServiceController.Mode mode = ServiceController.Mode.NEVER;
    private Substate state = Substate.NEW;
    private int execFlags;
    private int demandedByCount;
    private int stoppingDependencies;
    private int unavailableDependencies;
    private int runningDependents;
    private int failCount;
    private boolean dependenciesDemanded = false;
    private int asyncTasks;
    private final List<Runnable> listenerTransitionTasks = new ArrayList<Runnable>();
    private volatile ChildServiceTarget childTarget;
    private volatile long lifecycleTime;
    private static final String[] NO_STRINGS = new String[0];
    static final int MAX_DEPENDENCIES = 16383;

    ServiceControllerImpl(ServiceContainerImpl container, ServiceName serviceId, ServiceName[] serviceAliases, Service service, Set<Dependency> requires, Map<ServiceRegistrationImpl, WritableValueImpl> provides, ValueInjection<?>[] injections, Set<StabilityMonitor> monitors, Set<LifecycleListener> lifecycleListeners, ServiceControllerImpl<?> parent) {
        assert (requires.size() <= 16383);
        this.container = container;
        this.serviceId = serviceId;
        this.serviceAliases = serviceAliases;
        this.service = service;
        this.injections = injections;
        this.requires = requires;
        this.provides = provides;
        this.lifecycleListeners = new IdentityHashSet<LifecycleListener>(lifecycleListeners);
        this.monitors = new IdentityHashSet<StabilityMonitor>(monitors);
        for (StabilityMonitor monitor : monitors) {
            monitor.addControllerNoCallback(this);
        }
        this.parent = parent;
        int depCount = requires.size();
        this.stoppingDependencies = parent == null ? depCount : depCount + 1;
        this.children = new IdentityHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startInstallation() {
        for (Map.Entry<ServiceRegistrationImpl, WritableValueImpl> provided : this.provides.entrySet()) {
            Lockable lock;
            ServiceRegistrationImpl registration = provided.getKey();
            WritableValueImpl injector = provided.getValue();
            Lockable lockable = lock = registration.getLock();
            synchronized (lockable) {
                lock.acquireWrite();
                try {
                    registration.set(this, injector);
                    if (injector != null) {
                        injector.setInstance(this);
                    }
                }
                finally {
                    lock.releaseWrite();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startConfiguration() {
        for (Dependency dependency : this.requires) {
            Lockable lock;
            Lockable lockable = lock = dependency.getLock();
            synchronized (lockable) {
                lock.acquireWrite();
                try {
                    dependency.addDependent(this);
                }
                finally {
                    lock.releaseWrite();
                }
            }
        }
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitInstallation(ServiceController.Mode initialMode) {
        List<Runnable> tasks;
        assert (this.state == Substate.NEW);
        assert (initialMode != null);
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.container.isShutdown()) {
                throw new IllegalStateException("Container is down");
            }
            boolean leavingRestState = this.isStableRestState();
            this.internalSetMode(initialMode);
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackInstallation() {
        RemoveTask removeTask;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            this.mode = ServiceController.Mode.REMOVE;
            this.state = Substate.CANCELLED;
            removeTask = new RemoveTask();
            this.incrementAsyncTasks();
            this.updateStabilityState(leavingRestState);
        }
        removeTask.run();
    }

    boolean isInstallationCommitted() {
        assert (Thread.holdsLock(this));
        return this.state.compareTo(Substate.CANCELLED) > 0;
    }

    private boolean ignoreNotification() {
        assert (Thread.holdsLock(this));
        return this.state == Substate.NEW;
    }

    private boolean shouldStart() {
        assert (Thread.holdsLock(this));
        return this.mode == ServiceController.Mode.ACTIVE || this.mode == ServiceController.Mode.PASSIVE || this.demandedByCount > 0 && (this.mode == ServiceController.Mode.ON_DEMAND || this.mode == ServiceController.Mode.LAZY);
    }

    private boolean shouldStop() {
        assert (Thread.holdsLock(this));
        return this.mode == ServiceController.Mode.REMOVE || this.demandedByCount == 0 && this.mode == ServiceController.Mode.ON_DEMAND || this.mode == ServiceController.Mode.NEVER;
    }

    private boolean isStableRestState() {
        assert (Thread.holdsLock(this));
        return this.asyncTasks == 0 && this.state.isRestState();
    }

    private void updateStabilityState(boolean leavingStableRestState) {
        boolean enteringStableRestState;
        assert (Thread.holdsLock(this));
        boolean bl = enteringStableRestState = this.state.isRestState() && this.asyncTasks == 0;
        if (leavingStableRestState) {
            if (!enteringStableRestState) {
                this.container.incrementUnstableServices();
                for (StabilityMonitor monitor : this.monitors) {
                    monitor.incrementUnstableServices();
                }
            }
        } else if (enteringStableRestState) {
            this.container.decrementUnstableServices();
            for (StabilityMonitor monitor : this.monitors) {
                monitor.decrementUnstableServices();
            }
            if (this.state == Substate.TERMINATED) {
                for (StabilityMonitor monitor : this.monitors) {
                    monitor.removeControllerNoCallback(this);
                }
                if (this.shutdownListener != null) {
                    this.shutdownListener.controllerDied();
                    this.shutdownListener = null;
                }
            }
        }
    }

    private Transition getTransition() {
        assert (Thread.holdsLock(this));
        switch (this.state) {
            case NEW: {
                if (this.container.isShutdown()) break;
                return Transition.NEW_to_DOWN;
            }
            case DOWN: {
                if (this.mode == ServiceController.Mode.REMOVE) {
                    return Transition.DOWN_to_REMOVING;
                }
                if (this.mode == ServiceController.Mode.NEVER) {
                    return Transition.DOWN_to_WONT_START;
                }
                if (this.shouldStart() && (this.mode != ServiceController.Mode.PASSIVE || this.stoppingDependencies == 0)) {
                    return Transition.DOWN_to_START_REQUESTED;
                }
                return Transition.DOWN_to_WAITING;
            }
            case WAITING: {
                if ((this.mode == ServiceController.Mode.ON_DEMAND || this.mode == ServiceController.Mode.LAZY) && this.demandedByCount <= 0 || this.mode == ServiceController.Mode.PASSIVE && this.stoppingDependencies != 0) break;
                return Transition.WAITING_to_DOWN;
            }
            case WONT_START: {
                if (this.mode == ServiceController.Mode.NEVER) break;
                return Transition.WONT_START_to_DOWN;
            }
            case STOPPING: {
                if (!this.children.isEmpty()) break;
                return Transition.STOPPING_to_DOWN;
            }
            case STOP_REQUESTED: {
                if (this.shouldStart() && this.stoppingDependencies == 0) {
                    return Transition.STOP_REQUESTED_to_UP;
                }
                if (this.runningDependents != 0) break;
                return Transition.STOP_REQUESTED_to_STOPPING;
            }
            case UP: {
                if (!this.shouldStop() && this.stoppingDependencies <= 0) break;
                return Transition.UP_to_STOP_REQUESTED;
            }
            case START_FAILED: {
                if (!this.children.isEmpty()) break;
                if (this.shouldStart() && this.stoppingDependencies == 0) {
                    if (this.startException != null) break;
                    return Transition.START_FAILED_to_STARTING;
                }
                if (this.runningDependents != 0) break;
                return Transition.START_FAILED_to_DOWN;
            }
            case START_INITIATING: {
                if (this.shouldStart() && this.runningDependents == 0 && this.stoppingDependencies == 0 && this.failCount == 0) {
                    return Transition.START_INITIATING_to_STARTING;
                }
                return Transition.START_INITIATING_to_START_REQUESTED;
            }
            case STARTING: {
                if (this.startException == null) {
                    return Transition.STARTING_to_UP;
                }
                return Transition.STARTING_to_START_FAILED;
            }
            case START_REQUESTED: {
                if (this.shouldStart()) {
                    if (this.mode == ServiceController.Mode.PASSIVE && this.stoppingDependencies > 0) {
                        return Transition.START_REQUESTED_to_DOWN;
                    }
                    if (this.unavailableDependencies > 0 || this.failCount > 0) {
                        return Transition.START_REQUESTED_to_PROBLEM;
                    }
                    if (this.stoppingDependencies != 0 || this.runningDependents != 0) break;
                    return Transition.START_REQUESTED_to_START_INITIATING;
                }
                return Transition.START_REQUESTED_to_DOWN;
            }
            case PROBLEM: {
                if (this.shouldStart() && (this.unavailableDependencies != 0 || this.failCount != 0) && this.mode != ServiceController.Mode.PASSIVE) break;
                return Transition.PROBLEM_to_START_REQUESTED;
            }
            case REMOVING: {
                return Transition.REMOVING_to_REMOVED;
            }
            case CANCELLED: {
                return Transition.CANCELLED_to_REMOVED;
            }
            case REMOVED: {
                return Transition.REMOVED_to_TERMINATED;
            }
        }
        return null;
    }

    private boolean postTransitionTasks(List<Runnable> tasks) {
        assert (Thread.holdsLock(this));
        if (this.listenerTransitionTasks.size() > 0) {
            tasks.addAll(this.listenerTransitionTasks);
            this.listenerTransitionTasks.clear();
            return true;
        }
        return false;
    }

    private List<Runnable> transition() {
        assert (Thread.holdsLock(this));
        if (this.asyncTasks != 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        if (this.postTransitionTasks(tasks)) {
            return tasks;
        }
        this.execFlags = 0;
        do {
            switch (this.mode) {
                case NEVER: 
                case REMOVE: {
                    if (!this.dependenciesDemanded) break;
                    tasks.add(new UndemandDependenciesTask());
                    this.dependenciesDemanded = false;
                    break;
                }
                case LAZY: {
                    if (this.state == Substate.UP) {
                        if (this.dependenciesDemanded) break;
                        tasks.add(new DemandDependenciesTask());
                        this.dependenciesDemanded = true;
                        break;
                    }
                }
                case ON_DEMAND: 
                case PASSIVE: {
                    if (this.demandedByCount > 0 && !this.dependenciesDemanded) {
                        tasks.add(new DemandDependenciesTask());
                        this.dependenciesDemanded = true;
                        break;
                    }
                    if (this.demandedByCount != 0 || !this.dependenciesDemanded) break;
                    tasks.add(new UndemandDependenciesTask());
                    this.dependenciesDemanded = false;
                    break;
                }
                case ACTIVE: {
                    if (this.dependenciesDemanded) break;
                    tasks.add(new DemandDependenciesTask());
                    this.dependenciesDemanded = true;
                }
            }
            Transition transition = this.getTransition();
            if (transition == null) {
                return tasks;
            }
            switch (transition) {
                case NEW_to_DOWN: {
                    this.getListenerTasks(LifecycleEvent.DOWN, this.listenerTransitionTasks);
                    tasks.add(new DependencyAvailableTask());
                    break;
                }
                case DOWN_to_WAITING: {
                    tasks.add(new DependencyUnavailableTask());
                    break;
                }
                case WAITING_to_DOWN: {
                    tasks.add(new DependencyAvailableTask());
                    break;
                }
                case DOWN_to_WONT_START: {
                    tasks.add(new DependencyUnavailableTask());
                    break;
                }
                case WONT_START_to_DOWN: {
                    tasks.add(new DependencyAvailableTask());
                    break;
                }
                case STOPPING_to_DOWN: {
                    this.getListenerTasks(LifecycleEvent.DOWN, this.listenerTransitionTasks);
                    tasks.add(new DependentStoppedTask());
                    break;
                }
                case START_REQUESTED_to_DOWN: {
                    break;
                }
                case START_REQUESTED_to_START_INITIATING: {
                    this.lifecycleTime = System.nanoTime();
                    tasks.add(new DependentStartedTask());
                    break;
                }
                case START_REQUESTED_to_PROBLEM: {
                    tasks.add(new DependencyUnavailableTask());
                    this.container.addProblem(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.addProblem(this);
                    }
                    break;
                }
                case UP_to_STOP_REQUESTED: {
                    this.lifecycleTime = System.nanoTime();
                    if (this.mode == ServiceController.Mode.LAZY && this.demandedByCount == 0) {
                        assert (this.dependenciesDemanded);
                        tasks.add(new UndemandDependenciesTask());
                        this.dependenciesDemanded = false;
                    }
                    tasks.add(new DependencyStoppedTask());
                    break;
                }
                case STARTING_to_UP: {
                    this.getListenerTasks(LifecycleEvent.UP, this.listenerTransitionTasks);
                    tasks.add(new DependencyStartedTask());
                    break;
                }
                case STARTING_to_START_FAILED: {
                    this.getListenerTasks(LifecycleEvent.FAILED, this.listenerTransitionTasks);
                    this.container.addFailed(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.addFailed(this);
                    }
                    Object childTarget = this.childTarget;
                    if (childTarget != null) {
                        ((ChildServiceTarget)childTarget).valid = false;
                        this.childTarget = null;
                    }
                    tasks.add(new DependencyFailedTask());
                    tasks.add(new RemoveChildrenTask());
                    break;
                }
                case START_FAILED_to_STARTING: {
                    this.container.removeFailed(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeFailed(this);
                    }
                    tasks.add(new DependencyRetryingTask());
                    tasks.add(new StartTask());
                    break;
                }
                case START_INITIATING_to_STARTING: {
                    tasks.add(new StartTask());
                    break;
                }
                case START_INITIATING_to_START_REQUESTED: {
                    tasks.add(new DependentStoppedTask());
                    break;
                }
                case START_FAILED_to_DOWN: {
                    this.getListenerTasks(LifecycleEvent.DOWN, this.listenerTransitionTasks);
                    this.container.removeFailed(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeFailed(this);
                    }
                    this.startException = null;
                    tasks.add(new DependencyRetryingTask());
                    tasks.add(new DependentStoppedTask());
                    break;
                }
                case STOP_REQUESTED_to_UP: {
                    tasks.add(new DependencyStartedTask());
                    break;
                }
                case STOP_REQUESTED_to_STOPPING: {
                    Object childTarget = this.childTarget;
                    if (childTarget != null) {
                        ((ChildServiceTarget)childTarget).valid = false;
                        this.childTarget = null;
                    }
                    tasks.add(new StopTask());
                    tasks.add(new RemoveChildrenTask());
                    break;
                }
                case DOWN_to_REMOVING: {
                    tasks.add(new DependencyUnavailableTask());
                    break;
                }
                case CANCELLED_to_REMOVED: {
                    break;
                }
                case REMOVING_to_REMOVED: {
                    tasks.add(new RemoveTask());
                    break;
                }
                case REMOVED_to_TERMINATED: {
                    this.getListenerTasks(LifecycleEvent.REMOVED, this.listenerTransitionTasks);
                    this.lifecycleListeners.clear();
                    break;
                }
                case DOWN_to_START_REQUESTED: {
                    break;
                }
                case PROBLEM_to_START_REQUESTED: {
                    tasks.add(new DependencyAvailableTask());
                    this.container.removeProblem(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeProblem(this);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.state = transition.getAfter();
        } while (tasks.isEmpty() && this.listenerTransitionTasks.isEmpty());
        this.notifyAll();
        if (tasks.size() <= 0) {
            this.postTransitionTasks(tasks);
        }
        return tasks;
    }

    private void getListenerTasks(LifecycleEvent event, List<Runnable> tasks) {
        for (LifecycleListener listener : this.lifecycleListeners) {
            tasks.add(new LifecycleListenerTask(listener, event));
        }
    }

    void doExecute(List<Runnable> tasks) {
        assert (!Thread.holdsLock(this));
        if (tasks.isEmpty()) {
            return;
        }
        Executor executor = this.container.getExecutor();
        for (Runnable task : tasks) {
            try {
                executor.execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
        }
    }

    @Override
    public void setMode(ServiceController.Mode newMode) {
        this.internalSetMode(null, newMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalSetMode(ServiceController.Mode expectedMode, ServiceController.Mode newMode) {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        if (newMode == null) {
            throw new IllegalArgumentException("newMode is null");
        }
        if (newMode != ServiceController.Mode.REMOVE && this.container.isShutdown()) {
            throw new IllegalArgumentException("Container is shutting down");
        }
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            ServiceController.Mode oldMode = this.mode;
            if (expectedMode != null && expectedMode != oldMode) {
                return false;
            }
            if (oldMode == newMode) {
                return true;
            }
            this.internalSetMode(newMode);
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
        return true;
    }

    private void internalSetMode(ServiceController.Mode newMode) {
        assert (Thread.holdsLock(this));
        ServiceController.Mode oldMode = this.mode;
        if (oldMode == ServiceController.Mode.REMOVE && this.state.compareTo(Substate.REMOVING) >= 0) {
            throw new IllegalStateException("Service already removed");
        }
        this.mode = newMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyAvailable() {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            assert (this.unavailableDependencies > 0);
            --this.unavailableDependencies;
            if (this.ignoreNotification() || this.unavailableDependencies != 0) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyUnavailable() {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            ++this.unavailableDependencies;
            if (this.ignoreNotification() || this.unavailableDependencies != 1) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    @Override
    public ServiceControllerImpl<?> getDependentController() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyUp() {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            assert (this.stoppingDependencies > 0);
            --this.stoppingDependencies;
            if (this.ignoreNotification() || this.stoppingDependencies != 0) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyDown() {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            ++this.stoppingDependencies;
            if (this.ignoreNotification() || this.stoppingDependencies != 1) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyFailed() {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            ++this.failCount;
            if (this.ignoreNotification() || this.failCount != 1) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencySucceeded() {
        List<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            assert (this.failCount > 0);
            --this.failCount;
            if (this.ignoreNotification() || this.failCount != 0) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    void dependentStarted() {
        this.dependentsStarted(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentsStarted(int count) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.runningDependents += count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentStopped() {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            assert (this.runningDependents > 0);
            --this.runningDependents;
            if (this.ignoreNotification() || this.runningDependents != 0) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    void newDependent(Dependent dependent) {
        assert (Thread.holdsLock(this));
        if (this.isFailed()) {
            dependent.dependencyFailed();
        }
        if (this.isUnavailable()) {
            dependent.dependencyUnavailable();
        }
        if (this.isUp()) {
            dependent.dependencyUp();
        }
    }

    private boolean isFailed() {
        assert (Thread.holdsLock(this));
        if (this.state == Substate.START_FAILED && this.finishedTask(16)) {
            return true;
        }
        if (this.state == Substate.STARTING && this.unfinishedTask(32)) {
            return true;
        }
        return this.state == Substate.DOWN && this.unfinishedTask(32);
    }

    private boolean isUnavailable() {
        assert (Thread.holdsLock(this));
        if (this.state == Substate.WAITING && this.finishedTask(2)) {
            return true;
        }
        if (this.state == Substate.WONT_START && this.finishedTask(2)) {
            return true;
        }
        if (this.state == Substate.REMOVING && this.finishedTask(2)) {
            return true;
        }
        if (this.state == Substate.PROBLEM && this.finishedTask(2)) {
            return true;
        }
        if (this.state == Substate.DOWN && this.unfinishedTask(1)) {
            return true;
        }
        if (this.state == Substate.START_REQUESTED && this.unfinishedTask(1)) {
            return true;
        }
        if (this.state == Substate.NEW || this.state == Substate.CANCELLED || this.state == Substate.REMOVED) {
            return true;
        }
        return this.state == Substate.TERMINATED;
    }

    private boolean isUp() {
        assert (Thread.holdsLock(this));
        if (this.state == Substate.UP && this.finishedTask(4)) {
            return true;
        }
        return this.state == Substate.STOP_REQUESTED && this.unfinishedTask(8);
    }

    private boolean unfinishedTask(int taskFlag) {
        assert (Thread.holdsLock(this));
        boolean taskScheduled = (this.execFlags & taskFlag << 16) != 0;
        boolean taskRunning = (this.execFlags & taskFlag) == 0;
        return taskScheduled && taskRunning;
    }

    private boolean finishedTask(int taskFlag) {
        assert (Thread.holdsLock(this));
        boolean taskUnscheduled = (this.execFlags & taskFlag << 16) == 0;
        boolean taskFinished = (this.execFlags & taskFlag) != 0;
        return taskUnscheduled || taskFinished;
    }

    void addDemand() {
        this.addDemands(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDemands(int demandedByCount) {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean propagate;
            boolean leavingRestState = this.isStableRestState();
            int cnt = this.demandedByCount;
            this.demandedByCount += demandedByCount;
            if (this.ignoreNotification()) {
                return;
            }
            boolean notStartedLazy = this.mode == ServiceController.Mode.LAZY && this.state != Substate.UP;
            boolean bl = propagate = cnt == 0 && (this.mode == ServiceController.Mode.ON_DEMAND || notStartedLazy || this.mode == ServiceController.Mode.PASSIVE);
            if (!propagate) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDemand() {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean propagate;
            boolean leavingRestState = this.isStableRestState();
            assert (this.demandedByCount > 0);
            int cnt = --this.demandedByCount;
            if (this.ignoreNotification()) {
                return;
            }
            boolean notStartedLazy = this.mode == ServiceController.Mode.LAZY && this.state != Substate.UP;
            boolean bl = propagate = cnt == 0 && (this.mode == ServiceController.Mode.ON_DEMAND || notStartedLazy || this.mode == ServiceController.Mode.PASSIVE);
            if (!propagate) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(ServiceControllerImpl<?> child) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.state.getState() != ServiceController.State.STARTING && this.state.getState() != ServiceController.State.UP) {
                throw new IllegalStateException("Children cannot be added in state " + (Object)((Object)this.state.getState()));
            }
            this.children.add(child);
            this.newDependent(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(ServiceControllerImpl<?> child) {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (!this.children.remove(child)) {
                return;
            }
            if (this.ignoreNotification() || this.children.size() > 0) {
                return;
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    Set<ServiceControllerImpl<?>> getChildren() {
        assert (Thread.holdsLock(this));
        return this.children;
    }

    @Override
    public ServiceControllerImpl<?> getParent() {
        return this.parent;
    }

    @Override
    public ServiceContainerImpl getServiceContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceController.State getState() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.state.getState();
        }
    }

    @Override
    public S getValue() throws IllegalStateException {
        if (!(this.service instanceof org.jboss.msc.service.Service)) {
            throw new UnsupportedOperationException();
        }
        return (S)((org.jboss.msc.service.Service)this.service).getValue();
    }

    @Override
    public S awaitValue() throws IllegalStateException, InterruptedException {
        assert (!Thread.holdsLock(this));
        if (!(this.service instanceof org.jboss.msc.service.Service)) {
            throw new UnsupportedOperationException();
        }
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            while (true) {
                switch (this.state.getState()) {
                    case UP: {
                        return (S)((org.jboss.msc.service.Service)this.service).getValue();
                    }
                    case START_FAILED: {
                        throw new IllegalStateException("Failed to start service", this.startException);
                    }
                    case REMOVED: {
                        throw new IllegalStateException("Service was removed");
                    }
                }
                this.wait();
            }
        }
    }

    @Override
    public S awaitValue(long time, TimeUnit unit) throws IllegalStateException, InterruptedException, TimeoutException {
        assert (!Thread.holdsLock(this));
        if (!(this.service instanceof org.jboss.msc.service.Service)) {
            throw new UnsupportedOperationException();
        }
        long then = System.nanoTime();
        long remaining = unit.toNanos(time);
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            long now;
            do {
                switch (this.state.getState()) {
                    case UP: {
                        return (S)((org.jboss.msc.service.Service)this.service).getValue();
                    }
                    case START_FAILED: {
                        throw new IllegalStateException("Failed to start service", this.startException);
                    }
                    case REMOVED: {
                        throw new IllegalStateException("Service was removed");
                    }
                }
                this.wait(remaining / 1000000L, (int)(remaining % 1000000L));
            } while ((remaining -= (now = System.nanoTime()) - (then = now)) > 0L);
            throw new TimeoutException("Operation timed out");
        }
    }

    @Override
    public org.jboss.msc.service.Service<S> getService() throws IllegalStateException {
        if (!(this.service instanceof org.jboss.msc.service.Service)) {
            throw new UnsupportedOperationException();
        }
        return (org.jboss.msc.service.Service)this.service;
    }

    @Override
    public ServiceName getName() {
        return this.serviceId;
    }

    @Override
    public ServiceName[] getAliases() {
        return (ServiceName[])this.serviceAliases.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(ContainerShutdownListener listener) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.state == Substate.TERMINATED && this.asyncTasks == 0) {
                return;
            }
            if (this.shutdownListener != null) {
                return;
            }
            this.shutdownListener = listener;
            this.shutdownListener.controllerAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(LifecycleListener listener) {
        List<Runnable> tasks;
        if (listener == null) {
            return;
        }
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (this.lifecycleListeners.contains(listener)) {
                return;
            }
            this.lifecycleListeners.add(listener);
            if (this.state == Substate.NEW) {
                return;
            }
            if (this.state == Substate.UP) {
                this.listenerTransitionTasks.add(new LifecycleListenerTask(listener, LifecycleEvent.UP));
            } else if (this.state == Substate.DOWN) {
                this.listenerTransitionTasks.add(new LifecycleListenerTask(listener, LifecycleEvent.DOWN));
            } else if (this.state == Substate.START_FAILED) {
                this.listenerTransitionTasks.add(new LifecycleListenerTask(listener, LifecycleEvent.FAILED));
            } else if (this.state == Substate.TERMINATED) {
                this.listenerTransitionTasks.add(new LifecycleListenerTask(listener, LifecycleEvent.REMOVED));
            }
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(LifecycleListener listener) {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.lifecycleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartException getStartException() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.startException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retry() {
        List<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (this.failCount > 0 || this.state.getState() != ServiceController.State.START_FAILED) {
                return;
            }
            this.startException = null;
            tasks = this.transition();
            this.addAsyncTasks(tasks.size());
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ServiceName> getUnavailableDependencies() {
        IdentityHashSet<ServiceName> retVal = new IdentityHashSet<ServiceName>();
        for (Dependency dependency : this.requires) {
            Lockable lockable = dependency.getLock();
            synchronized (lockable) {
                if (ServiceControllerImpl.isUnavailable(dependency)) {
                    retVal.add(dependency.getName());
                }
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUnavailable(Dependency dependency) {
        ServiceControllerImpl<?> controller = dependency.getDependencyController();
        if (controller == null) {
            return true;
        }
        ServiceControllerImpl<?> serviceControllerImpl = controller;
        synchronized (serviceControllerImpl) {
            return super.isUnavailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceController.Mode getMode() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.mode;
        }
    }

    @Override
    public boolean compareAndSetMode(ServiceController.Mode expectedMode, ServiceController.Mode newMode) {
        if (expectedMode == null) {
            throw new IllegalArgumentException("expectedMode is null");
        }
        return this.internalSetMode(expectedMode, newMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceStatus getStatus() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            String[] dependencyNames;
            String[] aliases;
            String parentName = this.parent == null ? null : this.parent.getName().getCanonicalName();
            String name = this.getName().getCanonicalName();
            ServiceName[] aliasNames = this.getAliases();
            int aliasLength = aliasNames.length;
            if (aliasLength == 0) {
                aliases = NO_STRINGS;
            } else {
                aliases = new String[aliasLength];
                for (int i = 0; i < aliasLength; ++i) {
                    aliases[i] = aliasNames[i].getCanonicalName();
                }
            }
            String serviceClass = this.service.getClass().getName();
            Set<Dependency> dependencies = this.requires;
            int dependenciesLength = dependencies.size();
            if (dependenciesLength == 0) {
                dependencyNames = NO_STRINGS;
            } else {
                dependencyNames = new String[dependenciesLength];
                int i = 0;
                for (Dependency dependency : dependencies) {
                    dependencyNames[i++] = dependency.getName().getCanonicalName();
                }
            }
            StartException startException = this.startException;
            return new ServiceStatus(parentName, name, aliases, serviceClass, this.mode.name(), this.state.getState().name(), this.state.name(), dependencyNames, this.failCount != 0, startException != null ? startException.toString() : null, this.unavailableDependencies > 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    String dumpServiceDetails() {
        StringBuilder b = new StringBuilder();
        IdentityHashSet<Dependent> dependents = new IdentityHashSet<Dependent>();
        for (Object registration : this.provides.keySet()) {
            ServiceRegistrationImpl serviceRegistrationImpl = registration;
            synchronized (serviceRegistrationImpl) {
                dependents.addAll(((ServiceRegistrationImpl)registration).getDependents());
            }
            b.append("Service Name: ").append(((ServiceRegistrationImpl)registration).getName().toString()).append(" - Dependents: ").append(dependents.size()).append('\n');
            for (Dependent dependent : dependents) {
                ServiceControllerImpl<?> controller;
                ServiceControllerImpl<?> serviceControllerImpl = controller = dependent.getDependentController();
                synchronized (serviceControllerImpl) {
                    b.append("        ").append(controller.getName().toString()).append(" - State: ").append((Object)controller.state.getState()).append(" (Substate: ").append((Object)controller.state).append(")\n");
                }
            }
        }
        Iterator<Dependency> iterator = this;
        synchronized (iterator) {
            void var5_11;
            b.append("Children: ").append(this.children.size()).append('\n');
            for (ServiceControllerImpl serviceControllerImpl : this.children) {
                Dependent dependent;
                dependent = serviceControllerImpl;
                synchronized (dependent) {
                    b.append("    ").append(serviceControllerImpl.getName().toString()).append(" - State: ").append((Object)serviceControllerImpl.state.getState()).append(" (Substate: ").append((Object)serviceControllerImpl.state).append(")\n");
                }
            }
            Substate state = this.state;
            b.append("State: ").append((Object)state.getState()).append(" (Substate: ").append((Object)state).append(")\n");
            if (this.parent != null) {
                b.append("Parent name: ").append(this.parent.getName()).append('\n');
            }
            b.append("Service Mode: ").append((Object)this.mode).append('\n');
            if (this.startException != null) {
                b.append("Start Exception: ").append(this.startException.getClass().getName()).append(" (Message: ").append(this.startException.getMessage()).append(")\n");
            }
            String string = "(indeterminate)";
            Object serviceObjectClass = "(indeterminate)";
            try {
                Service serviceObject = this.service;
                if (serviceObject != null) {
                    serviceObjectClass = serviceObject.getClass();
                    String string2 = serviceObject.toString();
                }
            }
            catch (Throwable serviceObject) {
                // empty catch block
            }
            b.append("Service Object: ").append((String)var5_11).append('\n');
            b.append("Service Object Class: ").append(serviceObjectClass).append('\n');
            b.append("Demanded By: ").append(this.demandedByCount).append('\n');
            b.append("Stopping Dependencies: ").append(this.stoppingDependencies).append('\n');
            b.append("Running Dependents: ").append(this.runningDependents).append('\n');
            b.append("Fail Count: ").append(this.failCount).append('\n');
            b.append("Unavailable Dep Count: ").append(this.unavailableDependencies).append('\n');
            b.append("Dependencies Demanded: ").append(this.dependenciesDemanded ? "yes" : "no").append('\n');
            b.append("Async Tasks: ").append(this.asyncTasks).append('\n');
            if (this.lifecycleTime != 0L) {
                long elapsedNanos = System.nanoTime() - this.lifecycleTime;
                long now = System.currentTimeMillis();
                long stamp = now - elapsedNanos / 1000000L;
                b.append("Lifecycle Timestamp: ").append(this.lifecycleTime).append(String.format(" = %tb %<td %<tH:%<tM:%<tS.%<tL%n", stamp));
            }
        }
        b.append("Dependencies: ").append(this.requires.size()).append('\n');
        for (Dependency dependency : this.requires) {
            ServiceControllerImpl<?> serviceControllerImpl = dependency.getDependencyController();
            b.append("    ").append(dependency.getName().toString());
            if (serviceControllerImpl == null) {
                b.append(" (missing)\n");
                continue;
            }
            ServiceControllerImpl<?> serviceControllerImpl2 = serviceControllerImpl;
            synchronized (serviceControllerImpl2) {
                b.append(" - State: ").append((Object)serviceControllerImpl.state.getState()).append(" (Substate: ").append((Object)serviceControllerImpl.state).append(")\n");
            }
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMonitor(StabilityMonitor monitor) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (!this.monitors.add(monitor)) {
                return;
            }
            if (!this.isStableRestState()) {
                monitor.incrementUnstableServices();
            }
            if (this.state == Substate.START_FAILED) {
                monitor.addFailed(this);
            } else if (this.state == Substate.PROBLEM) {
                monitor.addProblem(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMonitor(StabilityMonitor monitor) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (!this.monitors.remove(monitor)) {
                return;
            }
            if (!this.isStableRestState()) {
                monitor.decrementUnstableServices();
            }
            monitor.removeProblem(this);
            monitor.removeFailed(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMonitorNoCallback(StabilityMonitor monitor) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.monitors.remove(monitor);
        }
    }

    Set<StabilityMonitor> getMonitors() {
        assert (Thread.holdsLock(this));
        return this.monitors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Substate getSubstate() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.state;
        }
    }

    Collection<ServiceRegistrationImpl> getRegistrations() {
        return this.provides.keySet();
    }

    private void checkProvidedValues() {
        for (Map.Entry<ServiceRegistrationImpl, WritableValueImpl> entry : this.provides.entrySet()) {
            WritableValueImpl injector = entry.getValue();
            if (injector == null || injector.value != null) continue;
            throw new IllegalStateException("Injector for " + entry.getKey().getName() + " was not initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inject(ValueInjection<?>[] injections) {
        int i;
        boolean ok = false;
        try {
            for (i = 0; i < injections.length; ++i) {
                this.inject(injections[i]);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                while (i >= 0) {
                    this.uninject(injections[i]);
                    --i;
                }
            }
        }
    }

    private <T> void inject(ValueInjection<T> injection) {
        try {
            injection.getTarget().inject(injection.getSource().getValue());
        }
        catch (Throwable t) {
            ServiceLogger.SERVICE.injectFailed(t, this.getName());
            throw t;
        }
    }

    private void uninject(ValueInjection<?>[] injections) {
        for (ValueInjection<?> injection : injections) {
            this.uninject(injection);
        }
    }

    private <T> void uninject(ValueInjection<T> injection) {
        try {
            injection.getTarget().uninject();
        }
        catch (Throwable t) {
            ServiceLogger.ROOT.uninjectFailed(t, this.getName(), injection);
        }
    }

    private void uninjectProvides(Collection<WritableValueImpl> injectors) {
        for (WritableValueImpl injector : injectors) {
            if (injector == null) continue;
            injector.uninject();
        }
    }

    public String toString() {
        return String.format("Controller for %s@%x", this.getName(), this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFailed(StartException e, StartContextImpl context) {
        ServiceLogger.FAIL.startFailed(e, this.getName());
        Object object = context.lock;
        synchronized (object) {
            context.state |= 0xA;
            ServiceControllerImpl serviceControllerImpl = this;
            synchronized (serviceControllerImpl) {
                this.startException = e;
            }
        }
        this.uninject(this.injections);
        this.uninjectProvides(this.provides.values());
    }

    private void addAsyncTasks(int size) {
        assert (Thread.holdsLock(this));
        assert (size >= 0);
        if (size > 0) {
            this.asyncTasks += size;
        }
    }

    private void incrementAsyncTasks() {
        assert (Thread.holdsLock(this));
        ++this.asyncTasks;
    }

    private void decrementAsyncTasks() {
        assert (Thread.holdsLock(this));
        assert (this.asyncTasks > 0);
        --this.asyncTasks;
    }

    private final class ChildServiceTarget
    extends ServiceTargetImpl {
        private volatile boolean valid;

        private ChildServiceTarget(ServiceTargetImpl parentTarget) {
            super(parentTarget);
            this.valid = true;
        }

        @Override
        <T> ServiceController<T> install(ServiceBuilderImpl<T> serviceBuilder) throws ServiceRegistryException {
            if (!this.valid) {
                throw new IllegalStateException("Service target is no longer valid");
            }
            return super.install(serviceBuilder);
        }

        @Override
        protected <T> ServiceBuilder<T> createServiceBuilder(ServiceName name, org.jboss.msc.service.Service<T> service, ServiceControllerImpl<?> parent) {
            return super.createServiceBuilder(name, service, ServiceControllerImpl.this);
        }

        @Override
        protected ServiceBuilder<?> createServiceBuilder(ServiceName name, ServiceControllerImpl<?> parent) {
            return super.createServiceBuilder(name, ServiceControllerImpl.this);
        }

        @Override
        public ServiceTarget subTarget() {
            return new ChildServiceTarget(this);
        }
    }

    private final class StopContextImpl
    extends AbstractContext
    implements StopContext {
        private StopContextImpl() {
        }

        @Override
        void onComplete() {
            ServiceControllerImpl.this.uninject(ServiceControllerImpl.this.injections);
            ServiceControllerImpl.this.uninjectProvides(ServiceControllerImpl.this.provides.values());
        }
    }

    private final class StartContextImpl
    extends AbstractContext
    implements StartContext {
        private StartContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(StartException reason) throws IllegalStateException {
            int state;
            if (reason == null) {
                reason = new StartException("Start failed, and additionally, a null cause was supplied");
            }
            ServiceName serviceName = ServiceControllerImpl.this.getName();
            reason.setServiceName(serviceName);
            ServiceLogger.FAIL.startFailed(reason, serviceName);
            Object object = this.lock;
            synchronized (object) {
                state = this.setState(8);
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ServiceControllerImpl.this.startException = reason;
                }
            }
            if ((state & 2) != 0) {
                ServiceControllerImpl.this.uninject(ServiceControllerImpl.this.injections);
                ServiceControllerImpl.this.uninjectProvides(ServiceControllerImpl.this.provides.values());
                this.taskCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServiceTarget getChildTarget() {
            Object object = this.lock;
            synchronized (object) {
                if ((this.state & 0xC) != 0) {
                    throw new IllegalStateException("Lifecycle context is no longer valid");
                }
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    if (ServiceControllerImpl.this.childTarget == null) {
                        ServiceControllerImpl.this.childTarget = new ChildServiceTarget(ServiceControllerImpl.this.container);
                    }
                    return ServiceControllerImpl.this.childTarget;
                }
            }
        }

        @Override
        void onComplete() {
            try {
                ServiceControllerImpl.this.checkProvidedValues();
            }
            catch (Throwable t) {
                ServiceControllerImpl.this.startFailed(new StartException("Failed to start service", t, ServiceControllerImpl.this.getName()), this);
            }
        }
    }

    private abstract class AbstractContext
    implements LifecycleContext {
        static final int ASYNC = 1;
        static final int CLOSED = 2;
        static final int COMPLETED = 4;
        static final int FAILED = 8;
        int state;
        final Object lock = new Object();

        private AbstractContext() {
        }

        abstract void onComplete();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final int setState(int newState) {
            Object object = this.lock;
            synchronized (object) {
                if ((newState & 1) != 0 && ((this.state & 1) != 0 || (this.state & 2) != 0) || (newState & 0xC) != 0 && (this.state & 0xC) != 0 || (newState & 0xC) != 0 && (this.state & 2) != 0 && (this.state & 1) == 0) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                return this.state |= newState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void taskCompleted() {
            List tasks;
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                ServiceControllerImpl.this.decrementAsyncTasks();
                tasks = ServiceControllerImpl.this.transition();
                ServiceControllerImpl.this.addAsyncTasks(tasks.size());
                ServiceControllerImpl.this.updateStabilityState(leavingRestState);
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        @Override
        public final void complete() {
            int state = this.setState(4);
            if ((state & 2) != 0) {
                this.onComplete();
                this.taskCompleted();
            }
        }

        @Override
        public final void asynchronous() {
            this.setState(1);
        }

        @Override
        public final long getElapsedTime() {
            return System.nanoTime() - ServiceControllerImpl.this.lifecycleTime;
        }

        @Override
        public final ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void execute(final Runnable command) {
            if (command == null) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if ((this.state & 0xC) != 0) {
                    throw new IllegalStateException("Lifecycle context is no longer valid");
                }
                ServiceControllerImpl.this.doExecute(Collections.singletonList(new Runnable(){

                    @Override
                    public void run() {
                        ClassLoader contextClassLoader = SecurityUtils.setTCCL(SecurityUtils.getCL(command.getClass()));
                        try {
                            command.run();
                        }
                        finally {
                            SecurityUtils.setTCCL(contextClassLoader);
                        }
                    }
                }));
            }
        }
    }

    private final class RemoveTask
    extends ControllerTask {
        private RemoveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean execute() {
            boolean removeRegistration;
            Lockable lockable;
            Lockable lock;
            assert (ServiceControllerImpl.this.getMode() == ServiceController.Mode.REMOVE);
            assert (ServiceControllerImpl.this.getSubstate() == Substate.REMOVED || ServiceControllerImpl.this.getSubstate() == Substate.CANCELLED);
            for (Map.Entry provided : ServiceControllerImpl.this.provides.entrySet()) {
                ServiceRegistrationImpl registration = (ServiceRegistrationImpl)provided.getKey();
                WritableValueImpl injector = (WritableValueImpl)provided.getValue();
                lockable = lock = registration.getLock();
                synchronized (lockable) {
                    lock.acquireWrite();
                    try {
                        if (injector != null) {
                            injector.setInstance(null);
                        }
                        if (removeRegistration = registration.clear(ServiceControllerImpl.this)) {
                            ServiceControllerImpl.this.container.removeRegistration(registration.getName());
                        }
                    }
                    finally {
                        lock.releaseWrite();
                    }
                }
            }
            for (Dependency dependency : ServiceControllerImpl.this.requires) {
                lockable = lock = dependency.getLock();
                synchronized (lockable) {
                    lock.acquireWrite();
                    try {
                        removeRegistration = dependency.removeDependent(ServiceControllerImpl.this);
                        if (removeRegistration) {
                            ServiceControllerImpl.this.container.removeRegistration(dependency.getName());
                        }
                    }
                    finally {
                        lock.releaseWrite();
                    }
                }
            }
            if (ServiceControllerImpl.this.parent != null) {
                ServiceControllerImpl.this.parent.removeChild(ServiceControllerImpl.this);
            }
            return true;
        }
    }

    private final class RemoveChildrenTask
    extends ControllerTask {
        private RemoveChildrenTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean execute() {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                for (ServiceControllerImpl child : ServiceControllerImpl.this.children) {
                    child.setMode(ServiceController.Mode.REMOVE);
                }
            }
            return true;
        }
    }

    private final class LifecycleListenerTask
    extends ControllerTask {
        private final LifecycleListener listener;
        private final LifecycleEvent event;

        LifecycleListenerTask(LifecycleListener listener, LifecycleEvent event) {
            this.listener = listener;
            this.event = event;
        }

        @Override
        boolean execute() {
            ClassLoader oldCL = SecurityUtils.setTCCL(SecurityUtils.getCL(this.listener.getClass()));
            try {
                this.listener.handleEvent(ServiceControllerImpl.this, this.event);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.listenerFailed(t, this.listener);
            }
            finally {
                SecurityUtils.setTCCL(oldCL);
            }
            return true;
        }
    }

    private final class StopTask
    extends ControllerTask {
        private StopTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean execute() {
            Object object;
            StopContextImpl context = new StopContextImpl();
            boolean ok = false;
            try {
                this.stopService(ServiceControllerImpl.this.service, context);
                ok = true;
                object = context.lock;
            }
            catch (Throwable t) {
                Object object2;
                try {
                    ServiceLogger.FAIL.stopFailed(t, ServiceControllerImpl.this.getName());
                    object2 = context.lock;
                }
                catch (Throwable throwable) {
                    Object object3 = context.lock;
                    synchronized (object3) {
                        context.state |= 2;
                        if (ok & (context.state & 1) != 0) {
                            if ((context.state & 4) == 0) {
                                return false;
                            }
                        } else if ((context.state & 4) == 0) {
                            context.state |= 4;
                        }
                    }
                    ServiceControllerImpl.this.uninject(ServiceControllerImpl.this.injections);
                    ServiceControllerImpl.this.uninjectProvides(ServiceControllerImpl.this.provides.values());
                    throw throwable;
                }
                synchronized (object2) {
                    context.state |= 2;
                    if (ok & (context.state & 1) != 0) {
                        if ((context.state & 4) == 0) {
                            return false;
                        }
                    } else if ((context.state & 4) == 0) {
                        context.state |= 4;
                    }
                }
                ServiceControllerImpl.this.uninject(ServiceControllerImpl.this.injections);
                ServiceControllerImpl.this.uninjectProvides(ServiceControllerImpl.this.provides.values());
            }
            synchronized (object) {
                context.state |= 2;
                if (ok & (context.state & 1) != 0) {
                    if ((context.state & 4) == 0) {
                        return false;
                    }
                } else if ((context.state & 4) == 0) {
                    context.state |= 4;
                }
            }
            ServiceControllerImpl.this.uninject(ServiceControllerImpl.this.injections);
            ServiceControllerImpl.this.uninjectProvides(ServiceControllerImpl.this.provides.values());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopService(Service service, StopContext context) {
            ClassLoader contextClassLoader = SecurityUtils.setTCCL(SecurityUtils.getCL(service.getClass()));
            try {
                service.stop(context);
            }
            finally {
                SecurityUtils.setTCCL(contextClassLoader);
            }
        }
    }

    private final class StartTask
    extends ControllerTask {
        private StartTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean execute() {
            StartContextImpl context = new StartContextImpl();
            try {
                boolean startFailed;
                ServiceControllerImpl.this.inject(ServiceControllerImpl.this.injections);
                this.startService(ServiceControllerImpl.this.service, context);
                Object object = context.lock;
                synchronized (object) {
                    context.state |= 2;
                    if ((context.state & 1) != 0) {
                        if ((context.state & 0xC) == 0) {
                            return false;
                        }
                    } else if ((context.state & 0xC) == 0) {
                        context.state |= 4;
                    }
                    startFailed = (context.state & 8) != 0;
                }
                if (startFailed) {
                    ServiceControllerImpl.this.uninject(ServiceControllerImpl.this.injections);
                    ServiceControllerImpl.this.uninjectProvides(ServiceControllerImpl.this.provides.values());
                } else {
                    ServiceControllerImpl.this.checkProvidedValues();
                }
            }
            catch (StartException e) {
                e.setServiceName(ServiceControllerImpl.this.getName());
                ServiceControllerImpl.this.startFailed(e, context);
            }
            catch (Throwable t) {
                ServiceControllerImpl.this.startFailed(new StartException("Failed to start service", t, ServiceControllerImpl.this.getName()), context);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startService(Service service, StartContext context) throws StartException {
            ClassLoader contextClassLoader = SecurityUtils.setTCCL(SecurityUtils.getCL(service.getClass()));
            try {
                service.start(context);
            }
            finally {
                SecurityUtils.setTCCL(contextClassLoader);
            }
        }
    }

    private final class DependencyRetryingTask
    extends DependentsControllerTask {
        private DependencyRetryingTask() {
            super(32);
        }

        @Override
        void inform(Dependent dependent) {
            dependent.dependencySucceeded();
        }
    }

    private final class DependencyFailedTask
    extends DependentsControllerTask {
        private DependencyFailedTask() {
            super(16);
        }

        @Override
        void inform(Dependent dependent) {
            dependent.dependencyFailed();
        }
    }

    private final class DependencyStoppedTask
    extends DependentsControllerTask {
        private DependencyStoppedTask() {
            super(8);
        }

        @Override
        void inform(Dependent dependent) {
            dependent.dependencyDown();
        }
    }

    private final class DependencyStartedTask
    extends DependentsControllerTask {
        private DependencyStartedTask() {
            super(4);
        }

        @Override
        void inform(Dependent dependent) {
            dependent.dependencyUp();
        }
    }

    private final class DependencyUnavailableTask
    extends DependentsControllerTask {
        DependencyUnavailableTask() {
            super(2);
        }

        @Override
        void inform(Dependent dependent) {
            dependent.dependencyUnavailable();
        }
    }

    private final class DependencyAvailableTask
    extends DependentsControllerTask {
        DependencyAvailableTask() {
            super(1);
        }

        @Override
        void inform(Dependent dependent) {
            dependent.dependencyAvailable();
        }
    }

    private final class DependentStoppedTask
    extends DependenciesControllerTask {
        private DependentStoppedTask() {
        }

        @Override
        void inform(Dependency dependency) {
            dependency.dependentStopped();
        }

        @Override
        void inform(ServiceControllerImpl parent) {
            parent.dependentStopped();
        }
    }

    private final class DependentStartedTask
    extends DependenciesControllerTask {
        private DependentStartedTask() {
        }

        @Override
        void inform(Dependency dependency) {
            dependency.dependentStarted();
        }

        @Override
        void inform(ServiceControllerImpl parent) {
            parent.dependentStarted();
        }
    }

    private final class UndemandDependenciesTask
    extends DependenciesControllerTask {
        private UndemandDependenciesTask() {
        }

        @Override
        void inform(Dependency dependency) {
            dependency.removeDemand();
        }

        @Override
        void inform(ServiceControllerImpl parent) {
            parent.removeDemand();
        }
    }

    private final class DemandDependenciesTask
    extends DependenciesControllerTask {
        private DemandDependenciesTask() {
        }

        @Override
        void inform(Dependency dependency) {
            dependency.addDemand();
        }

        @Override
        void inform(ServiceControllerImpl parent) {
            parent.addDemand();
        }
    }

    private abstract class DependentsControllerTask
    extends ControllerTask {
        private final int execFlag;

        private DependentsControllerTask(int execFlag) {
            this.execFlag = execFlag;
            ServiceControllerImpl.this.execFlags = ServiceControllerImpl.this.execFlags | execFlag << 16;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean execute() {
            for (ServiceRegistrationImpl registration : ServiceControllerImpl.this.provides.keySet()) {
                for (Dependent dependent : registration.getDependents()) {
                    this.inform(dependent);
                }
            }
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                for (Dependent child : ServiceControllerImpl.this.children) {
                    this.inform(child);
                }
                ServiceControllerImpl.this.execFlags = ServiceControllerImpl.this.execFlags | this.execFlag;
            }
            return true;
        }

        void inform(Dependent dependent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void beforeExecute() {
            for (ServiceRegistrationImpl registration : ServiceControllerImpl.this.provides.keySet()) {
                Lockable lock;
                Lockable lockable = lock = registration.getLock();
                synchronized (lockable) {
                    lock.acquireRead();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void afterExecute() {
            for (ServiceRegistrationImpl registration : ServiceControllerImpl.this.provides.keySet()) {
                Lockable lock;
                Lockable lockable = lock = registration.getLock();
                synchronized (lockable) {
                    lock.releaseRead();
                }
            }
        }
    }

    private abstract class DependenciesControllerTask
    extends ControllerTask {
        private DependenciesControllerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean execute() {
            for (Dependency dependency : ServiceControllerImpl.this.requires) {
                Lockable lock;
                Lockable lockable = lock = dependency.getLock();
                synchronized (lockable) {
                    lock.acquireWrite();
                    try {
                        this.inform(dependency);
                    }
                    finally {
                        lock.releaseWrite();
                    }
                }
            }
            if (ServiceControllerImpl.this.parent != null) {
                this.inform(ServiceControllerImpl.this.parent);
            }
            return true;
        }

        abstract void inform(Dependency var1);

        abstract void inform(ServiceControllerImpl var1);
    }

    private abstract class ControllerTask
    implements Runnable {
        private ControllerTask() {
            assert (Thread.holdsLock(ServiceControllerImpl.this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            assert (!Thread.holdsLock(ServiceControllerImpl.this));
            try {
                List tasks;
                this.beforeExecute();
                if (!this.execute()) {
                    return;
                }
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.decrementAsyncTasks();
                    tasks = ServiceControllerImpl.this.transition();
                    ServiceControllerImpl.this.addAsyncTasks(tasks.size());
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.getName());
            }
            finally {
                this.afterExecute();
            }
        }

        void afterExecute() {
        }

        void beforeExecute() {
        }

        abstract boolean execute();
    }
}

