/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceBuilderImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistrationImpl;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.value.Value;

class ServiceTargetImpl
implements ServiceTarget {
    private final ServiceTargetImpl parent;
    private final Set<LifecycleListener> lifecycleListeners = Collections.synchronizedSet(new IdentityHashSet());
    private final Set<ServiceName> dependencies = Collections.synchronizedSet(new HashSet());
    private final Set<StabilityMonitor> monitors = Collections.synchronizedSet(new IdentityHashSet());

    ServiceTargetImpl(ServiceTargetImpl parent) {
        if (parent == null) {
            throw new IllegalStateException("parent is null");
        }
        this.parent = parent;
    }

    ServiceTargetImpl() {
        this.parent = null;
    }

    @Override
    public <T> ServiceBuilder<T> addServiceValue(ServiceName name, Value<? extends Service<T>> value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        Service<T> service = value.getValue();
        return this.createServiceBuilder(name, service != null ? service : Service.NULL, null);
    }

    protected <T> ServiceBuilder<T> createServiceBuilder(ServiceName name, Service<T> service, ServiceControllerImpl<?> parent) throws IllegalArgumentException {
        return new ServiceBuilderImpl<T>(name, this, service, parent);
    }

    protected ServiceBuilder<?> createServiceBuilder(ServiceName name, ServiceControllerImpl<?> parent) throws IllegalArgumentException {
        return new ServiceBuilderImpl(name, this, parent);
    }

    @Override
    public <T> ServiceBuilder<T> addService(ServiceName name, Service<T> service) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (service == null) {
            throw new IllegalArgumentException("service is null");
        }
        return this.createServiceBuilder(name, service, null);
    }

    @Override
    public ServiceBuilder<?> addService(ServiceName name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return this.createServiceBuilder(name, null);
    }

    @Override
    public ServiceTarget addListener(LifecycleListener listener) {
        if (listener != null) {
            this.lifecycleListeners.add(listener);
        }
        return this;
    }

    @Override
    public ServiceTarget addMonitor(StabilityMonitor monitor) {
        if (monitor != null) {
            this.monitors.add(monitor);
        }
        return this;
    }

    @Override
    public ServiceTarget removeMonitor(StabilityMonitor monitor) {
        if (monitor != null) {
            this.monitors.remove(monitor);
        }
        return this;
    }

    @Override
    public ServiceTarget removeListener(LifecycleListener listener) {
        if (listener != null) {
            this.lifecycleListeners.remove(listener);
        }
        return this;
    }

    @Override
    public ServiceTarget addDependency(ServiceName dependency) {
        if (dependency == null) {
            return this;
        }
        this.dependencies.add(dependency);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(ServiceBuilderImpl<?> serviceBuilder) {
        Set<Object> set = this.monitors;
        synchronized (set) {
            serviceBuilder.addMonitorsNoCheck(this.monitors);
        }
        set = this.lifecycleListeners;
        synchronized (set) {
            serviceBuilder.addLifecycleListenersNoCheck(this.lifecycleListeners);
        }
        set = this.dependencies;
        synchronized (set) {
            serviceBuilder.addDependenciesNoCheck(this.dependencies);
        }
    }

    <T> ServiceController<T> install(ServiceBuilderImpl<T> serviceBuilder) throws ServiceRegistryException {
        this.apply(serviceBuilder);
        return this.parent.install(serviceBuilder);
    }

    ServiceRegistrationImpl getOrCreateRegistration(ServiceName name) {
        return this.parent.getOrCreateRegistration(name);
    }

    @Override
    public ServiceTarget subTarget() {
        return new ServiceTargetImpl(this);
    }
}

