/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.Substate;

enum Transition {
    START_REQUESTED_to_DOWN(Substate.START_REQUESTED, Substate.DOWN),
    DOWN_to_PROBLEM(Substate.DOWN, Substate.PROBLEM),
    DOWN_to_START_REQUESTED(Substate.DOWN, Substate.START_REQUESTED),
    PROBLEM_to_DOWN(Substate.PROBLEM, Substate.DOWN),
    START_REQUESTED_to_STARTING(Substate.START_REQUESTED, Substate.STARTING),
    STARTING_to_UP(Substate.STARTING, Substate.UP),
    STARTING_to_START_FAILED(Substate.STARTING, Substate.START_FAILED),
    START_FAILED_to_STARTING(Substate.START_FAILED, Substate.STARTING),
    START_FAILED_to_DOWN(Substate.START_FAILED, Substate.DOWN),
    UP_to_STOP_REQUESTED(Substate.UP, Substate.STOP_REQUESTED),
    STOP_REQUESTED_to_UP(Substate.STOP_REQUESTED, Substate.UP),
    STOP_REQUESTED_to_STOPPING(Substate.STOP_REQUESTED, Substate.STOPPING),
    STOPPING_to_DOWN(Substate.STOPPING, Substate.DOWN),
    REMOVING_to_REMOVED(Substate.REMOVING, Substate.REMOVED),
    DOWN_to_REMOVING(Substate.DOWN, Substate.REMOVING),
    NEW_to_DOWN(Substate.NEW, Substate.DOWN);

    private final Substate before;
    private final Substate after;

    private Transition(Substate before, Substate after) {
        this.before = before;
        this.after = after;
    }

    public boolean leavesRestState() {
        return this.before.isRestState() && !this.after.isRestState();
    }

    public boolean entersRestState() {
        return !this.before.isRestState() && this.after.isRestState();
    }

    public boolean enters(ServiceController.State state) {
        return this.before.getState() != state && this.after.getState() == state;
    }

    public boolean exits(ServiceController.State state) {
        return this.before.getState() == state && this.after.getState() != state;
    }

    public boolean retains(ServiceController.State state) {
        return this.before.getState() == state && this.after.getState() == state;
    }

    public Substate getBefore() {
        return this.before;
    }

    public Substate getAfter() {
        return this.after;
    }

    public boolean in(Transition ... transitions) {
        for (Transition test : transitions) {
            if (this != test) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "transition from " + this.before.name() + " to " + this.after.name();
    }
}

