/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.monitor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitor;
import javax.management.monitor.GaugeMonitor;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.StringMonitor;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jboss.test.jmx.compliance.monitor.support.CounterSupport;
import org.jboss.test.jmx.compliance.monitor.support.GaugeSupport;
import org.jboss.test.jmx.compliance.monitor.support.MonitorSupport;
import org.jboss.test.jmx.compliance.monitor.support.StringSupport;

public class MonitorTestCase
extends TestCase
implements NotificationListener {
    MBeanServer server;
    ObjectName monitorName;
    Monitor monitor;
    ObjectName monitoredName;
    MonitorSupport monitored;
    ArrayList notifications = new ArrayList();

    public MonitorTestCase(String s) {
        super(s);
    }

    public void testNotificationTypes() {
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.attribute", (String)"jmx.monitor.error.attribute");
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.type", (String)"jmx.monitor.error.type");
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.mbean", (String)"jmx.monitor.error.mbean");
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.runtime", (String)"jmx.monitor.error.runtime");
        MonitorTestCase.assertEquals((String)"jmx.monitor.string.differs", (String)"jmx.monitor.string.differs");
        MonitorTestCase.assertEquals((String)"jmx.monitor.string.matches", (String)"jmx.monitor.string.matches");
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.threshold", (String)"jmx.monitor.error.threshold");
        MonitorTestCase.assertEquals((String)"jmx.monitor.gauge.high", (String)"jmx.monitor.gauge.high");
        MonitorTestCase.assertEquals((String)"jmx.monitor.gauge.low", (String)"jmx.monitor.gauge.low");
        MonitorTestCase.assertEquals((String)"jmx.monitor.counter.threshold", (String)"jmx.monitor.counter.threshold");
    }

    public void testCounterNotificationInfo() throws Exception {
        HashSet<String> expected = new HashSet<String>();
        expected.add("jmx.monitor.error.attribute");
        expected.add("jmx.monitor.error.type");
        expected.add("jmx.monitor.error.mbean");
        expected.add("jmx.monitor.error.runtime");
        expected.add("jmx.monitor.error.threshold");
        expected.add("jmx.monitor.counter.threshold");
        MBeanNotificationInfo[] mbni = new CounterMonitor().getNotificationInfo();
        this.checkNotificationInfo("Counter", mbni, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededEarlyNoOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(0), new Integer(0));
            this.expectStartMonitor(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededLateNoOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(0), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededManyNoOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(0), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(0));
            this.expect(new Integer(11), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdNotExceededNoOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(0), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.dontExpect(new Integer(1));
            this.dontExpect(new Integer(-1));
            this.dontExpect(new Integer(9));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(10));
            this.dontExpect(new Integer(11));
            this.dontExpect(new Integer(9));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(9));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededNoneNoOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(false, new Integer(10), false, new Integer(0), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.dontExpect(new Integer(10));
            this.dontExpect(new Integer(0));
            this.dontExpect(new Integer(10));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededEarlyOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(0));
            this.expectStartMonitor(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededLateOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededManyOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(0));
            this.dontExpect(new Integer(11));
            this.expect(new Integer(20), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(29));
            this.expect(new Integer(30), "jmx.monitor.counter.threshold");
            this.expect(new Integer(40), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdNotExceededOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.dontExpect(new Integer(1));
            this.dontExpect(new Integer(-1));
            this.dontExpect(new Integer(9));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(10));
            this.dontExpect(new Integer(11));
            this.dontExpect(new Integer(9));
            this.expect(new Integer(20), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(19));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededNoneOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(false, new Integer(10), false, new Integer(10), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.dontExpect(new Integer(10));
            this.dontExpect(new Integer(0));
            this.dontExpect(new Integer(20));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededEarlyNoOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(0), new Integer(10));
            this.expectStartMonitor(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededLateNoOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(0), new Integer(10));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededManyNoOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(0), new Integer(10));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(0));
            this.expect(new Integer(11), "jmx.monitor.counter.threshold");
            this.expect(new Integer(12), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
        }
        catch (AssertionFailedError e) {
            MonitorTestCase.fail((String)"FAILS IN RI: Modulus ignored with no offset???");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdNotExceededNoOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(0), new Integer(10));
            this.dontExpectStartMonitor(new Integer(0));
            this.dontExpect(new Integer(1));
            this.dontExpect(new Integer(-1));
            this.dontExpect(new Integer(9));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(9));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(9));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededNoneNoOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(false, new Integer(10), false, new Integer(0), new Integer(10));
            this.dontExpectStartMonitor(new Integer(0));
            this.dontExpect(new Integer(10));
            this.dontExpect(new Integer(0));
            this.dontExpect(new Integer(10));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededEarlyOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(10));
            this.expectStartMonitor(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededLateOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(10));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededManyOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(20));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(0));
            this.dontExpect(new Integer(12));
            this.expect(new Integer(20), "jmx.monitor.counter.threshold");
            if (((CounterMonitor)this.monitor).getThreshold().equals(new Integer(30))) {
                MonitorTestCase.fail((String)"FAILS IN RI: Threshold 10, Offset 10, Modulus 20 should  never get a threshold of 30");
            }
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(10));
            this.expect(new Integer(20), "jmx.monitor.counter.threshold");
            this.expect(new Integer(20), "jmx.monitor.counter.threshold");
            this.expect(new Integer(30), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdNotExceededOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(20));
            this.dontExpectStartMonitor(new Integer(0));
            this.dontExpect(new Integer(1));
            this.dontExpect(new Integer(-1));
            this.dontExpect(new Integer(9));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpect(new Integer(10));
            this.dontExpect(new Integer(11));
            this.dontExpect(new Integer(9));
            this.expect(new Integer(20), "jmx.monitor.counter.threshold");
            if (((CounterMonitor)this.monitor).getThreshold().equals(new Integer(30))) {
                MonitorTestCase.fail((String)"FAILS IN RI: Threshold 10, Offset 10, Modulus 20 should  never get a threshold of 30");
            }
            this.expect(new Integer(19), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNormalCounterThresholdExceededNoneOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(false, new Integer(10), false, new Integer(10), new Integer(10));
            this.dontExpectStartMonitor(new Integer(0));
            this.dontExpect(new Integer(10));
            this.dontExpect(new Integer(0));
            this.dontExpect(new Integer(20));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededNoOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(0), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededManyNoOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(0), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(0), new Integer(11), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdNotExceededNoOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(0), new Integer(0));
            this.dontExpectStartMonitorDiff(new Integer(0), new Integer(1));
            this.dontExpectDiff(new Integer(0), new Integer(9));
            this.dontExpectDiff(new Integer(1), new Integer(10));
            this.dontExpectDiff(new Integer(9), new Integer(11));
            this.dontExpectDiff(new Integer(9), new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededNoneNoOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(false, new Integer(10), true, new Integer(0), new Integer(0));
            this.dontExpectStartMonitorDiff(new Integer(0), new Integer(10));
            this.dontExpectDiff(new Integer(0), new Integer(-10));
            this.dontExpectDiff(new Integer(0), new Integer(100));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(10), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededManyOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(10), new Integer(0));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(0), new Integer(10), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(10), new Integer(30), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(30), new Integer(60), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(60), new Integer(100), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(0), new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdNotExceededOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(10), new Integer(0));
            this.dontExpectStartMonitorDiff(new Integer(0), new Integer(1));
            this.expectDiff(new Integer(0), new Integer(10), "jmx.monitor.counter.threshold");
            this.dontExpectDiff(new Integer(10), new Integer(20));
            this.expectDiff(new Integer(20), new Integer(40), "jmx.monitor.counter.threshold");
            this.dontExpectDiff(new Integer(40), new Integer(69));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededNoneOffsetNoModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(false, new Integer(10), true, new Integer(10), new Integer(0));
            this.dontExpectStartMonitorDiff(new Integer(0), new Integer(1));
            this.dontExpectDiff(new Integer(0), new Integer(10));
            this.dontExpectDiff(new Integer(10), new Integer(20));
            this.dontExpectDiff(new Integer(20), new Integer(40));
            this.dontExpectDiff(new Integer(40), new Integer(69));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededNoOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(0), new Integer(10));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededManyNoOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(0), new Integer(10));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(0), new Integer(11), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(12), new Integer(22), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(0), new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdNotExceededNoOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(0), new Integer(10));
            this.dontExpectStartMonitorDiff(new Integer(0), new Integer(1));
            this.dontExpectDiff(new Integer(0), new Integer(9));
            this.dontExpectDiff(new Integer(11), new Integer(20));
            this.dontExpectDiffModulus(new Integer(10), new Integer(-3), new Integer(10));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededNoneNoOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(false, new Integer(10), true, new Integer(0), new Integer(10));
            this.dontExpectStartMonitorDiff(new Integer(0), new Integer(10));
            this.dontExpectDiffModulus(new Integer(0), new Integer(-10), new Integer(10));
            this.dontExpectDiff(new Integer(0), new Integer(100));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(10), new Integer(10));
            this.dontExpectStartMonitor(new Integer(0));
            this.expect(new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededManyOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(10), new Integer(20));
            this.dontExpectStartMonitor(new Integer(0));
            this.expectDiff(new Integer(0), new Integer(11), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(11), new Integer(31), "jmx.monitor.counter.threshold");
            this.expectDiff(new Integer(0), new Integer(10), "jmx.monitor.counter.threshold");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdNotExceededOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), true, new Integer(10), new Integer(20));
            this.dontExpectStartMonitorDiff(new Integer(0), new Integer(1));
            this.dontExpectDiff(new Integer(1), new Integer(10));
            this.dontExpectDiffModulus(new Integer(10), new Integer(-13), new Integer(20));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiffCounterThresholdExceededNoneOffsetModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(false, new Integer(10), true, new Integer(10), new Integer(20));
            this.dontExpectStartMonitorDiff(new Integer(0), new Integer(10));
            this.dontExpectDiffModulus(new Integer(0), new Integer(-10), new Integer(20));
            this.dontExpectDiff(new Integer(0), new Integer(100));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCounterInvalidAttribute() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(10));
            this.attributeErrorStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCounterInvalidAttributeNull() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(10));
            this.attributeNullStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCounterInvalidAttributeType() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(10));
            this.attributeTypeStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCounterWriteOnly() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(10));
            this.attributeWriteStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCounterInvalidObjectName() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(10));
            this.objectNameStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCounterInvalidThreshold() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Long(10L), false, new Integer(10), new Integer(10));
            this.objectNameStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCounterInvalidOffset() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Long(10L), new Integer(10));
            this.objectNameStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCounterInvalidModulus() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Long(10L));
            this.objectNameStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCounterRuntimeError() throws Exception {
        this.initTest();
        try {
            this.initCounterMonitor(true, new Integer(10), false, new Integer(10), new Integer(10));
            this.runtimeErrorStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    public void testGaugeNotificationInfo() throws Exception {
        HashSet<String> expected = new HashSet<String>();
        expected.add("jmx.monitor.error.attribute");
        expected.add("jmx.monitor.error.type");
        expected.add("jmx.monitor.error.mbean");
        expected.add("jmx.monitor.error.runtime");
        expected.add("jmx.monitor.error.threshold");
        expected.add("jmx.monitor.gauge.high");
        expected.add("jmx.monitor.gauge.low");
        MBeanNotificationInfo[] mbni = new GaugeMonitor().getNotificationInfo();
        this.checkNotificationInfo("Gauge", mbni, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGaugeInvalidAttribute() throws Exception {
        this.initTest();
        try {
            this.initGaugeMonitor(true, true, new Integer(10), new Integer(0), false);
            this.attributeErrorStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGaugeInvalidAttributeNull() throws Exception {
        this.initTest();
        try {
            this.initGaugeMonitor(true, true, new Integer(10), new Integer(0), false);
            this.attributeNullStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGaugeInvalidAttributeType() throws Exception {
        this.initTest();
        try {
            this.initGaugeMonitor(true, true, new Integer(10), new Integer(0), false);
            this.attributeTypeStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGaugeWriteOnly() throws Exception {
        this.initTest();
        try {
            this.initGaugeMonitor(true, true, new Integer(10), new Integer(0), false);
            this.attributeWriteStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGaugeInvalidObjectName() throws Exception {
        this.initTest();
        try {
            this.initGaugeMonitor(true, true, new Integer(10), new Integer(0), false);
            this.objectNameStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGaugeInvalidThreshold() throws Exception {
        this.initTest();
        try {
            this.initGaugeMonitor(true, true, new Long(10L), new Long(0L), false);
            this.objectNameStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGaugeRuntimeError() throws Exception {
        this.initTest();
        try {
            this.initGaugeMonitor(true, true, new Integer(10), new Integer(0), false);
            this.runtimeErrorStartMonitor(new Integer(0));
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    public void testStringNotificationInfo() throws Exception {
        HashSet<String> expected = new HashSet<String>();
        expected.add("jmx.monitor.error.attribute");
        expected.add("jmx.monitor.error.type");
        expected.add("jmx.monitor.error.mbean");
        expected.add("jmx.monitor.error.runtime");
        expected.add("jmx.monitor.string.differs");
        expected.add("jmx.monitor.string.matches");
        MBeanNotificationInfo[] mbni = new StringMonitor().getNotificationInfo();
        this.checkNotificationInfo("String", mbni, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringDifferEarly() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, false, "Hello");
            this.expectStartMonitor("Goodbye", "jmx.monitor.string.differs");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringDifferLate() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, false, "Hello");
            this.dontExpectStartMonitor("Hello");
            this.expect("Goodbye", "jmx.monitor.string.differs");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringDifferManyEarly() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, false, "Hello");
            this.expectStartMonitor("Goodbye", "jmx.monitor.string.differs");
            this.dontExpect("Hello");
            this.expect("Goodbye", "jmx.monitor.string.differs");
            this.dontExpect("Hello");
            this.expect("Goodbye", "jmx.monitor.string.differs");
            this.dontExpect("Hello");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringDifferManyLate() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, false, "Hello");
            this.dontExpectStartMonitor("Hello");
            this.expect("Goodbye", "jmx.monitor.string.differs");
            this.dontExpect("Hello");
            this.expect("Goodbye", "jmx.monitor.string.differs");
            this.dontExpect("Hello");
            this.expect("Goodbye", "jmx.monitor.string.differs");
            this.dontExpect("Hello");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringMatchEarly() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(false, true, "Hello");
            this.expectStartMonitor("Hello", "jmx.monitor.string.matches");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringMatchLate() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(false, true, "Hello");
            this.dontExpectStartMonitor("Goodbye");
            this.expect("Hello", "jmx.monitor.string.matches");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringMatchManyEarly() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(false, true, "Hello");
            this.expectStartMonitor("Hello", "jmx.monitor.string.matches");
            this.dontExpect("Goodbye");
            this.expect("Hello", "jmx.monitor.string.matches");
            this.dontExpect("Goodbye");
            this.expect("Hello", "jmx.monitor.string.matches");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringMatchManyLate() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(false, true, "Hello");
            this.dontExpectStartMonitor("Goodbye");
            this.expect("Hello", "jmx.monitor.string.matches");
            this.dontExpect("Goodbye");
            this.expect("Hello", "jmx.monitor.string.matches");
            this.dontExpect("Goodbye");
            this.expect("Hello", "jmx.monitor.string.matches");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringBoth() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, true, "Hello");
            this.expectStartMonitor("Goodbye", "jmx.monitor.string.differs");
            this.expect("Hello", "jmx.monitor.string.matches");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringBothMany() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, true, "Hello");
            this.expectStartMonitor("Goodbye", "jmx.monitor.string.differs");
            this.expect("Hello", "jmx.monitor.string.matches");
            this.expect("Goodbye", "jmx.monitor.string.differs");
            this.expect("Hello", "jmx.monitor.string.matches");
            this.expect("Goodbye", "jmx.monitor.string.differs");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringNever() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(false, false, "Hello");
            this.dontExpectStartMonitor("Goodbye");
            this.dontExpect("Hello");
            this.dontExpect("Goodbye");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringInvalidAttribute() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, true, "Hello");
            this.attributeErrorStartMonitor("Goodbye");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringInvalidAttributeNull() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, true, "Hello");
            this.attributeNullStartMonitor("Goodbye");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringInvalidAttributeType() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, true, "Hello");
            this.attributeTypeStartMonitor("Goodbye");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringWriteOnly() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, true, "Hello");
            this.attributeWriteStartMonitor("Goodbye");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringInvalidObjectName() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, true, "Hello");
            this.objectNameStartMonitor("Goodbye");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStringRuntimeError() throws Exception {
        this.initTest();
        try {
            this.initStringMonitor(true, true, "Hello");
            this.runtimeErrorStartMonitor("Goodbye");
        }
        finally {
            this.stopMonitor();
            MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }

    private void initCounterMonitor(boolean notify, Number threshold, boolean differenceMode, Number offset, Number modulus) {
        try {
            CounterMonitor counterMonitor = new CounterMonitor();
            counterMonitor.setNotify(notify);
            counterMonitor.setThreshold(threshold);
            counterMonitor.setDifferenceMode(differenceMode);
            counterMonitor.setOffset(offset);
            counterMonitor.setModulus(modulus);
            CounterSupport support = new CounterSupport();
            this.monitor = counterMonitor;
            this.monitored = support;
            this.initMonitor();
        }
        catch (Exception e) {
            MonitorTestCase.fail((String)e.toString());
        }
    }

    private void initGaugeMonitor(boolean notifyHigh, boolean notifyLow, Number thresholdHigh, Number thresholdLow, boolean differenceMode) {
        try {
            GaugeMonitor gaugeMonitor = new GaugeMonitor();
            gaugeMonitor.setNotifyHigh(notifyHigh);
            gaugeMonitor.setNotifyLow(notifyLow);
            gaugeMonitor.setThresholds(thresholdHigh, thresholdLow);
            gaugeMonitor.setDifferenceMode(differenceMode);
            GaugeSupport support = new GaugeSupport();
            this.monitor = gaugeMonitor;
            this.monitored = support;
            this.initMonitor();
        }
        catch (Exception e) {
            MonitorTestCase.fail((String)e.toString());
        }
    }

    private void initStringMonitor(boolean differ, boolean match, String compare) {
        try {
            StringMonitor stringMonitor = new StringMonitor();
            stringMonitor.setNotifyDiffer(differ);
            stringMonitor.setNotifyMatch(match);
            stringMonitor.setStringToCompare(compare);
            StringSupport support = new StringSupport();
            this.monitor = stringMonitor;
            this.monitored = support;
            this.initMonitor();
        }
        catch (Exception e) {
            MonitorTestCase.fail((String)e.toString());
        }
    }

    private void initTest() {
        this.notifications.clear();
        this.server = MBeanServerFactory.createMBeanServer();
    }

    private void initMonitor() throws Exception {
        this.monitorName = new ObjectName("test:type=monitor");
        this.monitoredName = new ObjectName("test:type=monitored");
        this.monitor.setObservedObject(this.monitoredName);
        this.monitor.setObservedAttribute("Value");
        this.monitor.setGranularityPeriod(1L);
        this.server.registerMBean(this.monitor, this.monitorName);
        this.server.registerMBean(this.monitored, this.monitoredName);
        this.server.addNotificationListener(this.monitorName, this, null, null);
    }

    private void stopMonitor() {
        if (this.monitor != null) {
            this.monitored.end();
            this.monitor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification n, Object ignored) {
        ArrayList arrayList = this.notifications;
        synchronized (arrayList) {
            this.notifications.add(n);
            this.notifications.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(boolean getWorks) throws Exception {
        if (getWorks) {
            this.waitCycle();
        } else {
            ArrayList arrayList = this.notifications;
            synchronized (arrayList) {
                this.notifications.wait(1000L);
            }
        }
    }

    private void attributeErrorStartMonitor(Object initial) throws Exception {
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.monitor.setObservedAttribute("rubbish");
        this.monitor.start();
        this.sync(false);
        MonitorTestCase.assertEquals((int)1, (int)this.notifications.size());
        MonitorNotification n = (MonitorNotification)this.notifications.get(0);
        this.notifications.clear();
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"rubbish", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.attribute", (String)n.getType());
        n = this.serializeDeserialize(n);
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"rubbish", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.attribute", (String)n.getType());
    }

    private void attributeNullStartMonitor(Object initial) throws Exception {
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.monitor.setObservedAttribute("WrongNull");
        this.monitor.start();
        this.sync(false);
        MonitorTestCase.assertEquals((int)1, (int)this.notifications.size());
        MonitorNotification n = (MonitorNotification)this.notifications.get(0);
        this.notifications.clear();
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"WrongNull", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.type", (String)n.getType());
        n = this.serializeDeserialize(n);
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"WrongNull", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.type", (String)n.getType());
    }

    private void attributeTypeStartMonitor(Object initial) throws Exception {
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.monitor.setObservedAttribute("WrongType");
        this.monitor.start();
        this.sync(false);
        MonitorTestCase.assertEquals((int)1, (int)this.notifications.size());
        MonitorNotification n = (MonitorNotification)this.notifications.get(0);
        this.notifications.clear();
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"WrongType", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.type", (String)n.getType());
        n = this.serializeDeserialize(n);
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"WrongType", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.type", (String)n.getType());
    }

    private void attributeWriteStartMonitor(Object initial) throws Exception {
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.monitor.setObservedAttribute("WriteOnly");
        this.monitor.start();
        this.sync(false);
        MonitorTestCase.assertEquals((int)1, (int)this.notifications.size());
        MonitorNotification n = (MonitorNotification)this.notifications.get(0);
        this.notifications.clear();
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"WriteOnly", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.attribute", (String)n.getType());
        n = this.serializeDeserialize(n);
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"WriteOnly", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.attribute", (String)n.getType());
    }

    private void objectNameStartMonitor(Object initial) throws Exception {
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.monitoredName = new ObjectName("rubbish:type=pants");
        this.monitor.setObservedObject(this.monitoredName);
        this.monitor.start();
        this.sync(false);
        MonitorTestCase.assertEquals((int)1, (int)this.notifications.size());
        MonitorNotification n = (MonitorNotification)this.notifications.get(0);
        this.notifications.clear();
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"Value", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.mbean", (String)n.getType());
        n = this.serializeDeserialize(n);
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"Value", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.mbean", (String)n.getType());
    }

    private void runtimeErrorStartMonitor(Object initial) throws Exception {
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.monitor.setObservedAttribute("WrongException");
        this.monitor.start();
        this.sync(false);
        if (this.notifications.size() != 1) {
            MonitorTestCase.fail((String)"FAILS IN RI: Does not notify of error thrown by getter");
        }
        MonitorTestCase.assertEquals((int)1, (int)this.notifications.size());
        MonitorNotification n = (MonitorNotification)this.notifications.get(0);
        this.notifications.clear();
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"WrongException", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.runtime", (String)n.getType());
        n = this.serializeDeserialize(n);
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"WrongException", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)"jmx.monitor.error.runtime", (String)n.getType());
    }

    private void expectStartMonitor(Object expected, String type) throws Exception {
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.monitor.start();
        this.setValue(expected);
        this.sync(true);
        this.checkGauge(expected);
        MonitorTestCase.assertEquals((int)1, (int)this.notifications.size());
        MonitorNotification n = (MonitorNotification)this.notifications.get(0);
        this.notifications.clear();
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"Value", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)type, (String)n.getType());
        MonitorTestCase.assertEquals((Object)expected, (Object)n.getDerivedGauge());
        n = this.serializeDeserialize(n);
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"Value", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)type, (String)n.getType());
        MonitorTestCase.assertEquals((Object)expected, (Object)n.getDerivedGauge());
    }

    private void dontExpectStartMonitor(Object initial) throws Exception {
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.monitor.start();
        this.setValue(initial);
        this.waitCycle();
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.checkGauge(initial);
    }

    private void dontExpectStartMonitorDiff(Object value1, Object value2) throws Exception {
        this.monitor.start();
        this.setValue(value1);
        this.waitCycle();
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.setValue(value2);
        this.waitCycle();
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.checkGauge(this.sub(value2, value1));
    }

    private void setValue(Object value) throws Exception {
        this.monitored.lock("set");
        this.server.setAttribute(this.monitoredName, new Attribute("Value", value));
    }

    private void expect(Object expected, Object gauge, String type) throws Exception {
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.setValue(expected);
        this.sync(true);
        this.checkGauge(gauge);
        MonitorTestCase.assertEquals((int)1, (int)this.notifications.size());
        MonitorNotification n = (MonitorNotification)this.notifications.get(0);
        this.notifications.clear();
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"Value", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)type, (String)n.getType());
        MonitorTestCase.assertEquals((Object)gauge, (Object)n.getDerivedGauge());
    }

    private void expectDiff(Object value1, Object value2, String type) throws Exception {
        this.waitCycle();
        this.notifications.clear();
        this.setValue(value1);
        this.waitCycle();
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.setValue(value2);
        this.sync(true);
        this.checkGauge(this.sub(value2, value1));
        MonitorTestCase.assertEquals((int)1, (int)this.notifications.size());
        MonitorNotification n = (MonitorNotification)this.notifications.get(0);
        this.notifications.clear();
        MonitorTestCase.assertEquals((Object)this.monitorName, (Object)n.getSource());
        MonitorTestCase.assertEquals((Object)this.monitoredName, (Object)n.getObservedObject());
        MonitorTestCase.assertEquals((String)"Value", (String)n.getObservedAttribute());
        MonitorTestCase.assertEquals((String)type, (String)n.getType());
        MonitorTestCase.assertEquals((Object)this.sub(value2, value1), (Object)n.getDerivedGauge());
    }

    private void expect(Object expected, String type) throws Exception {
        this.expect(expected, expected, type);
    }

    private void dontExpect(Object unexpected) throws Exception {
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.setValue(unexpected);
        this.waitCycle();
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.checkGauge(unexpected);
    }

    private void dontExpectDiff(Object value1, Object value2) throws Exception {
        this.waitCycle();
        this.notifications.clear();
        this.setValue(value1);
        this.waitCycle();
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.setValue(value2);
        this.waitCycle();
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.checkGauge(this.sub(value2, value1));
    }

    private void dontExpectDiffModulus(Object value1, Object value2, Object value3) throws Exception {
        this.waitCycle();
        this.notifications.clear();
        this.setValue(value1);
        this.waitCycle();
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.setValue(value2);
        this.waitCycle();
        MonitorTestCase.assertEquals((int)0, (int)this.notifications.size());
        this.checkGauge(this.add(this.sub(value2, value1), value3));
    }

    private void checkGauge(Object gauge) throws Exception {
        if (this.monitor instanceof StringMonitor) {
            MonitorTestCase.assertEquals((Object)gauge, (Object)((StringMonitor)this.monitor).getDerivedGauge());
        } else if (this.monitor instanceof CounterMonitor) {
            MonitorTestCase.assertEquals((Object)gauge, (Object)((CounterMonitor)this.monitor).getDerivedGauge());
        } else if (this.monitor instanceof GaugeMonitor) {
            MonitorTestCase.assertEquals((Object)gauge, (Object)((GaugeMonitor)this.monitor).getDerivedGauge());
        } else {
            MonitorTestCase.fail((String)"You idiot!");
        }
    }

    private void waitCycle() {
        this.monitored.unlock("set");
        this.monitored.lock("set");
    }

    private Number add(Object value1, Object value2) {
        if (value1 instanceof Byte) {
            return new Byte((byte)((Byte)value1 + (Byte)value2));
        }
        if (value1 instanceof Integer) {
            return new Integer((Integer)value1 + (Integer)value2);
        }
        if (value1 instanceof Short) {
            return new Short((short)((Short)value1 + (Short)value2));
        }
        if (value1 instanceof Long) {
            return new Long((Long)value1 + (Long)value2);
        }
        MonitorTestCase.fail((String)"You idiot!");
        return null;
    }

    private Number sub(Object value1, Object value2) {
        if (value1 instanceof Byte) {
            return new Byte((byte)((Byte)value1 - (Byte)value2));
        }
        if (value1 instanceof Integer) {
            return new Integer((Integer)value1 - (Integer)value2);
        }
        if (value1 instanceof Short) {
            return new Short((short)((Short)value1 - (Short)value2));
        }
        if (value1 instanceof Long) {
            return new Long((Long)value1 - (Long)value2);
        }
        MonitorTestCase.fail((String)"You idiot!");
        return null;
    }

    private void checkNotificationInfo(String type, MBeanNotificationInfo[] mbni, HashSet expected) {
        String[] types = mbni[0].getNotifTypes();
        for (int i = 0; i < types.length; ++i) {
            if (expected.remove(types[i])) continue;
            MonitorTestCase.fail((String)(type + ": didn't expect notification type " + types[i]));
        }
        Iterator iterator = expected.iterator();
        while (iterator.hasNext()) {
            MonitorTestCase.fail((String)(type + ": expected notification type " + iterator.next()));
        }
    }

    private MonitorNotification serializeDeserialize(MonitorNotification n) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(n);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (MonitorNotification)ois.readObject();
    }
}

