/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.util.HashSet;

public final class MetaDataUtil {
    public static final String BOOLEAN_TYPE_NAME = Boolean.TYPE.getName();
    public static final String BYTE_TYPE_NAME = Byte.TYPE.getName();
    public static final String CHAR_TYPE_NAME = Character.TYPE.getName();
    public static final String DOUBLE_TYPE_NAME = Double.TYPE.getName();
    public static final String FLOAT_TYPE_NAME = Float.TYPE.getName();
    public static final String INT_TYPE_NAME = Integer.TYPE.getName();
    public static final String LONG_TYPE_NAME = Long.TYPE.getName();
    public static final String SHORT_TYPE_NAME = Short.TYPE.getName();
    public static final String VOID_TYPE_NAME = Void.TYPE.getName();
    private static final HashSet<String> reserved = new HashSet();

    public static final boolean isValidJavaIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] chars = string.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        return !reserved.contains(string);
    }

    public static final boolean isValidJavaType(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.charAt(0) == '[') {
            String baseClassName = MetaDataUtil.getBaseClassName(string);
            if (baseClassName == null) {
                return false;
            }
            string = baseClassName;
        }
        if (MetaDataUtil.isPrimitive(string)) {
            return true;
        }
        char[] chars = string.toCharArray();
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '.') continue;
            if (i == start) {
                return false;
            }
            if (!MetaDataUtil.isValidJavaIdentifier(string.substring(start, i))) {
                return false;
            }
            start = i + 1;
        }
        return start >= chars.length || MetaDataUtil.isValidJavaIdentifier(string.substring(start, chars.length));
    }

    public static String getBaseClassName(String className) {
        int i;
        int length = className.length();
        int last = length - 1;
        for (i = 0; i < length && className.charAt(i) == '['; ++i) {
        }
        if (i > 0) {
            char type = className.charAt(i);
            if (type == 'B' || type == 'C' || type == 'D' || type == 'F' || type == 'I' || type == 'J' || type == 'S' || type == 'Z' || type == 'V') {
                if (i != last) {
                    return null;
                }
                return className.substring(last, length);
            }
            if (className.charAt(i) != 'L' || i >= last - 1 || className.charAt(last) != ';') {
                return null;
            }
            return className.substring(i + 1, last);
        }
        return className;
    }

    public static boolean isPrimitive(String string) {
        if (string.equals(INT_TYPE_NAME)) {
            return true;
        }
        if (string.equals(LONG_TYPE_NAME)) {
            return true;
        }
        if (string.equals(BOOLEAN_TYPE_NAME)) {
            return true;
        }
        if (string.equals(BYTE_TYPE_NAME)) {
            return true;
        }
        if (string.equals(CHAR_TYPE_NAME)) {
            return true;
        }
        if (string.equals(SHORT_TYPE_NAME)) {
            return true;
        }
        if (string.equals(FLOAT_TYPE_NAME)) {
            return true;
        }
        if (string.equals(DOUBLE_TYPE_NAME)) {
            return true;
        }
        return string.equals(VOID_TYPE_NAME);
    }

    static {
        reserved.add("assert");
        reserved.add("abstract");
        reserved.add("boolean");
        reserved.add("break");
        reserved.add("byte");
        reserved.add("case");
        reserved.add("catch");
        reserved.add("char");
        reserved.add("class");
        reserved.add("const");
        reserved.add("continue");
        reserved.add("default");
        reserved.add("do");
        reserved.add("double");
        reserved.add("else");
        reserved.add("extends");
        reserved.add("false");
        reserved.add("final");
        reserved.add("finally");
        reserved.add("float");
        reserved.add("for");
        reserved.add("goto");
        reserved.add("if");
        reserved.add("implements");
        reserved.add("import");
        reserved.add("instanceof");
        reserved.add("int");
        reserved.add("interface");
        reserved.add("long");
        reserved.add("native");
        reserved.add("new");
        reserved.add("null");
        reserved.add("package");
        reserved.add("private");
        reserved.add("protected");
        reserved.add("public");
        reserved.add("return");
        reserved.add("short");
        reserved.add("static");
        reserved.add("strictfp");
        reserved.add("super");
        reserved.add("switch");
        reserved.add("synchronized");
        reserved.add("this");
        reserved.add("throw");
        reserved.add("throws");
        reserved.add("transient");
        reserved.add("true");
        reserved.add("try");
        reserved.add("void");
        reserved.add("volatile");
        reserved.add("while");
    }
}

