/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.mx.loading.ClassLoaderUtils;
import org.jboss.mx.loading.LoadMgr3;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.loading.UnifiedLoaderRepository3;
import org.jboss.mx.util.ObjectNameFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeirarchicalLoaderRepository3
extends UnifiedLoaderRepository3 {
    private static ObjectName DEFAULT_LOADER_OBJECT_NAME = ObjectNameFactory.create((String)"JMImplementation:service=LoaderRepository,name=Default");
    private UnifiedLoaderRepository3 parentRepository;
    private boolean java2ParentDelegation;
    private LoadMgr3.PkgClassLoader packageClassLoader;

    public HeirarchicalLoaderRepository3(UnifiedLoaderRepository3 parent) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this.parentRepository = parent;
        this.init();
    }

    public HeirarchicalLoaderRepository3(MBeanServer server) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this(server, DEFAULT_LOADER_OBJECT_NAME);
    }

    public HeirarchicalLoaderRepository3(MBeanServer server, ObjectName parentName) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        this.parentRepository = (UnifiedLoaderRepository3)server.getAttribute(parentName, "Instance");
        this.init();
    }

    private void init() {
        ClassLoader loader = RepositoryClassLoader.class.getClassLoader();
        RepositoryClassLoader ucl = null;
        ucl = loader instanceof RepositoryClassLoader ? (RepositoryClassLoader)loader : new UnifiedClassLoader3(null, null, this);
        this.packageClassLoader = new LoadMgr3.PkgClassLoader(ucl, 3);
    }

    @Override
    public RepositoryClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = null;
        ucl = !this.java2ParentDelegation ? new UnifiedClassLoader3(url, null, (ClassLoader)new NoParentClassLoader(), this) : new UnifiedClassLoader3(url, null, this);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    @Override
    public RepositoryClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = null;
        ucl = !this.java2ParentDelegation ? new UnifiedClassLoader3(url, origURL, (ClassLoader)new NoParentClassLoader(), this) : new UnifiedClassLoader3(url, origURL, this);
        if (addToRepository) {
            this.addClassLoader(ucl);
        }
        return ucl;
    }

    public boolean getUseParentFirst() {
        return this.java2ParentDelegation;
    }

    public void setUseParentFirst(boolean flag) {
        this.java2ParentDelegation = flag;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve, ClassLoader scl) throws ClassNotFoundException {
        Class<?> foundClass;
        block7: {
            foundClass = null;
            if (this.java2ParentDelegation) {
                try {
                    foundClass = this.parentRepository.loadClass(name, resolve, scl);
                }
                catch (ClassNotFoundException e) {
                    if (foundClass == null) {
                        foundClass = super.loadClass(name, resolve, scl);
                    }
                    break block7;
                }
            }
            try {
                foundClass = super.loadClass(name, resolve, scl);
            }
            catch (ClassNotFoundException e) {
                if (foundClass != null) break block7;
                foundClass = this.parentRepository.loadClass(name, resolve, scl);
            }
        }
        if (foundClass != null) {
            return foundClass;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public Class<?> getCachedClass(String classname) {
        Class<?> clazz = null;
        if (this.java2ParentDelegation) {
            clazz = this.parentRepository.getCachedClass(classname);
            if (clazz == null) {
                clazz = super.getCachedClass(classname);
            }
        } else {
            clazz = super.getCachedClass(classname);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name, ClassLoader scl) {
        URL resource = null;
        if (this.java2ParentDelegation) {
            resource = this.getParentResource(name, scl);
            if (resource == null) {
                resource = super.getResource(name, scl);
            }
        } else {
            resource = super.getResource(name, scl);
            if (resource == null) {
                resource = this.getParentResource(name, scl);
            }
        }
        return resource;
    }

    @Override
    public void getResources(String name, ClassLoader cl, List<URL> urls) {
        if (this.java2ParentDelegation) {
            this.parentRepository.getResources(name, cl, urls);
            super.getResources(name, cl, urls);
        } else {
            super.getResources(name, cl, urls);
            this.parentRepository.getResources(name, cl, urls);
        }
    }

    @Override
    public URL[] getURLs() {
        URL[] ourURLs = super.getURLs();
        URL[] parentURLs = this.parentRepository.getURLs();
        int size = ourURLs.length + parentURLs.length;
        URL[] urls = new URL[size];
        System.arraycopy(ourURLs, 0, urls, 0, ourURLs.length);
        System.arraycopy(parentURLs, 0, urls, ourURLs.length, parentURLs.length);
        return urls;
    }

    @Override
    public Class<?> loadClassFromCache(String name) {
        Class<?> foundClass = null;
        if (this.java2ParentDelegation) {
            foundClass = this.parentRepository.loadClassFromCache(name);
            if (foundClass == null) {
                foundClass = super.loadClassFromCache(name);
            }
        } else {
            foundClass = super.loadClassFromCache(name);
        }
        return foundClass;
    }

    @Override
    public Set<ClassLoader> getPackageClassLoaders(String name) {
        Set<ClassLoader> pkgSet = super.getPackageClassLoaders(name);
        Set<ClassLoader> parentPkgSet = this.parentRepository.getPackageClassLoaders(name);
        GetClassLoadersAction action = new GetClassLoadersAction(name, pkgSet, parentPkgSet);
        Set theSet = (Set)AccessController.doPrivileged(action);
        return theSet;
    }

    @Override
    public int compare(LoaderRepository lr) {
        if (lr == this) {
            return 0;
        }
        return this.reverseCompare(lr);
    }

    @Override
    protected int reverseCompare(LoaderRepository lr) {
        if (lr != this.parentRepository) {
            return 0;
        }
        if (this.java2ParentDelegation) {
            return 1;
        }
        return -1;
    }

    private URL getParentResource(String name, ClassLoader scl) {
        URL resource = this.parentRepository.getResourceFromGlobalCache(name);
        if (resource != null) {
            return resource;
        }
        resource = this.parentRepository.getResourceFromRepository(name, scl);
        return resource;
    }

    private class GetClassLoadersAction
    implements PrivilegedAction {
        private String name;
        Set pkgSet;
        Set parentPkgSet;

        GetClassLoadersAction(String name, Set pkgSet, Set parentPkgSet) {
            this.name = name;
            this.pkgSet = pkgSet;
            this.parentPkgSet = parentPkgSet;
        }

        public Object run() {
            Class<?> cacheClass;
            LoadMgr3.PkgClassLoader pkgUcl;
            Set<ClassLoader> theSet = ClassLoaderUtils.newPackageSet();
            if (this.pkgSet != null) {
                for (RepositoryClassLoader ucl : this.pkgSet) {
                    pkgUcl = new LoadMgr3.PkgClassLoader(ucl, 0);
                    theSet.add((ClassLoader)((Object)pkgUcl));
                }
            }
            if (!HeirarchicalLoaderRepository3.this.java2ParentDelegation && (cacheClass = HeirarchicalLoaderRepository3.this.parentRepository.loadClassFromCache(this.name)) != null) {
                RepositoryClassLoader ucl;
                ucl = new CacheClassLoader(cacheClass, (LoaderRepository)HeirarchicalLoaderRepository3.this);
                pkgUcl = new LoadMgr3.PkgClassLoader(ucl, 1);
                theSet.add((ClassLoader)((Object)pkgUcl));
            }
            if (this.parentPkgSet != null) {
                for (RepositoryClassLoader ucl : this.parentPkgSet) {
                    pkgUcl = new LoadMgr3.PkgClassLoader(ucl, 2);
                    theSet.add((ClassLoader)((Object)pkgUcl));
                }
            }
            if (!HeirarchicalLoaderRepository3.this.java2ParentDelegation) {
                theSet.add((ClassLoader)((Object)HeirarchicalLoaderRepository3.this.packageClassLoader));
            }
            return theSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheClassLoader
    extends UnifiedClassLoader3 {
        Class<?> cacheClass;

        CacheClassLoader(Class<?> cacheClass, LoaderRepository rep) {
            super(null, null, (ClassLoader)new NoParentClassLoader(), rep);
            this.cacheClass = cacheClass;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> c = this.cacheClass;
            if (!name.equals(this.cacheClass.getName())) {
                c = null;
            }
            return c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NoParentClassLoader
    extends ClassLoader {
        NoParentClassLoader() {
            super(HeirarchicalLoaderRepository3.class.getClassLoader());
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            throw new ClassNotFoundException("NoParentClassLoader has no classes");
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException("NoParentClassLoader has no classes");
        }
    }
}

