/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.jmx.mbeanserver;

import java.util.Map;

import javax.management.ObjectName;

/**
 * RegistryEntry.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
class RegistryEntry
{
   final static String CLASSLOADER = "org.jboss.mx.classloader";

   /**
    * The registered object name of the mbean
    */
   private ObjectName objectName = null;

   /**
    * The context classloader of the mbean
    */
   private ClassLoader cl  = null;

   /**
    * The value map of the mbean
    */
   private Map<String, Object> valueMap  = null;

   /**
    * Construct a new mbean registration entry.
    *
    * @param objectName the name with which the mbean is registered
    * @param valueMap any other information to include in the registration
    */
   public RegistryEntry(ObjectName objectName, Map<String, Object> valueMap)
   {
      this.objectName = objectName;
      this.valueMap = valueMap;

      // Adrian: Unpack the classloader because this is used alot
      if (valueMap != null)
         this.cl = (ClassLoader) valueMap.get(CLASSLOADER);
   }

   /**
    * Retrieve the object name with the mbean is registered.
    *
    * @return the object name
    */
   public ObjectName getObjectName()
   {
      return objectName;
   }

   /** A protected method used to set the entry object name when access
    * to the entry is needed before the ultimate name under which the
    * mbean is registered is known.
    * 
    * @param objectName - the object name under which the mbean is registered
    */
   protected void setObjectName(ObjectName objectName)
   {
      this.objectName = objectName;
   }

   /**
    * Retrieve the context class loader with which to invoke the mbean.
    *
    * @return the class loader
    */
   public ClassLoader getClassLoader()
   {
      return cl;
   }

   /**
    * Retrieve a value from the map.
    *
    * @param key the key to value
    * @return the value or null if there is no entry
    */
   public Object getValue(String key)
   {
      if (valueMap != null)
         return valueMap.get(key);
      return null;
   }
}
