/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.mbeanserver;

import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.jboss.jmx.mbeanserver.DelegateMBeanServer;
import org.jboss.jmx.mbeanserver.DelegateState;
import org.jboss.jmx.mbeanserver.JBossMBeanRegistry;
import org.jboss.jmx.mbeanserver.RegistryEntry;
import org.jboss.jmx.mbeanserver.SecurityActions;

public class JBossMBeanServer
extends DelegateMBeanServer {
    private static ObjectName OLD_REGISTRY_NAME;
    public static ObjectName REGISTRY_NAME;
    private JBossMBeanRegistry registry;

    public JBossMBeanServer(DelegateState state) {
        super(state);
        try {
            OLD_REGISTRY_NAME = new ObjectName("JMImplementation:type=MBeanRegistry");
            REGISTRY_NAME = new ObjectName("org.jboss.jmx:type=MBeanRegistry");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Unexpected error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            MBeanInfo mBeanInfo = this.getNext().getMBeanInfo(this.mapObjectName(name));
            return mBeanInfo;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            Object object = this.getNext().getAttribute(name, attribute);
            return object;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            AttributeList attributeList = this.getNext().getAttributes(name, attributes);
            return attributeList;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            this.getNext().setAttribute(name, attribute);
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            AttributeList attributeList = this.getNext().setAttributes(name, attributes);
            return attributeList;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            Object object = this.getNext().invoke(name, operationName, params, signature);
            return object;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        RegistryEntry previous = this.checkCurrent(name, null);
        try {
            ObjectInstance result = this.getNext().registerMBean(object, name);
            try {
                this.register(result, null);
            }
            catch (InstanceAlreadyExistsException e) {
                try {
                    this.getNext().unregisterMBean(name);
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
                throw e;
            }
            ObjectInstance objectInstance = result;
            return objectInstance;
        }
        finally {
            this.restoreCurrent(previous);
        }
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.getNext().unregisterMBean(name);
        try {
            this.unregister(name);
        }
        catch (InstanceNotFoundException ignored) {
            ignored.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        RegistryEntry previous = this.checkCurrent(name, null);
        try {
            ObjectInstance result = this.getNext().createMBean(className, name, params, signature);
            try {
                this.register(result, null);
            }
            catch (InstanceAlreadyExistsException e) {
                try {
                    this.getNext().unregisterMBean(name);
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
                throw e;
            }
            ObjectInstance objectInstance = result;
            return objectInstance;
        }
        finally {
            this.restoreCurrent(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        RegistryEntry previous = this.checkCurrent(name, null);
        try {
            ObjectInstance objectInstance;
            block12: {
                ClassLoader cl = this.getOuter().getClassLoader(loaderName);
                ClassLoader previousCl = null;
                if (cl != null) {
                    previousCl = SecurityActions.setContextClassLoader(cl);
                }
                try {
                    ObjectInstance result = this.getNext().createMBean(className, name, loaderName, params, signature);
                    try {
                        this.register(result, loaderName);
                    }
                    catch (InstanceAlreadyExistsException e) {
                        try {
                            this.getNext().unregisterMBean(name);
                        }
                        catch (Exception ignored) {
                            ignored.printStackTrace();
                        }
                        throw e;
                    }
                    objectInstance = result;
                    if (cl == null) break block12;
                }
                catch (Throwable throwable) {
                    if (cl != null) {
                        SecurityActions.setContextClassLoader(previousCl);
                    }
                    throw throwable;
                }
                SecurityActions.setContextClassLoader(previousCl);
            }
            return objectInstance;
        }
        finally {
            this.restoreCurrent(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        ClassLoader cl = this.getOuter().getClassLoader(loaderName);
        ClassLoader previousCl = null;
        if (cl != null) {
            previousCl = SecurityActions.setContextClassLoader(cl);
        }
        try {
            RegistryEntry previous = this.checkCurrent(name, cl);
            try {
                ObjectInstance result = this.getNext().createMBean(className, name, loaderName);
                try {
                    this.register(result, loaderName);
                }
                catch (InstanceAlreadyExistsException e) {
                    try {
                        this.getNext().unregisterMBean(name);
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                    }
                    throw e;
                }
                ObjectInstance objectInstance = result;
                this.restoreCurrent(previous);
                return objectInstance;
            }
            catch (Throwable throwable) {
                this.restoreCurrent(previous);
                throw throwable;
            }
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previousCl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        RegistryEntry previous = this.checkCurrent(name, null);
        try {
            ObjectInstance result = this.getNext().createMBean(className, name);
            try {
                this.register(result, null);
            }
            catch (InstanceAlreadyExistsException e) {
                try {
                    this.getNext().unregisterMBean(name);
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
                throw e;
            }
            ObjectInstance objectInstance = result;
            return objectInstance;
        }
        finally {
            this.restoreCurrent(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        ClassLoader cl = null;
        if (loaderName != null) {
            cl = this.getOuter().getClassLoader(loaderName);
        }
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            Object object = this.getNext().instantiate(className, loaderName, params, signature);
            return object;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.getNext().instantiate(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            ObjectInstance objectInstance = this.getNext().getObjectInstance(name);
            return objectInstance;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            boolean bl = this.getNext().isInstanceOf(name, className);
            return bl;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    public boolean isRegistered(ObjectName name) {
        return this.getNext().isRegistered(this.mapObjectName(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            this.getNext().addNotificationListener(name, listener, filter, handback);
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            this.getNext().addNotificationListener(name, listener, filter, handback);
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            this.getNext().removeNotificationListener(name, listener, filter, handback);
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            this.getNext().removeNotificationListener(name, listener);
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            this.getNext().removeNotificationListener(name, listener, filter, handback);
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            this.getNext().removeNotificationListener(name, listener);
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        ClassLoader cl = this.getTCL(loaderName);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            ClassLoader classLoader = this.getNext().getClassLoader(loaderName);
            return classLoader;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        ClassLoader cl = this.getTCL(mbeanName = this.mapObjectName(mbeanName));
        if (cl != null) {
            return cl;
        }
        return this.getNext().getClassLoaderFor(mbeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        name = this.mapObjectName(name);
        ClassLoader cl = this.getTCL(name);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            ObjectInputStream objectInputStream = this.getNext().deserialize(name, data);
            return objectInputStream;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        ClassLoader cl = this.getOuter().getClassLoader(loaderName);
        ClassLoader previous = null;
        if (cl != null) {
            previous = SecurityActions.setContextClassLoader(cl);
        }
        try {
            ObjectInputStream objectInputStream = this.getNext().deserialize(className, loaderName, data);
            return objectInputStream;
        }
        finally {
            if (cl != null) {
                SecurityActions.setContextClassLoader(previous);
            }
        }
    }

    protected RegistryEntry checkCurrent(ObjectName name, ClassLoader cl) {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null object name"));
        }
        RegistryEntry current = JBossMBeanRegistry.current.get();
        if (current == null || !name.equals(current.getObjectName())) {
            HashMap<String, Object> values = null;
            if (cl != null) {
                values = new HashMap<String, Object>();
                values.put("org.jboss.mx.classloader", cl);
            }
            JBossMBeanRegistry.current.set(new RegistryEntry(name, values));
        }
        return current;
    }

    protected void restoreCurrent(RegistryEntry previous) {
        JBossMBeanRegistry.current.set(previous);
    }

    protected void register(ObjectInstance instance, ObjectName loaderName) throws InstanceAlreadyExistsException {
        RegistryEntry current = JBossMBeanRegistry.current.get();
        if (current != null && instance.getObjectName().equals(current.getObjectName())) {
            this.registry.add(current);
        } else {
            HashMap<String, ClassLoader> values = null;
            if (loaderName != null) {
                ClassLoader cl = null;
                try {
                    cl = this.getOuter().getClassLoader(loaderName);
                }
                catch (InstanceNotFoundException ignored) {
                    // empty catch block
                }
                if (cl != null) {
                    values = new HashMap<String, ClassLoader>();
                    values.put("org.jboss.mx.classloader", cl);
                }
            }
            this.registry.add(new RegistryEntry(instance.getObjectName(), values));
        }
    }

    protected void unregister(ObjectName name) throws InstanceNotFoundException {
        this.registry.remove(name);
    }

    protected ClassLoader getTCL(ObjectName name) throws InstanceNotFoundException {
        RegistryEntry entry = this.registry.get(name, false);
        if (entry == null && (entry = JBossMBeanRegistry.current.get()) != null && !name.equals(entry.getObjectName())) {
            entry = null;
        }
        if (entry == null) {
            if ("JMImplementation".equals(name.getDomain())) {
                return null;
            }
            throw new InstanceNotFoundException(name + " is not registered");
        }
        return entry.getClassLoader();
    }

    protected ObjectName mapObjectName(ObjectName name) {
        if (OLD_REGISTRY_NAME.equals(name)) {
            return REGISTRY_NAME;
        }
        return name;
    }

    protected void setNext(MBeanServer next) {
        super.setNext(next);
        MBeanServer outer = this.getOuter();
        try {
            RequiredModelMBean mbean = new RequiredModelMBean(JBossMBeanServer.getRegistryManagementInterface());
            this.registry = new JBossMBeanRegistry(outer);
            mbean.setManagedResource(this.registry, "ObjectReference");
            this.registerMBean(mbean, REGISTRY_NAME);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error installing registry");
        }
    }

    private static ModelMBeanInfo getRegistryManagementInterface() {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean BOOLEAN = true;
        DescriptorSupport descDefaultDomain = new DescriptorSupport();
        descDefaultDomain.setField("name", "DefaultDomain");
        descDefaultDomain.setField("descriptorType", "attribute");
        descDefaultDomain.setField("displayName", "Default Domain");
        descDefaultDomain.setField("currencyTimeLimit", "-1");
        ModelMBeanAttributeInfo defaultDomainInfo = new ModelMBeanAttributeInfo("DefaultDomain", String.class.getName(), "The domain to use when an object name has no domain", true, false, false, descDefaultDomain);
        DescriptorSupport descSize = new DescriptorSupport();
        descSize.setField("name", "Size");
        descSize.setField("descriptorType", "attribute");
        descSize.setField("displayName", "Size");
        descSize.setField("getMethod", "getSize");
        ModelMBeanAttributeInfo sizeInfo = new ModelMBeanAttributeInfo("Size", Integer.TYPE.getName(), "The number of MBeans registered in the MBean Server", true, false, false, descSize);
        DescriptorSupport descRegisterMBean = new DescriptorSupport();
        descRegisterMBean.setField("name", "registerMBean");
        descRegisterMBean.setField("descriptorType", "operation");
        descRegisterMBean.setField("role", "operation");
        MBeanParameterInfo[] registerMBeanParms = new MBeanParameterInfo[]{new MBeanParameterInfo("Resource", Object.class.getName(), "A compliant MBean to be registered in the MBean Server"), new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "The object name of the MBean"), new MBeanParameterInfo("ValueMap", Map.class.getName(), "Values associated with the registration")};
        ModelMBeanOperationInfo registerMBeanInfo = new ModelMBeanOperationInfo("registerMBean", "Adds an MBean in the MBeanServer", registerMBeanParms, ObjectInstance.class.getName(), 2, descRegisterMBean);
        DescriptorSupport descUnregisterMBean = new DescriptorSupport();
        descUnregisterMBean.setField("name", "unregisterMBean");
        descUnregisterMBean.setField("descriptorType", "operation");
        descUnregisterMBean.setField("role", "operation");
        MBeanParameterInfo[] unregisterMBeanParms = new MBeanParameterInfo[]{new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "The object name of the MBean to remove")};
        ModelMBeanOperationInfo unregisterMBeanInfo = new ModelMBeanOperationInfo("unregisterMBean", "Removes an MBean from the MBeanServer", unregisterMBeanParms, Void.TYPE.getName(), 1, descUnregisterMBean);
        DescriptorSupport descGetSize = new DescriptorSupport();
        descGetSize.setField("name", "getSize");
        descGetSize.setField("descriptorType", "operation");
        descGetSize.setField("role", "getter");
        MBeanParameterInfo[] getSizeParms = new MBeanParameterInfo[]{};
        ModelMBeanOperationInfo getSizeInfo = new ModelMBeanOperationInfo("getSize", "Gets the number of MBeans registered", getSizeParms, Integer.TYPE.getName(), 0, descGetSize);
        DescriptorSupport descGetValue = new DescriptorSupport();
        descGetValue.setField("name", "getValue");
        descGetValue.setField("descriptorType", "operation");
        descGetValue.setField("role", "operation");
        MBeanParameterInfo[] getValueParms = new MBeanParameterInfo[]{new MBeanParameterInfo("ObjectName", ObjectName.class.getName(), "The object name of the registered MBean"), new MBeanParameterInfo("Key", String.class.getName(), "The key to the value stored")};
        ModelMBeanOperationInfo getValueInfo = new ModelMBeanOperationInfo("getValue", "Get a value stored in the MBean's registration", getValueParms, Object.class.getName(), 0, descGetValue);
        DescriptorSupport descMBean = new DescriptorSupport();
        descMBean.setField("name", RequiredModelMBean.class.getName());
        descMBean.setField("descriptorType", "MBean");
        descMBean.setField("displayName", "MBeanServer Registry");
        ModelMBeanAttributeInfo[] attrInfo = new ModelMBeanAttributeInfo[]{defaultDomainInfo, sizeInfo};
        ModelMBeanConstructorInfo[] ctorInfo = null;
        ModelMBeanOperationInfo[] opInfo = new ModelMBeanOperationInfo[]{registerMBeanInfo, unregisterMBeanInfo, getSizeInfo, getValueInfo};
        ModelMBeanNotificationInfo[] notifyInfo = null;
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(RequiredModelMBean.class.getName(), "Managed Bean Registry", attrInfo, ctorInfo, opInfo, notifyInfo, (Descriptor)descMBean);
        return info;
    }
}

