/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Middleware LLC, and individual contributors
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.jmx.mbeanserver;

import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;

/**
 * DelegateState.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public class DelegateState
{
   /** The outer most mbeanserver */
   private MBeanServer outer;
   
   /** The MBeanServer delegate */
   private MBeanServerDelegate delegate;
   
   /**
    * Construct an DelegateState.
    *
    * @param outer the wrapping MBeanServer, passed to MBeans
    *        at registration.
    * @param delegate the delegate to use for Notifications.
    */
   public DelegateState(MBeanServer outer, MBeanServerDelegate delegate)
   {
      if (delegate == null)
         throw new IllegalStateException("Null delegate");
      this.outer = outer;
      this.delegate = delegate;
   }

   /**
    * Get the outer.
    * 
    * @return the outer.
    */
   public MBeanServer getOuter()
   {
      return outer;
   }

   /**
    * Set the outer.
    * 
    * @param outer the outer.
    */
   protected void setOuter(MBeanServer outer)
   {
      this.outer = outer;
   }

   /**
    * Get the delegate.
    * 
    * @return the delegate.
    */
   public MBeanServerDelegate getDelegate()
   {
      return delegate;
   }
}
