/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingsInitializer {
    private static Logger log = Logger.getLogger(BindingsInitializer.class);
    private Map<String, ?> bindings;
    private InitialContext ctx;

    public Map<String, ?> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, ?> bindings) {
        this.bindings = bindings;
    }

    public InitialContext getCtx() {
        return this.ctx;
    }

    public void setCtx(InitialContext ctx) {
        this.ctx = ctx;
    }

    public void start() throws NamingException {
        log.debug((Object)"start");
        if (this.ctx != null && this.bindings != null) {
            for (Map.Entry<String, ?> entry : this.bindings.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                log.debug((Object)("Binding, key=" + key + ", value=" + value + ", type=" + value.getClass()));
                Util.bind((Context)this.ctx, (String)key, value);
            }
        }
    }

    public void stop() throws NamingException {
        if (this.ctx != null && this.bindings != null) {
            for (String key : this.bindings.keySet()) {
                Util.unbind((Context)this.ctx, (String)key);
            }
        }
    }
}

