/*
 * Decompiled with CFR 0.152.
 */
package org.jnp.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.spi.ResolveResult;
import org.jboss.logging.Logger;
import org.jboss.naming.JndiPermission;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.interfaces.NamingEvents;
import org.jnp.interfaces.NamingParser;
import org.jnp.server.EventListeners;
import org.jnp.server.EventMgr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingServer
implements Naming,
NamingEvents,
Serializable {
    private static Logger log = Logger.getLogger(NamingServer.class);
    private static final long serialVersionUID = 4183855539507934373L;
    protected Map<String, Binding> table = this.createTable();
    protected Name prefix;
    protected NamingParser parser = new NamingParser();
    protected NamingServer parent;
    private transient EventListeners listeners;
    private transient EventMgr eventMgr;
    private transient boolean trace;

    public NamingServer() throws NamingException {
        this(null, null);
    }

    public NamingServer(Name prefix, NamingServer parent) throws NamingException {
        this(null, null, null);
    }

    public NamingServer(Name prefix, NamingServer parent, EventMgr eventMgr) throws NamingException {
        if (prefix == null) {
            prefix = this.parser.parse("");
        }
        this.prefix = prefix;
        this.parent = parent;
        this.eventMgr = eventMgr;
        this.trace = log.isTraceEnabled();
    }

    @Override
    public synchronized void addNamingListener(EventContext context, Name target, int scope, NamingListener l) throws NamingException {
        if (this.listeners == null) {
            this.listeners = new EventListeners(context);
        }
        if (this.trace) {
            log.trace((Object)("addNamingListener, target: " + target + ", scope: " + scope));
        }
        this.listeners.addNamingListener(context, target, scope, l);
    }

    @Override
    public void removeNamingListener(NamingListener l) throws NamingException {
        if (this.listeners != null) {
            this.listeners.removeNamingListener(l);
        }
    }

    @Override
    public boolean targetMustExist() throws NamingException {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void bind(Name name, Object obj, String className) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("An empty name cannot be passed to bind");
        }
        if (name.size() > 1) {
            Object ctx = this.getObject(name);
            if (ctx == null) throw new NameNotFoundException(name.toString() + " in: " + this.prefix);
            if (ctx instanceof NamingServer) {
                NamingServer ns = (NamingServer)ctx;
                ns.bind(name.getSuffix(1), obj, className);
                return;
            }
            if (!(ctx instanceof Reference)) throw new NotContextException();
            if (((Reference)ctx).get("nns") == null) throw new NotContextException();
            CannotProceedException cpe = new CannotProceedException();
            cpe.setResolvedObj(ctx);
            cpe.setRemainingName(name.getSuffix(1));
            throw cpe;
        }
        if (name.get(0).equals("")) {
            throw new InvalidNameException("An empty name cannot be passed to bind");
        }
        if (this.trace) {
            log.trace((Object)("bind " + name + "=" + obj + ", " + className));
        }
        try {
            this.getBinding(name);
            throw new NameAlreadyBoundException(name.toString());
        }
        catch (NameNotFoundException e) {
            Name fullName = (Name)this.prefix.clone();
            fullName.addAll(name);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                JndiPermission perm = new JndiPermission(fullName, 1);
                sm.checkPermission(perm);
            }
            Binding newb = this.setBinding(name, obj, className);
            Binding oldb = null;
            this.fireEvent(fullName, oldb, newb, 0, "bind");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized void rebind(Name name, Object obj, String className) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("An empty name cannot be passed to rebind");
        }
        if (name.size() > 1) {
            Object ctx = this.getObject(name);
            if (ctx instanceof NamingServer) {
                ((NamingServer)ctx).rebind(name.getSuffix(1), obj, className);
                return;
            }
            if (!(ctx instanceof Reference)) throw new NotContextException();
            if (((Reference)ctx).get("nns") == null) throw new NotContextException();
            CannotProceedException cpe = new CannotProceedException();
            cpe.setResolvedObj(ctx);
            cpe.setRemainingName(name.getSuffix(1));
            throw cpe;
        }
        if (name.get(0).equals("")) {
            throw new InvalidNameException("An empty name cannot be passed to rebind");
        }
        SecurityManager sm = System.getSecurityManager();
        Name fullName = (Name)this.prefix.clone();
        String comp = name.get(0);
        fullName.add(comp);
        if (sm != null) {
            JndiPermission perm = new JndiPermission(fullName, 2);
            sm.checkPermission(perm);
        }
        Binding oldb = this.table.get(comp);
        Binding newb = this.setBinding(name, obj, className);
        if (this.listeners == null) return;
        int type = 3;
        if (oldb == null) {
            type = 0;
        }
        this.fireEvent(fullName, oldb, newb, type, "rebind");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public synchronized void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException();
        }
        if (name.size() > 1) {
            Object ctx = this.getObject(name);
            if (ctx instanceof NamingServer) {
                ((NamingServer)ctx).unbind(name.getSuffix(1));
                return;
            }
            if (!(ctx instanceof Reference)) throw new NotContextException();
            if (((Reference)ctx).get("nns") == null) throw new NotContextException();
            CannotProceedException cpe = new CannotProceedException();
            cpe.setResolvedObj(ctx);
            cpe.setRemainingName(name.getSuffix(1));
            throw cpe;
        }
        if (name.get(0).equals("")) {
            throw new InvalidNameException();
        }
        if (this.getBinding(name) == null) throw new NameNotFoundException();
        SecurityManager sm = System.getSecurityManager();
        Name fullName = (Name)this.prefix.clone();
        fullName.addAll(name);
        if (sm != null) {
            JndiPermission perm = new JndiPermission(fullName, 4);
            sm.checkPermission(perm);
        }
        Binding newb = null;
        Binding oldb = this.removeBinding(name);
        int type = 1;
        this.fireEvent(fullName, oldb, newb, type, "unbind");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object lookup(Name name) throws NamingException {
        Object res;
        if (name.isEmpty()) {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) return new NamingContext(null, (Name)this.prefix.clone(), this.getRoot());
            JndiPermission perm = new JndiPermission(this.prefix, 8);
            sm.checkPermission(perm);
            return new NamingContext(null, (Name)this.prefix.clone(), this.getRoot());
        }
        if (name.size() > 1) {
            Object ctx = this.getObject(name);
            if (ctx instanceof NamingServer) {
                return ((NamingServer)ctx).lookup(name.getSuffix(1));
            }
            if (!(ctx instanceof Reference)) throw new NotContextException();
            if (((Reference)ctx).get("nns") == null) return new ResolveResult(ctx, name.getSuffix(1));
            CannotProceedException cpe = new CannotProceedException();
            cpe.setResolvedObj(ctx);
            cpe.setRemainingName(name.getSuffix(1));
            throw cpe;
        }
        if (name.get(0).equals("")) {
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) return new NamingContext(null, (Name)this.prefix.clone(), this.getRoot());
            JndiPermission perm = new JndiPermission(this.prefix, 8);
            sm.checkPermission(perm);
            return new NamingContext(null, (Name)this.prefix.clone(), this.getRoot());
        }
        SecurityManager sm = System.getSecurityManager();
        Name fullName = (Name)this.prefix.clone();
        fullName.addAll(name);
        if (sm != null) {
            JndiPermission perm = new JndiPermission(fullName, 8);
            sm.checkPermission(perm);
        }
        if (!((res = this.getObject(name)) instanceof NamingServer)) return res;
        return new NamingContext(null, fullName, this.getRoot());
    }

    @Override
    public Collection<NameClassPair> list(Name name) throws NamingException {
        if (name.isEmpty()) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                JndiPermission perm = new JndiPermission(this.prefix, 16);
                sm.checkPermission(perm);
            }
            ArrayList<NameClassPair> list = new ArrayList<NameClassPair>();
            for (Binding b : this.table.values()) {
                NameClassPair ncp = new NameClassPair(b.getName(), b.getClassName(), true);
                list.add(ncp);
            }
            return list;
        }
        Object ctx = this.getObject(name);
        if (ctx instanceof NamingServer) {
            return ((NamingServer)ctx).list(name.getSuffix(1));
        }
        if (ctx instanceof Reference) {
            if (((Reference)ctx).get("nns") != null) {
                CannotProceedException cpe = new CannotProceedException();
                cpe.setResolvedObj(ctx);
                cpe.setRemainingName(name.getSuffix(1));
                throw cpe;
            }
            throw new NotContextException();
        }
        throw new NotContextException();
    }

    @Override
    public Collection<Binding> listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                JndiPermission perm = new JndiPermission(this.prefix, 32);
                sm.checkPermission(perm);
            }
            Collection<Binding> bindings = this.table.values();
            ArrayList<Binding> newBindings = new ArrayList<Binding>(bindings.size());
            for (Binding b : bindings) {
                if (b.getObject() instanceof NamingServer) {
                    Name n = (Name)this.prefix.clone();
                    n.add(b.getName());
                    newBindings.add(new Binding(b.getName(), b.getClassName(), new NamingContext(null, n, this.getRoot())));
                    continue;
                }
                newBindings.add(b);
            }
            return newBindings;
        }
        Object ctx = this.getObject(name);
        if (ctx instanceof NamingServer) {
            return ((NamingServer)ctx).listBindings(name.getSuffix(1));
        }
        if (ctx instanceof Reference) {
            if (((Reference)ctx).get("nns") != null) {
                CannotProceedException cpe = new CannotProceedException();
                cpe.setResolvedObj(ctx);
                cpe.setRemainingName(name.getSuffix(1));
                throw cpe;
            }
            throw new NotContextException();
        }
        throw new NotContextException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 0) {
            throw new InvalidNameException("Cannot pass an empty name to createSubcontext");
        }
        NamingException ex = null;
        Context subCtx = null;
        if (name.size() > 1) {
            Object ctx = this.getObject(name);
            if (ctx != null) {
                Name subCtxName = name.getSuffix(1);
                if (ctx instanceof NamingServer) {
                    return ((NamingServer)ctx).createSubcontext(subCtxName);
                }
                if (ctx instanceof Reference) {
                    if (((Reference)ctx).get("nns") != null) {
                        CannotProceedException cpe = new CannotProceedException();
                        cpe.setResolvedObj(ctx);
                        cpe.setRemainingName(subCtxName);
                        throw cpe;
                    }
                    ex = new NotContextException();
                    ex.setResolvedName(name.getPrefix(0));
                    ex.setRemainingName(subCtxName);
                    throw ex;
                }
                ex = new NotContextException();
                ex.setResolvedName(name.getPrefix(0));
                ex.setRemainingName(subCtxName);
                throw ex;
            }
            ex = new NameNotFoundException();
            ex.setRemainingName(name);
            throw ex;
        }
        Binding binding = this.table.get(name.get(0));
        if (binding != null) {
            ex = new NameAlreadyBoundException();
            ex.setResolvedName(this.prefix);
            ex.setRemainingName(name);
            throw ex;
        }
        Name fullName = (Name)this.prefix.clone();
        fullName.addAll(name);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            JndiPermission perm = new JndiPermission(fullName, 64);
            sm.checkPermission(perm);
        }
        NamingServer subContext = this.createNamingServer(fullName, this);
        subCtx = new NamingContext(null, fullName, this.getRoot());
        this.setBinding(name, subContext, NamingContext.class.getName());
        Binding newb = new Binding(name.toString(), NamingContext.class.getName(), subCtx, true);
        if (this.listeners == null) return subCtx;
        Binding oldb = null;
        this.fireEvent(fullName, oldb, newb, 0, "createSubcontext");
        return subCtx;
    }

    public Naming getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    protected Map<String, Binding> createTable() {
        return new ConcurrentHashMap<String, Binding>();
    }

    protected NamingServer createNamingServer(Name prefix, NamingServer parent) throws NamingException {
        return new NamingServer(prefix, parent, this.eventMgr);
    }

    protected void fireEvent(Name fullName, Binding oldb, Binding newb, int type, String changeInfo) throws NamingException {
        HashSet<Integer> scopes;
        if (this.eventMgr == null) {
            if (this.trace) {
                log.trace((Object)"Skipping event dispatch because there is no EventMgr");
            }
            return;
        }
        if (this.listeners != null) {
            if (this.trace) {
                log.trace((Object)("fireEvent, type: " + type + ", fullName: " + fullName));
            }
            scopes = new HashSet<Integer>();
            scopes.add(0);
            scopes.add(1);
            scopes.add(2);
            this.eventMgr.fireEvent(fullName, oldb, newb, type, changeInfo, this.listeners, scopes);
        } else if (this.trace) {
            log.trace((Object)("fireEvent, type: " + type + ", fullName: " + fullName));
        }
        scopes = new HashSet();
        scopes.add(2);
        NamingServer nsparent = this.parent;
        while (nsparent != null) {
            if (nsparent.listeners != null) {
                this.eventMgr.fireEvent(fullName, oldb, newb, type, changeInfo, nsparent.listeners, scopes);
            }
            nsparent = nsparent.parent;
        }
    }

    private Binding setBinding(Name name, Object obj, String className) {
        String n = name.toString();
        Binding b = new Binding(n, className, obj, true);
        this.table.put(n, b);
        if (this.trace) {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append(", setBinding: name=");
            tmp.append(name);
            tmp.append(", obj=");
            tmp.append(obj);
            tmp.append(", className=");
            tmp.append(className);
            log.trace((Object)tmp.toString());
        }
        return b;
    }

    private Binding getBinding(String key) throws NameNotFoundException {
        Binding b = this.table.get(key);
        if (b == null) {
            if (log.isTraceEnabled()) {
                StringBuffer tmp = new StringBuffer(super.toString());
                tmp.append(", No binding for: ");
                tmp.append(key);
                tmp.append(" in context ");
                tmp.append(this.prefix);
                tmp.append(", bindings:\n");
                for (Binding value : this.table.values()) {
                    tmp.append(value.getName());
                    tmp.append('=');
                    if (value.getObject() != null) {
                        tmp.append(value.getObject().toString());
                    } else {
                        tmp.append("null");
                    }
                    tmp.append('\n');
                }
                log.trace((Object)tmp.toString());
            }
            throw new NameNotFoundException(key + " not bound");
        }
        return b;
    }

    private Binding getBinding(Name key) throws NameNotFoundException {
        return this.getBinding(key.get(0));
    }

    private Object getObject(Name key) throws NameNotFoundException {
        return this.getBinding(key).getObject();
    }

    private Binding removeBinding(Name name) {
        return this.table.remove(name.get(0));
    }
}

