/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid;

import AtmiBroker.EndpointQueue;
import AtmiBroker.EndpointQueueHelper;
import AtmiBroker.EndpointQueuePOA;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.ResponseMonitor;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.EventListener;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.JtsTransactionImple;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Message;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.OrbManagement;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Receiver;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionException;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.Servant;

public class CorbaReceiverImpl
extends EndpointQueuePOA
implements Receiver {
    private static final Logger log = LogManager.getLogger(CorbaReceiverImpl.class);
    private POA m_default_poa;
    private String callbackIOR;
    private List<Message> returnData = new ArrayList<Message>();
    private byte[] activate_object;
    private int timeout = 0;
    private EventListener eventListener;
    private int pad = 0;
    private ResponseMonitor responseMonitor;
    private int cd;
    private boolean closed;

    CorbaReceiverImpl(OrbManagement orbManagement, Properties properties, int cd, ResponseMonitor responseMonitor) throws ConnectionException {
        this(null, orbManagement, properties, cd, responseMonitor);
    }

    CorbaReceiverImpl(EventListener eventListener, OrbManagement orbManagement, Properties properties) throws ConnectionException {
        this(eventListener, orbManagement, properties, -1, null);
    }

    private CorbaReceiverImpl(EventListener eventListener, OrbManagement orbManagement, Properties properties, int cd, ResponseMonitor responseMonitor) throws ConnectionException {
        log.debug((java.lang.Object)"ClientCallbackImpl constructor");
        ORB orb = orbManagement.getOrb();
        POA poa = orbManagement.getRootPoa();
        this.eventListener = eventListener;
        this.cd = cd;
        this.responseMonitor = responseMonitor;
        try {
            try {
                Policy[] policies = new Policy[]{};
                this.m_default_poa = poa.create_POA("TODO", poa.the_POAManager(), policies);
            }
            catch (AdapterAlreadyExists e) {
                this.m_default_poa = poa.find_POA("TODO", true);
            }
            log.debug((java.lang.Object)"CorbaReceiverImpl createCallbackObject");
            this.activate_object = this.m_default_poa.activate_object((Servant)this);
            log.debug((java.lang.Object)("activated this " + this));
            Object tmp_ref = this.m_default_poa.servant_to_reference((Servant)this);
            log.debug((java.lang.Object)("created reference " + tmp_ref));
            EndpointQueue clientCallback = EndpointQueueHelper.narrow((Object)tmp_ref);
            log.debug((java.lang.Object)("narrowed reference " + clientCallback));
            this.callbackIOR = orb.object_to_string((Object)clientCallback);
            log.debug((java.lang.Object)("Created:" + this.callbackIOR));
        }
        catch (Throwable t) {
            throw new ConnectionException(12, "Cannot create the receiver", t);
        }
        this.timeout = Integer.parseInt(properties.getProperty("ReceiveTimeout")) * 1000 + Integer.parseInt(properties.getProperty("TimeToLive")) * 1000;
        log.debug((java.lang.Object)("Timeout set as: " + this.timeout));
    }

    public POA _default_POA() {
        log.debug((java.lang.Object)"ClientCallbackImpl _default_POA");
        return this.m_default_poa;
    }

    public synchronized void send(String replyto_ior, short rval, int rcode, byte[] idata, int ilen, int cd, int flags, String type, String subtype) {
        log.debug((java.lang.Object)("Received: " + this.callbackIOR));
        Message message = new Message();
        message.cd = cd;
        message.replyTo = replyto_ior;
        message.flags = flags;
        message.control = null;
        message.rval = rval;
        message.rcode = rcode;
        message.type = type;
        message.subtype = subtype;
        message.len = ilen - this.pad;
        if (message.len == 0 && message.type == "") {
            message.data = null;
        } else {
            message.data = new byte[message.len];
            System.arraycopy(idata, 0, message.data, 0, message.len);
        }
        if (this.eventListener != null) {
            log.debug((java.lang.Object)"Event listener will be called back");
            if (message.rval == 3) {
                this.eventListener.setLastEvent(1L, message.rcode);
            } else if (message.rcode == 10) {
                this.eventListener.setLastEvent(2L, message.rcode);
            } else if (message.rval == 1) {
                this.eventListener.setLastEvent(4L, message.rcode);
            }
        }
        this.returnData.add(message);
        if (this.responseMonitor != null) {
            this.responseMonitor.responseReceived(this.cd, false);
        }
        log.trace((java.lang.Object)"notifying");
        this.notify();
        log.trace((java.lang.Object)"notifed");
    }

    @Override
    public java.lang.Object getReplyTo() {
        return this.callbackIOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message receive(long flags) throws ConnectionException {
        log.debug((java.lang.Object)("Receiving: " + this.callbackIOR));
        CorbaReceiverImpl corbaReceiverImpl = this;
        synchronized (corbaReceiverImpl) {
            if ((flags & 1L) != 1L) {
                if (this.returnData.isEmpty()) {
                    try {
                        log.debug((java.lang.Object)("Waiting: " + this.callbackIOR));
                        this.wait(this.determineTimeout(flags));
                        log.debug((java.lang.Object)("Waited: " + this.callbackIOR));
                    }
                    catch (InterruptedException e) {
                        log.error((java.lang.Object)"Caught exception", (Throwable)e);
                    }
                }
            } else {
                log.debug((java.lang.Object)"Not waiting for the response, hope its there!");
            }
            if (this.returnData.isEmpty() && (flags & 1L) == 1L) {
                throw new ConnectionException(3, "Did not receive a message");
            }
            if (this.returnData.isEmpty()) {
                log.debug((java.lang.Object)("Empty return data: " + this.callbackIOR));
                if (JtsTransactionImple.hasTransaction()) {
                    try {
                        log.debug((java.lang.Object)"Marking rollbackOnly");
                        TransactionImpl.current().rollback_only();
                    }
                    catch (TransactionException e) {
                        throw new ConnectionException(12, "Could not mark transaction for rollback only");
                    }
                }
                throw new ConnectionException(13, "Did not receive a message");
            }
            Message message = this.returnData.remove(0);
            if (message != null) {
                log.debug((java.lang.Object)"Message was available");
                if (message.rval == 3) {
                    if (TransactionImpl.current() != null) {
                        try {
                            log.debug((java.lang.Object)"Marking rollbackOnly as disconnection");
                            TransactionImpl.current().rollback_only();
                        }
                        catch (TransactionException e) {
                            throw new ConnectionException(12, "Could not mark transaction for rollback only");
                        }
                    }
                } else if (message.rcode == 10) {
                    if (TransactionImpl.current() != null) {
                        try {
                            log.debug((java.lang.Object)"Marking rollbackOnly as svc err");
                            TransactionImpl.current().rollback_only();
                        }
                        catch (TransactionException e) {
                            throw new ConnectionException(12, "Could not mark transaction for rollback only");
                        }
                    }
                } else if (message.rval == 1 && TransactionImpl.current() != null) {
                    try {
                        TransactionImpl.current().rollback_only();
                    }
                    catch (TransactionException e) {
                        throw new ConnectionException(12, "Could not mark transaction for rollback only");
                    }
                }
            } else {
                log.debug((java.lang.Object)"message was null");
            }
            if (this.responseMonitor != null) {
                this.responseMonitor.responseReceived(this.cd, true);
            }
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        log.debug((java.lang.Object)"disconnect");
        try {
            log.debug((java.lang.Object)"deactivating");
            this.m_default_poa.deactivate_object(this.activate_object);
            log.debug((java.lang.Object)"deactivated");
        }
        catch (Throwable t) {
            log.error((java.lang.Object)"Could not unbind service factory", t);
        }
        log.trace((java.lang.Object)"synchronizing");
        CorbaReceiverImpl corbaReceiverImpl = this;
        synchronized (corbaReceiverImpl) {
            log.trace((java.lang.Object)"notifying");
            this.notify();
            log.trace((java.lang.Object)"notified");
        }
    }

    @Override
    public void close() throws ConnectionException {
        log.debug((java.lang.Object)("close: " + this.callbackIOR));
        if (this.closed) {
            throw new ConnectionException(9, "Sender already closed");
        }
        this.disconnect();
        this.closed = true;
    }

    @Override
    public int determineTimeout(long flags) throws ConnectionException {
        if ((flags & 0x20L) == 32L) {
            return 0;
        }
        return this.timeout;
    }

    @Override
    public int getCd() {
        return this.cd;
    }

    @Override
    public java.lang.Object getEndpoint() throws ConnectionException {
        return null;
    }
}

