/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.ResponseMonitor;
import org.jboss.narayana.blacktie.jatmibroker.core.server.SocketServer;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.EventListener;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.JtsTransactionImple;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Message;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Receiver;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionException;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;

public class SocketReceiverImpl
implements Receiver,
Runnable {
    private static final Logger log = LogManager.getLogger(SocketReceiverImpl.class);
    private int cd;
    private int timeout = 0;
    private SocketServer server;
    private Socket socket;
    private Thread thread;
    private List<Message> data;
    private ResponseMonitor responseMonitor;
    private EventListener eventListener;
    private boolean closed;
    private String replyto;

    public SocketReceiverImpl(SocketServer server, Properties properties, int cd, ResponseMonitor responseMonitor, EventListener eventListener) throws ConnectionException {
        log.debug((Object)"create socket receiver with server");
        this.server = server;
        this.responseMonitor = responseMonitor;
        this.eventListener = eventListener;
        this.cd = cd;
        this.replyto = new StringBuffer().append(server.getAddr()).append(":").append(server.getPort()).append(":").append(cd).toString();
        this.timeout = Integer.parseInt(properties.getProperty("ReceiveTimeout")) * 1000 + Integer.parseInt(properties.getProperty("TimeToLive")) * 1000;
        log.debug((Object)("Timeout set as: " + this.timeout));
        server.register(cd, responseMonitor, eventListener);
    }

    public SocketReceiverImpl(Socket socket, String replyto, Properties properties) {
        log.debug((Object)"create socket receiver with socket");
        this.socket = socket;
        this.replyto = replyto;
        this.data = new ArrayList<Message>();
        this.server = null;
        this.responseMonitor = null;
        this.eventListener = null;
        this.cd = Integer.parseInt(replyto.split(":")[2]);
        this.timeout = Integer.parseInt(properties.getProperty("ReceiveTimeout")) * 1000 + Integer.parseInt(properties.getProperty("TimeToLive")) * 1000;
        log.debug((Object)("Timeout set as: " + this.timeout));
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public int getCd() {
        return this.cd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long flags) throws ConnectionException {
        if (this.closed) {
            throw new ConnectionException(9, "Receiver already closed");
        }
        Message message = null;
        if ((flags & 1L) != 1L) {
            if (this.server != null) {
                message = this.server.receiveMessage(this.cd, this.determineTimeout(flags));
            } else if (this.socket != null) {
                SocketReceiverImpl socketReceiverImpl = this;
                synchronized (socketReceiverImpl) {
                    if ((flags & 1L) != 1L && this.data.isEmpty()) {
                        try {
                            this.wait(this.determineTimeout(flags));
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (!this.data.isEmpty()) {
                        message = this.data.remove(0);
                    }
                }
            }
        } else {
            log.debug((Object)"Not waiting for the response, hope its there!");
        }
        if (message == null && (flags & 1L) == 1L) {
            throw new ConnectionException(3, "Did not receive a message");
        }
        if (message == null) {
            if (JtsTransactionImple.hasTransaction()) {
                try {
                    log.debug((Object)"Marking rollbackOnly");
                    TransactionImpl.current().rollback_only();
                }
                catch (TransactionException e) {
                    throw new ConnectionException(12, "Could not mark transaction for rollback only");
                }
            }
            throw new ConnectionException(13, "Did not receive a message");
        }
        log.debug((Object)"Message was available");
        if (message.rval == 3) {
            if (TransactionImpl.current() != null) {
                try {
                    log.debug((Object)"Marking rollbackOnly as disconnection");
                    TransactionImpl.current().rollback_only();
                }
                catch (TransactionException e) {
                    throw new ConnectionException(12, "Could not mark transaction for rollback only");
                }
            }
        } else if (message.rcode == 10) {
            if (TransactionImpl.current() != null) {
                try {
                    log.debug((Object)"Marking rollbackOnly as svc err");
                    TransactionImpl.current().rollback_only();
                }
                catch (TransactionException e) {
                    throw new ConnectionException(12, "Could not mark transaction for rollback only");
                }
            }
        } else if (message.rval == 1 && TransactionImpl.current() != null) {
            try {
                TransactionImpl.current().rollback_only();
            }
            catch (TransactionException e) {
                throw new ConnectionException(12, "Could not mark transaction for rollback only");
            }
        }
        if (this.responseMonitor != null) {
            this.responseMonitor.responseReceived(this.cd, true);
        }
        return message;
    }

    public Object getReplyTo() throws ConnectionException {
        return this.replyto;
    }

    public void close() throws ConnectionException {
        if (this.server != null && this.cd != -1) {
            this.server.unregister(this.cd);
        }
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                log.warn((Object)("receiver close join socket thread failed with " + e));
            }
        }
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (SocketException e) {
            }
            catch (Exception e) {
                log.warn((Object)("receiver shutdownInput failed with " + e));
            }
        }
        this.closed = true;
    }

    public int determineTimeout(long flags) throws ConnectionException {
        if ((flags & 0x20L) == 32L) {
            return 0;
        }
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            int size;
            DataInputStream ins = new DataInputStream(this.socket.getInputStream());
            while ((size = ins.readInt()) != -1) {
                int remain;
                int n;
                log.debug((Object)("size is " + size));
                Message message = new Message();
                byte[] buf = new byte[size];
                int readn = 0;
                for (remain = size; remain > 0; remain -= n, readn += n) {
                    n = ins.read(buf, readn, remain);
                    if (n != -1) {
                        continue;
                    }
                    log.error((Object)("expect " + size + " but read " + readn));
                    break;
                }
                if (remain != 0) continue;
                String[] s = new String(buf).split("\n");
                log.debug((Object)("sid is " + s[0]));
                log.debug((Object)("cd is " + s[1]));
                message.cd = Integer.parseInt(s[1]);
                log.debug((Object)("rcode is " + s[2]));
                message.rcode = Integer.parseInt(s[2]);
                log.debug((Object)("len is " + s[3]));
                message.len = Integer.parseInt(s[3]);
                log.debug((Object)("flags is " + s[4]));
                message.flags = Integer.parseInt(s[4]);
                log.debug((Object)("rval is " + s[5]));
                message.rval = Short.parseShort(s[5]);
                log.debug((Object)("replyto is " + s[6]));
                message.replyTo = s[6].equals("(null)") ? null : s[6];
                log.debug((Object)("type is " + s[7]));
                message.type = s[7].equals("(null)") ? null : s[7];
                log.debug((Object)("subtype is " + s[8]));
                message.subtype = s[8].equals("(null)") ? null : s[8];
                message.data = new byte[message.len];
                System.arraycopy(buf, size - message.len, message.data, 0, message.len);
                log.debug((Object)("data is " + new String(message.data)));
                SocketReceiverImpl socketReceiverImpl = this;
                synchronized (socketReceiverImpl) {
                    if (this.eventListener != null) {
                        log.debug((Object)"Event listener will be called back");
                        if (message.rval == 3) {
                            this.eventListener.setLastEvent(1L, message.rcode);
                        } else if (message.rcode == 10) {
                            this.eventListener.setLastEvent(2L, message.rcode);
                        } else if (message.rval == 1) {
                            this.eventListener.setLastEvent(4L, message.rcode);
                        }
                    }
                    this.data.add(message);
                    if (this.responseMonitor != null) {
                        this.responseMonitor.responseReceived(this.cd, false);
                    }
                    this.notify();
                }
            }
            return;
        }
        catch (EOFException e) {
            log.info((Object)("receiver " + this.socket + " close"));
            this.closed = true;
            return;
        }
        catch (SocketException e) {
            return;
        }
        catch (IOException e) {
            log.error((Object)("receiver " + this.socket + " run failed with " + e));
        }
    }

    public Object getEndpoint() throws ConnectionException {
        if (this.socket != null) {
            return this.socket;
        }
        if (this.server != null && this.cd != -1) {
            return this.server.getClientSocket(this.cd);
        }
        return null;
    }
}

