/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.JtsTransactionImple;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Sender;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.Message;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.StompManagement;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StompSenderImpl
implements Sender {
    private static int counter = 0;
    private static final Logger log = LogManager.getLogger(StompSenderImpl.class);
    private boolean closed;
    private String destinationName;
    private Socket socket;
    private OutputStream outputStream;
    private InputStream inputStream;
    private Map<String, Sender> conversationalMap;
    private String serviceName;

    public StompSenderImpl(String serviceName, boolean conversational, String type, Map<String, Sender> conversationalMap, Properties properties) throws ConnectionException, IOException {
        String qtype = "/queue/";
        if (type != null) {
            qtype = "/" + type + "/";
        }
        this.destinationName = conversational ? qtype + "BTC_" + serviceName : qtype + "BTR_" + serviceName;
        String host = (String)properties.get("StompConnectHost");
        int port = Integer.parseInt((String)properties.get("StompConnectPort"));
        String username = (String)properties.get("StompConnectUsr");
        String password = (String)properties.get("StompConnectPwd");
        this.socket = StompManagement.connect(host, port, username, password);
        this.serviceName = serviceName;
        this.outputStream = this.socket.getOutputStream();
        this.inputStream = this.socket.getInputStream();
        this.conversationalMap = conversationalMap;
        log.debug((Object)("Sender Created: " + this.destinationName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void send(Object replyTo, short rval, int rcode, byte[] data, int len, int correlationId, int flags, int ttl, String type, String subtype) throws ConnectionException {
        if (this.closed) {
            throw new ConnectionException(9, "Sender closed");
        }
        if (data == null) {
            data = new byte[1];
            len = 1;
        }
        if (len < 1) {
            throw new ConnectionException(4, "Length of buffer must be greater than 0");
        }
        log.debug((Object)("Sender sending: " + this.destinationName));
        Message message = new Message();
        message.setCommand("SEND");
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            String ior = JtsTransactionImple.getTransactionIOR();
            if (ior != null) {
                headers.put("messagecontrol", ior);
                log.debug((Object)("Sender sending IOR: " + ior));
            }
        }
        catch (Exception e) {
            throw new ConnectionException(14, e.getMessage());
        }
        if (replyTo != null) {
            log.debug((Object)("Reply to: " + replyTo));
            headers.put("messagereplyto", (String)replyTo);
        }
        headers.put("servicename", this.destinationName);
        headers.put("messagecorrelationId", String.valueOf(correlationId));
        headers.put("messageflags", String.valueOf(flags));
        headers.put("messagerval", String.valueOf(rval));
        headers.put("messagercode", String.valueOf(rcode));
        headers.put("messagetype", type == null ? "" : type);
        headers.put("messagesubtype", subtype == null ? "" : subtype);
        if (ttl > 0) {
            headers.put("expires", String.valueOf(ttl));
            log.debug((Object)("EXPIRES: " + (String)headers.get("expires")));
        }
        Class<StompSenderImpl> e = StompSenderImpl.class;
        synchronized (StompSenderImpl.class) {
            Message ack;
            headers.put("receipt", "send-J-" + counter);
            log.debug((Object)("RECEIPT: " + (String)headers.get("receipt")));
            ++counter;
            // ** MonitorExit[e] (shouldn't be in output)
            headers.put("destination", this.destinationName);
            message.setHeaders(headers);
            byte[] toSend = new byte[len];
            if (data != null) {
                int min = Math.min(toSend.length, data.length);
                System.arraycopy(data, 0, toSend, 0, min);
                headers.put("content-length", String.valueOf(toSend.length));
            }
            message.setBody(toSend);
            try {
                StompManagement.send(message, this.outputStream);
                ack = StompManagement.receive(this.socket, this.inputStream);
            }
            catch (IOException e2) {
                throw new ConnectionException(7, e2.getMessage());
            }
            if (!ack.getCommand().equals("RECEIPT")) {
                log.error((Object)new String(ack.getBody()));
                throw new ConnectionException(6, new String(ack.getBody()));
            }
            log.debug((Object)"sent message");
            return;
        }
    }

    @Override
    public synchronized void close() throws ConnectionException {
        log.debug((Object)("Sender closing: " + this.destinationName));
        if (this.closed) {
            throw new ConnectionException(9, "Sender already closed");
        }
        this.closed = true;
        try {
            log.debug((Object)("closing socket: " + this.socket));
            StompManagement.close(this.socket, this.outputStream, this.inputStream);
            this.socket.close();
            log.debug((Object)("closed socket: " + this.socket));
            this.conversationalMap.remove(this.serviceName);
        }
        catch (Throwable t) {
            throw new ConnectionException(12, "Could not send the message", t);
        }
    }

    @Override
    public Object getSendTo() {
        return this.destinationName;
    }

    @Override
    public Object getEndpoint() {
        return this.socket;
    }
}

