/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid;

import AtmiBroker.EndpointQueue;
import AtmiBroker.EndpointQueueHelper;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Sender;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.omg.CORBA.Object;

public class CorbaSenderImpl
implements Sender {
    private static final Logger log = LogManager.getLogger(CorbaSenderImpl.class);
    private EndpointQueue queue;
    private String name;
    private int pad = 0;
    private boolean closed;

    CorbaSenderImpl(Object serviceFactoryObject, String name) {
        this.queue = EndpointQueueHelper.narrow((Object)serviceFactoryObject);
        this.name = name;
        log.debug((java.lang.Object)("Corba sender for: " + name + " created"));
    }

    public void send(java.lang.Object replyTo, short rval, int rcode, byte[] data, int len, int correlationId, int flags, int ttl, String type, String subtype) throws ConnectionException {
        String toReplyTo;
        log.debug((java.lang.Object)"Sending the message");
        if (this.closed) {
            log.error((java.lang.Object)"Sender closed");
            throw new ConnectionException(9, "Sender closed");
        }
        if (data == null) {
            data = new byte[1];
            len = 1;
        }
        if ((toReplyTo = (String)replyTo) == null) {
            log.trace((java.lang.Object)"Reply to set as null");
            toReplyTo = "";
        }
        if (type == null) {
            log.trace((java.lang.Object)"Type set as null");
            type = "";
        }
        if (subtype == null) {
            log.trace((java.lang.Object)"Subtype set as null");
            subtype = "";
        }
        if (len < 1) {
            log.error((java.lang.Object)"Length of buffer must be greater than 0");
            throw new ConnectionException(4, "Length of buffer must be greater than 0");
        }
        byte[] toSend = new byte[len + this.pad];
        if (data != null) {
            int min = Math.min(toSend.length, data.length);
            System.arraycopy(data, 0, toSend, 0, min);
        }
        log.debug((java.lang.Object)"Preparing to send the message");
        this.queue.send(toReplyTo, rval, rcode, toSend, toSend.length, correlationId, flags, type, subtype);
        log.debug((java.lang.Object)"Sent the message");
    }

    public void close() throws ConnectionException {
        log.debug((java.lang.Object)"Close called");
        if (this.closed) {
            throw new ConnectionException(9, "Sender already closed");
        }
        this.closed = true;
        log.debug((java.lang.Object)("Sender closed: " + this.name));
    }

    public java.lang.Object getSendTo() {
        return this.name;
    }

    public java.lang.Object getEndpoint() {
        return this.queue;
    }
}

