/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Message;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Receiver;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.StompManagement;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;

public class StompReceiverImpl
implements Receiver {
    private static final Logger log = LogManager.getLogger(StompReceiverImpl.class);
    private int timeout = 0;
    private boolean closed;
    private String destinationName;
    private Socket socket;
    private OutputStream outputStream;
    private InputStream inputStream;
    private org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.Message pendingMessage;
    private boolean ignoreSingleReceipt;

    public StompReceiverImpl(String serviceName, boolean conversational, String type, Properties properties) throws ConnectionException, IOException {
        String qtype = "/queue/";
        if (type != null) {
            qtype = "/" + type + "/";
        }
        this.destinationName = conversational ? qtype + "BTC_" + serviceName : qtype + "BTR_" + serviceName;
        String host = (String)properties.get("StompConnectHost");
        int port = Integer.parseInt((String)properties.get("StompConnectPort"));
        String username = (String)properties.get("StompConnectUsr");
        String password = (String)properties.get("StompConnectPwd");
        this.socket = StompManagement.connect(host, port, username, password);
        this.outputStream = this.socket.getOutputStream();
        this.inputStream = this.socket.getInputStream();
        org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.Message message = new org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.Message();
        message.setCommand("SUBSCRIBE");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("destination", this.destinationName);
        headers.put("receipt", this.destinationName);
        headers.put("ack", "client");
        message.setHeaders(headers);
        StompManagement.send(message, this.outputStream);
        org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.Message receive = StompManagement.receive(this.socket, this.inputStream);
        if (receive.getCommand().equals("ERROR")) {
            log.error((Object)new String(receive.getBody()));
            throw new ConnectionException(6, new String(receive.getBody()));
        }
        if (receive.getCommand().equals("MESSAGE")) {
            log.trace((Object)"Received a message rather than a receipt");
            this.pendingMessage = receive;
            this.ignoreSingleReceipt = true;
        }
        log.debug((Object)("Created a consumer on: " + this.destinationName + " with timeout: " + this.timeout));
    }

    public Object getReplyTo() throws ConnectionException {
        return null;
    }

    public Message receive(long flagsIn) throws ConnectionException {
        log.debug((Object)("Receiving from: " + this.destinationName));
        org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.Message receive = this.pendingMessage;
        this.pendingMessage = null;
        try {
            if (receive == null) {
                receive = StompManagement.receive(this.socket, this.inputStream);
                if (receive != null && receive.getCommand().equals("RECEIPT") && this.ignoreSingleReceipt) {
                    this.ignoreSingleReceipt = false;
                    receive = StompManagement.receive(this.socket, this.inputStream);
                }
                log.debug((Object)("Received from: " + this.destinationName));
            }
            if (receive == null) {
                log.debug((Object)("No message to return: " + this.destinationName));
                return null;
            }
            if (!receive.getCommand().equals("MESSAGE")) {
                throw new ConnectionException(12, "Internal error, received unexpected receipt");
            }
            Message convertFromBytesMessage = this.convertFromBytesMessage(receive);
            convertFromBytesMessage.setOutputStream(this.outputStream);
            convertFromBytesMessage.setMessageId(receive.getHeaders().get("message-id"));
            log.debug((Object)("Returning message from: " + this.destinationName));
            return convertFromBytesMessage;
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception t) {
            log.debug((Object)("Couldn't receive the message: " + t.getMessage()), (Throwable)t);
            throw new ConnectionException(12, "Couldn't receive the message", t);
        }
    }

    public void close() throws ConnectionException {
        log.debug((Object)"close");
        if (this.closed) {
            throw new ConnectionException(9, "Sender already closed");
        }
        try {
            log.debug((Object)("closing socket: " + this.socket));
            StompManagement.close(this.socket, this.outputStream, this.inputStream);
            this.inputStream.close();
            log.debug((Object)("closed input stream: " + this.inputStream));
            this.socket.close();
            log.debug((Object)("closed socket: " + this.socket));
            this.closed = true;
        }
        catch (Throwable t) {
            log.debug((Object)"consumer could not be closed");
            throw new ConnectionException(12, "Could not delete the queue", t);
        }
    }

    public Message convertFromBytesMessage(org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.Message receive) {
        log.trace((Object)"convertFromBytesMessage");
        String controlIOR = receive.getHeaders().get("messagecontrol");
        log.trace((Object)("got messagecontrol: " + controlIOR));
        String replyTo = receive.getHeaders().get("messagereplyto");
        log.trace((Object)("got messagereplyto: " + replyTo));
        int len = Integer.parseInt(receive.getHeaders().get("content-length"));
        log.trace((Object)("gotcontent-length: " + len));
        String serviceName = receive.getHeaders().get("servicename");
        log.trace((Object)("got servicename: " + serviceName));
        int flags = new Integer(receive.getHeaders().get("messageflags"));
        log.trace((Object)("got messageflags: " + flags));
        int cd = new Integer(receive.getHeaders().get("messagecorrelationId"));
        log.trace((Object)("got messagecorrelationId: " + cd));
        String type = receive.getHeaders().get("messagetype");
        log.trace((Object)("got messagetype: " + type));
        String subtype = receive.getHeaders().get("messagesubtype");
        log.trace((Object)("got messagesubtype: " + subtype));
        log.debug((Object)("type: " + type + " subtype: " + subtype));
        Message toProcess = new Message();
        toProcess.type = type;
        toProcess.subtype = subtype;
        toProcess.replyTo = replyTo;
        toProcess.serviceName = serviceName;
        toProcess.flags = flags;
        toProcess.cd = cd;
        toProcess.len = len;
        toProcess.data = (byte[])(toProcess.type == "" ? null : receive.getBody());
        toProcess.control = controlIOR;
        return toProcess;
    }

    public int determineTimeout(long flags) throws ConnectionException {
        throw new ConnectionException(9, "Tried to retrieve the cd on mom receiver");
    }

    public int getCd() throws ConnectionException {
        throw new ConnectionException(9, "Tried to retrieve the cd on mom receiver");
    }

    public Object getEndpoint() throws ConnectionException {
        return this.socket;
    }
}

