/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.xatmi.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.AttributeStructure;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.BufferStructure;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionException;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Buffer;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BufferImpl
implements Serializable,
Buffer {
    private static final long serialVersionUID = 1L;
    public static final int BYTE_SIZE = 1;
    public static final int LONG_SIZE = 8;
    public static final int INT_SIZE = 4;
    public static final int SHORT_SIZE = 2;
    public static final int FLOAT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;
    private Map<String, Object> structure = new HashMap<String, Object>();
    private String[] keys;
    private Class[] types;
    private int[] lengths;
    private boolean deserialized;
    private boolean formatted;
    int currentPos = 0;
    private List<Class> supportedTypes;
    private boolean requiresSerialization;
    private String type;
    private String subtype;
    private byte[] data;
    private int[] counts;
    private Map<String, Class> format = new HashMap<String, Class>();
    protected int len = -1;

    BufferImpl(String type, String subtype, boolean requiresSerialization, List<Class> supportedTypes) throws ConfigurationException, ConnectionException {
        this.type = type;
        this.subtype = subtype;
        this.requiresSerialization = requiresSerialization;
        this.supportedTypes = supportedTypes;
        if (requiresSerialization) {
            Properties properties = ConnectionFactory.getConnectionFactory().getProperties();
            Map buffers = (Map)properties.get("blacktie.domain.buffers");
            BufferStructure buffer = (BufferStructure)buffers.get(subtype);
            if (buffer == null) {
                throw new ConfigurationException("Subtype was not registered: " + subtype);
            }
            this.len = buffer.wireSize;
            String[] ids = new String[buffer.attributes.size()];
            Class[] types = new Class[buffer.attributes.size()];
            int[] length = new int[buffer.attributes.size()];
            int[] count = new int[buffer.attributes.size()];
            Iterator<AttributeStructure> iterator = buffer.attributes.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                AttributeStructure attribute = iterator.next();
                ids[i] = attribute.id;
                types[i] = attribute.type;
                if (!supportedTypes.contains(types[i])) {
                    throw new ConfigurationException("Cannot use type configured in buffer " + types[i]);
                }
                length[i] = attribute.length;
                count[i] = attribute.count;
                ++i;
            }
            this.format(ids, types, length, count);
        } else {
            this.len = 0;
            this.format.put("X_OCTET", byte[].class);
        }
    }

    public Map<String, Class> getFormat() {
        return this.format;
    }

    private void format(String[] keys, Class[] types, int[] lengths, int[] counts) throws ConnectionException {
        this.structure.clear();
        if (keys.length != types.length || types.length != lengths.length) {
            throw new ConnectionException(4, "Invalid format, each array description should be same length");
        }
        this.keys = keys;
        this.types = types;
        this.lengths = lengths;
        this.counts = counts;
        for (int i = 0; i < keys.length; ++i) {
            this.format.put(keys[i], types[i]);
        }
        this.formatted = true;
    }

    public void deserialize(byte[] data) throws ConnectionException {
        this.currentPos = 0;
        if (this.requiresSerialization) {
            if (!this.deserialized && data != null) {
                if (this.keys == null) {
                    throw new ConnectionException(17, "Message format not provided");
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(bais);
                for (int i = 0; i < this.types.length; ++i) {
                    if (!this.supportedTypes.contains(this.types[i])) {
                        throw new ConnectionException(17, "Cannot read type from buffer " + this.types[i]);
                    }
                    try {
                        int j;
                        Object toRead;
                        if (this.types[i] == Integer.TYPE) {
                            this.structure.put(this.keys[i], this.readInt(dis));
                            continue;
                        }
                        if (this.types[i] == Short.TYPE) {
                            this.structure.put(this.keys[i], this.readShort(dis));
                            continue;
                        }
                        if (this.types[i] == Long.TYPE) {
                            this.structure.put(this.keys[i], this.readLong(dis));
                            continue;
                        }
                        if (this.types[i] == Byte.TYPE) {
                            this.structure.put(this.keys[i], this.readByte(dis));
                            continue;
                        }
                        if (this.types[i] == Float.TYPE) {
                            this.structure.put(this.keys[i], Float.valueOf(this.readFloat(dis)));
                            continue;
                        }
                        if (this.types[i] == Double.TYPE) {
                            this.structure.put(this.keys[i], this.readDouble(dis));
                            continue;
                        }
                        if (this.types[i] == int[].class) {
                            toRead = new int[this.lengths[i]];
                            for (j = 0; j < this.lengths[i]; ++j) {
                                toRead[j] = this.readInt(dis);
                            }
                            this.structure.put(this.keys[i], toRead);
                            continue;
                        }
                        if (this.types[i] == short[].class) {
                            toRead = new short[this.lengths[i]];
                            for (j = 0; j < this.lengths[i]; ++j) {
                                toRead[j] = this.readShort(dis);
                            }
                            this.structure.put(this.keys[i], toRead);
                            continue;
                        }
                        if (this.types[i] == long[].class) {
                            toRead = new long[this.lengths[i]];
                            for (j = 0; j < this.lengths[i]; ++j) {
                                toRead[j] = (int)this.readLong(dis);
                            }
                            this.structure.put(this.keys[i], toRead);
                            continue;
                        }
                        if (this.types[i] == byte[].class) {
                            toRead = new byte[this.lengths[i]];
                            for (j = 0; j < this.lengths[i]; ++j) {
                                toRead[j] = this.readByte(dis);
                            }
                            this.structure.put(this.keys[i], toRead);
                            continue;
                        }
                        if (this.types[i] == float[].class) {
                            toRead = new float[this.lengths[i]];
                            for (j = 0; j < this.lengths[i]; ++j) {
                                toRead[j] = (int)this.readFloat(dis);
                            }
                            this.structure.put(this.keys[i], toRead);
                            continue;
                        }
                        if (this.types[i] == double[].class) {
                            toRead = new double[this.lengths[i]];
                            for (j = 0; j < this.lengths[i]; ++j) {
                                toRead[j] = (int)this.readDouble(dis);
                            }
                            this.structure.put(this.keys[i], toRead);
                            continue;
                        }
                        if (this.types[i] == byte[][].class) {
                            toRead = new byte[this.counts[i]][this.lengths[i]];
                            for (int k = 0; k < this.counts[i]; ++k) {
                                for (int j2 = 0; j2 < this.lengths[i]; ++j2) {
                                    toRead[k][j2] = this.readByte(dis);
                                }
                            }
                            this.structure.put(this.keys[i], toRead);
                            continue;
                        }
                        throw new ConnectionException(17, "Could not deserialize: " + this.types[i]);
                    }
                    catch (IOException e) {
                        throw new ConnectionException(17, "Could not parse the value as: " + this.keys[i] + " was not a " + this.types[i] + " and even if it was an array of that type its length was not: " + this.lengths[i]);
                    }
                }
            }
        } else {
            this.data = data;
            this.len = data.length;
        }
        this.deserialized = true;
    }

    public byte[] serialize() throws ConnectionException {
        this.currentPos = 0;
        byte[] toReturn = null;
        if (this.requiresSerialization) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            for (int i = 0; i < this.types.length; ++i) {
                try {
                    int j;
                    int max;
                    Object toWrite;
                    if (this.types[i] == Integer.TYPE) {
                        toWrite = (Integer)this.structure.get(this.keys[i]);
                        if (toWrite != null) {
                            this.writeInt(dos, (Integer)toWrite);
                            continue;
                        }
                        this.writeInt(dos, 0);
                        continue;
                    }
                    if (this.types[i] == Short.TYPE) {
                        toWrite = (Short)this.structure.get(this.keys[i]);
                        if (toWrite != null) {
                            this.writeShort(dos, (Short)toWrite);
                            continue;
                        }
                        this.writeShort(dos, (short)0);
                        continue;
                    }
                    if (this.types[i] == Long.TYPE) {
                        toWrite = (Long)this.structure.get(this.keys[i]);
                        if (toWrite != null) {
                            this.writeLong(dos, (Long)toWrite);
                            continue;
                        }
                        this.writeLong(dos, 0L);
                        continue;
                    }
                    if (this.types[i] == Byte.TYPE) {
                        toWrite = (Byte)this.structure.get(this.keys[i]);
                        if (toWrite != null) {
                            this.writeByte(dos, (Byte)toWrite);
                            continue;
                        }
                        this.writeByte(dos, (byte)0);
                        continue;
                    }
                    if (this.types[i] == Float.TYPE) {
                        toWrite = (Float)this.structure.get(this.keys[i]);
                        if (toWrite != null) {
                            this.writeFloat(dos, ((Float)toWrite).floatValue());
                            continue;
                        }
                        this.writeFloat(dos, 0.0f);
                        continue;
                    }
                    if (this.types[i] == Double.TYPE) {
                        toWrite = (Double)this.structure.get(this.keys[i]);
                        if (toWrite != null) {
                            this.writeDouble(dos, (Double)toWrite);
                            continue;
                        }
                        this.writeDouble(dos, 0.0);
                        continue;
                    }
                    if (this.types[i] == int[].class) {
                        toWrite = (int[])this.structure.get(this.keys[i]);
                        max = 0;
                        if (toWrite != null) {
                            max = Math.min(this.lengths[i], ((Object)toWrite).length);
                            for (j = 0; j < this.lengths[i]; ++j) {
                                this.writeInt(dos, (int)toWrite[j]);
                            }
                        }
                        for (j = max; j < this.lengths[i]; ++j) {
                            this.writeInt(dos, 0);
                        }
                        continue;
                    }
                    if (this.types[i] == short[].class) {
                        toWrite = (short[])this.structure.get(this.keys[i]);
                        max = 0;
                        if (toWrite != null) {
                            max = Math.min(this.lengths[i], ((Object)toWrite).length);
                            for (j = 0; j < this.lengths[i]; ++j) {
                                this.writeShort(dos, (short)toWrite[j]);
                            }
                        }
                        for (j = max; j < this.lengths[i]; ++j) {
                            this.writeShort(dos, (short)0);
                        }
                        continue;
                    }
                    if (this.types[i] == long[].class) {
                        toWrite = (long[])this.structure.get(this.keys[i]);
                        max = 0;
                        if (toWrite != null) {
                            max = Math.min(this.lengths[i], ((Object)toWrite).length);
                            for (j = 0; j < this.lengths[i]; ++j) {
                                this.writeLong(dos, (long)toWrite[j]);
                            }
                        }
                        for (j = max; j < this.lengths[i]; ++j) {
                            this.writeLong(dos, 0L);
                        }
                        continue;
                    }
                    if (this.types[i] == byte[].class) {
                        toWrite = (byte[])this.structure.get(this.keys[i]);
                        max = 0;
                        if (toWrite != null) {
                            max = Math.min(this.lengths[i], ((Object)toWrite).length);
                            for (j = 0; j < max; ++j) {
                                this.writeByte(dos, (byte)toWrite[j]);
                            }
                        }
                        for (j = max; j < this.lengths[i]; ++j) {
                            this.writeByte(dos, (byte)0);
                        }
                        continue;
                    }
                    if (this.types[i] == float[].class) {
                        toWrite = (float[])this.structure.get(this.keys[i]);
                        max = 0;
                        if (toWrite != null) {
                            max = Math.min(this.lengths[i], ((Object)toWrite).length);
                            for (j = 0; j < this.lengths[i]; ++j) {
                                this.writeFloat(dos, (float)toWrite[j]);
                            }
                        }
                        for (j = max; j < this.lengths[i]; ++j) {
                            this.writeFloat(dos, 0.0f);
                        }
                        continue;
                    }
                    if (this.types[i] == double[].class) {
                        toWrite = (double[])this.structure.get(this.keys[i]);
                        max = 0;
                        if (toWrite != null) {
                            max = Math.min(this.lengths[i], ((Object)toWrite).length);
                            for (j = 0; j < this.lengths[i]; ++j) {
                                this.writeDouble(dos, (double)toWrite[j]);
                            }
                        }
                        for (j = max; j < this.lengths[i]; ++j) {
                            this.writeDouble(dos, 0.0);
                        }
                        continue;
                    }
                    if (this.types[i] == byte[][].class) {
                        toWrite = (byte[][])this.structure.get(this.keys[i]);
                        if (toWrite != null) {
                            for (int k = 0; k < this.counts[i]; ++k) {
                                for (j = 0; j < this.lengths[i]; ++j) {
                                    this.writeByte(dos, (byte)toWrite[k][j]);
                                }
                            }
                            continue;
                        }
                        for (int j2 = 0; j2 < this.counts[i] * this.lengths[i]; ++j2) {
                            this.writeByte(dos, (byte)0);
                        }
                        continue;
                    }
                    if (TransactionImpl.current() != null) {
                        try {
                            TransactionImpl.current().rollback_only();
                        }
                        catch (TransactionException e) {
                            throw new ConnectionException(12, "Could not mark transaction for rollback only");
                        }
                    }
                    throw new ConnectionException(18, "Could not serialize: " + this.types[i]);
                }
                catch (IOException e) {
                    throw new ConnectionException(18, "Could not parse the value as: " + this.keys[i] + " was not a " + this.types[i] + " and even if it was an array of that type its length was not: " + this.lengths[i]);
                }
            }
            toReturn = baos.toByteArray();
        } else {
            toReturn = this.getRawData();
        }
        if (toReturn == null) {
            toReturn = new byte[1];
        }
        return toReturn;
    }

    private void writeByte(DataOutputStream dos, byte b) throws IOException {
        dos.writeByte(b);
        ++this.currentPos;
    }

    private byte readByte(DataInputStream dis) throws IOException {
        ++this.currentPos;
        byte x = dis.readByte();
        ByteBuffer bbuf = ByteBuffer.allocate(1);
        bbuf.put(x);
        return bbuf.get(0);
    }

    private void writeLong(DataOutputStream dos, long x) throws IOException {
        ByteBuffer bbuf = ByteBuffer.allocate(8);
        bbuf.putLong(x);
        byte[] data = new byte[8];
        Arrays.fill(data, (byte)0);
        System.arraycopy(bbuf.array(), 4, data, 0, 4);
        dos.write(data);
        this.currentPos += 8;
    }

    private long readLong(DataInputStream dis) throws IOException {
        this.currentPos += 8;
        ByteBuffer bbuf = ByteBuffer.allocate(8);
        byte[] data = new byte[8];
        Arrays.fill(data, (byte)0);
        dis.read(data, 4, 4);
        bbuf.put(data);
        long x = bbuf.getLong(0);
        dis.read(data, 0, 4);
        return x;
    }

    private void writeInt(DataOutputStream dos, int x) throws IOException {
        ByteBuffer bbuf = ByteBuffer.allocate(4);
        bbuf.putInt(x);
        int toWrite = bbuf.getInt(0);
        dos.writeInt(toWrite);
        this.currentPos += 4;
    }

    private int readInt(DataInputStream dis) throws IOException {
        this.currentPos += 4;
        int x = dis.readInt();
        ByteBuffer bbuf = ByteBuffer.allocate(4);
        bbuf.putInt(x);
        return bbuf.getInt(0);
    }

    private void writeShort(DataOutputStream dos, short x) throws IOException {
        ByteBuffer bbuf = ByteBuffer.allocate(2);
        bbuf.putShort(x);
        short toWrite = bbuf.getShort(0);
        dos.writeShort(toWrite);
        this.currentPos += 2;
    }

    private short readShort(DataInputStream dis) throws IOException {
        this.currentPos += 2;
        short x = dis.readShort();
        ByteBuffer bbuf = ByteBuffer.allocate(2);
        bbuf.putShort(x);
        return bbuf.getShort(0);
    }

    private void writeFloat(DataOutputStream dos, float x) throws IOException {
        ByteBuffer bbuf = ByteBuffer.allocate(4);
        bbuf.putFloat(x);
        float toWrite = bbuf.getFloat(0);
        dos.writeFloat(toWrite);
        this.currentPos += 4;
    }

    private float readFloat(DataInputStream dis) throws IOException {
        this.currentPos += 4;
        float x = dis.readFloat();
        ByteBuffer bbuf = ByteBuffer.allocate(4);
        bbuf.putFloat(x);
        return bbuf.getFloat(0);
    }

    private void writeDouble(DataOutputStream dos, double x) throws IOException {
        ByteBuffer bbuf = ByteBuffer.allocate(8);
        bbuf.putDouble(x);
        double toWrite = bbuf.getDouble(0);
        dos.writeDouble(toWrite);
        this.currentPos += 8;
    }

    private double readDouble(DataInputStream dis) throws IOException {
        this.currentPos += 8;
        double x = dis.readDouble();
        ByteBuffer bbuf = ByteBuffer.allocate(8);
        bbuf.putDouble(x);
        return bbuf.getDouble(0);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getSubtype() {
        return this.subtype;
    }

    public void clear() {
        this.structure.clear();
        this.data = null;
    }

    protected Object getAttributeValue(String key, Class type) throws ConnectionException {
        if (!this.formatted) {
            throw new ConnectionException(9, "Message not formatted");
        }
        int position = -1;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            position = i;
        }
        if (position == -1) {
            throw new ConnectionException(17, "Key is not part of the structure: " + key);
        }
        if (this.types[position] != type) {
            throw new ConnectionException(17, "Key is not request type, it is a: " + this.types[position]);
        }
        return this.structure.get(key);
    }

    protected void setAttributeValue(String key, Class type, Object value) throws ConnectionException {
        if (!this.formatted) {
            throw new ConnectionException(9, "Message not formatted");
        }
        int position = -1;
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(key)) continue;
            position = i;
        }
        if (position == -1) {
            throw new ConnectionException(17, "Key is not part of the structure: " + key);
        }
        if (this.types[position] != type) {
            throw new ConnectionException(17, "Key is not request type, it is a: " + this.types[position]);
        }
        this.structure.put(key, value);
    }

    protected void setRawData(byte[] bytes) {
        this.data = bytes;
    }

    protected byte[] getRawData() {
        return this.data;
    }

    @Override
    public int getLen() {
        return this.len;
    }
}

