/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid;

import java.net.Socket;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.ResponseMonitor;
import org.jboss.narayana.blacktie.jatmibroker.core.server.SocketServer;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.EventListener;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.OrbManagement;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Receiver;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Sender;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Transport;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.TransportFactory;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.SocketReceiverImpl;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.SocketSenderImpl;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.StompReceiverImpl;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.StompSenderImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;

public class TransportImpl
implements Transport {
    private static final Logger log = LogManager.getLogger(TransportImpl.class);
    private OrbManagement orbManagement;
    private SocketServer socketserver;
    private Properties properties;
    private TransportFactory transportFactoryImpl;
    private boolean closed;
    private Map<Boolean, Map<String, Sender>> senders = new HashMap<Boolean, Map<String, Sender>>();
    private Map<Boolean, Map<String, Receiver>> receivers = new HashMap<Boolean, Map<String, Receiver>>();

    public TransportImpl(OrbManagement orbManagement, SocketServer socketserver, Properties properties, TransportFactory transportFactoryImpl) {
        log.debug((Object)"Creating transport");
        this.orbManagement = orbManagement;
        this.socketserver = socketserver;
        this.properties = properties;
        this.transportFactoryImpl = transportFactoryImpl;
        log.debug((Object)"Created transport");
    }

    @Override
    public void close() throws ConnectionException {
        log.debug((Object)("Close called: " + this));
        if (!this.closed) {
            Iterator<Object> iterator2;
            Collection<Object> next;
            Collection<Map<String, Object>> values = this.senders.values();
            Iterator<Map<String, Object>> iterator = values.iterator();
            while (iterator.hasNext()) {
                next = iterator.next().values();
                iterator2 = next.iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().close();
                }
            }
            values = this.receivers.values();
            iterator = values.iterator();
            while (iterator.hasNext()) {
                next = iterator.next().values();
                iterator2 = next.iterator();
                while (iterator2.hasNext()) {
                    ((Receiver)iterator2.next()).close();
                }
            }
            this.transportFactoryImpl.removeTransport(this);
            this.closed = true;
        }
        log.debug((Object)("Closed: " + this));
    }

    @Override
    public Sender getSender(String serviceName, boolean conversational) throws ConnectionException {
        Sender toReturn;
        if (this.closed) {
            log.error((Object)"Already closed");
            throw new ConnectionException(9, "Already closed");
        }
        log.debug((Object)("Get sender: " + serviceName));
        Map<String, Sender> conversationalMap = this.senders.get(conversational);
        if (conversationalMap == null) {
            conversationalMap = new HashMap<String, Sender>();
            this.senders.put(conversational, conversationalMap);
        }
        if ((toReturn = conversationalMap.get(serviceName)) == null) {
            try {
                String type = (String)this.properties.get("blacktie." + serviceName + ".type");
                toReturn = new StompSenderImpl(serviceName, conversational, type, conversationalMap, this.properties);
                conversationalMap.put(serviceName, toReturn);
            }
            catch (ConnectionException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ConnectionException(12, "Could not create a service sender: " + t.getMessage(), t);
            }
        }
        return toReturn;
    }

    @Override
    public Sender createSender(Object destination) throws ConnectionException {
        if (this.closed) {
            log.error((Object)"Already closed");
            throw new ConnectionException(9, "Already closed");
        }
        String callback_ior = (String)destination;
        log.debug((Object)("Creating a sender for: " + callback_ior));
        if (callback_ior.contains("IOR:")) {
            log.debug((Object)(callback_ior + " is for corba"));
            throw new ConnectionException(12, "Could not create a Corba sender");
        }
        log.debug((Object)(callback_ior + " is for socket"));
        SocketSenderImpl sender = new SocketSenderImpl(callback_ior);
        log.debug((Object)"Created sender");
        return sender;
    }

    @Override
    public Sender createSender(Receiver receiver) throws ConnectionException {
        return new SocketSenderImpl((Socket)receiver.getEndpoint(), (String)receiver.getReplyTo());
    }

    @Override
    public Receiver getReceiver(String serviceName, boolean conversational) throws ConnectionException {
        Receiver toReturn;
        if (this.closed) {
            log.error((Object)"Already closed");
            throw new ConnectionException(9, "Already closed");
        }
        log.debug((Object)("Creating a receiver: " + serviceName));
        Map<String, Receiver> conversationalMap = this.receivers.get(conversational);
        if (conversationalMap == null) {
            conversationalMap = new HashMap<String, Receiver>();
            this.receivers.put(conversational, conversationalMap);
        }
        if ((toReturn = conversationalMap.get(serviceName)) == null) {
            try {
                log.debug((Object)"Resolved destination");
                String type = (String)this.properties.get("blacktie." + serviceName + ".type");
                return new StompReceiverImpl(serviceName, conversational, type, this.properties);
            }
            catch (ConnectionException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ConnectionException(12, "Could not create the receiver on: " + serviceName, t);
            }
        }
        return toReturn;
    }

    @Override
    public Receiver createReceiver(int cd, ResponseMonitor responseMonitor, EventListener eventListener) throws ConnectionException {
        if (this.closed) {
            log.error((Object)"Already closed");
            throw new ConnectionException(9, "Already closed");
        }
        log.debug((Object)"Creating a receiver");
        return new SocketReceiverImpl(this.socketserver, this.properties, cd, responseMonitor, eventListener);
    }

    @Override
    public Receiver createReceiver(EventListener eventListener) throws ConnectionException {
        if (this.closed) {
            log.error((Object)"Already closed");
            throw new ConnectionException(9, "Already closed");
        }
        return null;
    }

    @Override
    public Receiver createReceiver(Sender sender) throws ConnectionException {
        if (sender == null) {
            log.debug((Object)"no need to create on empty sender");
            return null;
        }
        return new SocketReceiverImpl((Socket)sender.getEndpoint(), (String)sender.getSendTo(), this.properties);
    }
}

