/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.server;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.ResponseMonitor;
import org.jboss.narayana.blacktie.jatmibroker.core.server.ClientContext;
import org.jboss.narayana.blacktie.jatmibroker.core.server.SocketServer;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.EventListener;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Message;

class Client
implements Runnable {
    private static final Logger log = LogManager.getLogger(Client.class);
    private Socket socket;
    private int sid = -1;
    private boolean isClose;
    private SocketServer server;

    public Client(SocketServer server, Socket socket) {
        this.socket = socket;
        this.isClose = false;
        this.server = server;
    }

    public boolean isClose() {
        return this.isClose;
    }

    public int getSid() {
        return this.sid;
    }

    public void close() {
        if (!this.isClose && this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int size;
            DataInputStream ins = new DataInputStream(this.socket.getInputStream());
            while ((size = ins.readInt()) != -1) {
                log.debug("size is " + size);
                Message message = new Message();
                byte[] buf = new byte[size];
                int readn = 0;
                int remain = size;
                while (remain > 0) {
                    int n = ins.read(buf, readn, remain);
                    if (n != -1) {
                        remain -= n;
                        readn += n;
                        continue;
                    }
                    log.error("expect " + size + " but read " + readn);
                    break;
                }
                if (remain != 0) continue;
                log.debug("receive from " + this.socket + " and size is " + size + " buffer is " + buf);
                String[] s = new String(buf).split("\n");
                log.debug("sid is " + s[0]);
                this.sid = Integer.parseInt(s[0]);
                log.debug("cd is " + s[1]);
                message.cd = Integer.parseInt(s[1]);
                log.debug("rcode is " + s[2]);
                message.rcode = Integer.parseInt(s[2]);
                log.debug("len is " + s[3]);
                message.len = Integer.parseInt(s[3]);
                log.debug("flags is " + s[4]);
                message.flags = Integer.parseInt(s[4]);
                log.debug("rval is " + s[5]);
                message.rval = Short.parseShort(s[5]);
                log.debug("replyto is " + s[6]);
                message.replyTo = s[6].equals("(null)") ? null : s[6];
                log.debug("type is " + s[7]);
                message.type = s[7].equals("(null)") ? null : s[7];
                log.debug("subtype is " + s[8]);
                message.subtype = s[8].equals("(null)") ? null : s[8];
                message.data = new byte[message.len];
                System.arraycopy(buf, size - message.len, message.data, 0, message.len);
                log.debug("data is " + new String(message.data));
                ClientContext context = this.server.getContext(this.sid);
                if (context == null) continue;
                ClientContext clientContext = context;
                synchronized (clientContext) {
                    EventListener eventListener = context.getEventListener();
                    if (eventListener != null) {
                        log.debug("Event listener will be called back");
                        if (message.rval == 3) {
                            eventListener.setLastEvent(1L, message.rcode);
                        } else if (message.rcode == 10) {
                            eventListener.setLastEvent(2L, message.rcode);
                        } else if (message.rval == 1) {
                            eventListener.setLastEvent(4L, message.rcode);
                        }
                    }
                    context.getData().add(message);
                    log.debug("add message to context " + context.getSid());
                    context.setSocket(this.socket);
                    ResponseMonitor responseMonitor = context.getResponseMonitor();
                    if (responseMonitor != null) {
                        responseMonitor.responseReceived(this.sid, false);
                    }
                    log.debug("notifying");
                    context.notify();
                    log.debug("notified");
                }
            }
            this.socket.shutdownInput();
            this.isClose = true;
        }
        catch (EOFException e) {
            log.debug("client " + this.socket + " close");
            this.isClose = true;
        }
        catch (SocketException e) {
            this.isClose = true;
        }
        catch (IOException e) {
            log.error("client " + this.socket + " run failed with " + e);
        }
    }
}

