/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.server.SocketServer;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Transport;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.TransportImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;

public class TransportFactory {
    private static final Logger log = LogManager.getLogger(TransportFactory.class);
    private Properties properties;
    private SocketServer socketserver;
    private List<Transport> transports = new ArrayList<Transport>();
    private boolean closed;

    public TransportFactory(Properties properties) throws ConfigurationException {
        log.debug("Creating Transportfactory: " + this);
        this.properties = properties;
        try {
            this.socketserver = SocketServer.getInstance(properties);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not create socket server", e);
        }
        log.debug("Created SocketServer");
    }

    public synchronized Transport createTransport() {
        log.debug("Creating transport from factory: " + this);
        TransportImpl instance = new TransportImpl(this.socketserver, this.properties, this);
        this.transports.add(instance);
        log.debug("Created transport from factory: " + this + " transport: " + instance);
        return instance;
    }

    public void removeTransport(TransportImpl transportImpl) {
        boolean remove = this.transports.remove(transportImpl);
        log.debug("Transport was removed: " + transportImpl + " from: " + this + " result: " + remove);
    }

    public final synchronized void close() {
        log.debug("Close called: " + this);
        if (!this.closed) {
            log.debug("Going into shutdown");
            log.debug("Closing factory: " + this);
            Transport[] transport = new Transport[this.transports.size()];
            transport = this.transports.toArray(transport);
            for (int i = 0; i < transport.length; ++i) {
                try {
                    log.debug("Closing transport: " + transport[i] + " from factory: " + this);
                    transport[i].close();
                    continue;
                }
                catch (ConnectionException e) {
                    log.warn("Transport could not be closed: " + e.getMessage(), (Throwable)e);
                }
            }
            this.transports.clear();
            this.closed = true;
        }
        if (this.socketserver != null) {
            SocketServer.discardInstance();
        }
        log.debug("Closed factory: " + this.getClass().getName());
    }
}

