/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.tx;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.AtmiBrokerEnvXML;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.OrbManagement;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.ThreadActionData;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.ThreadUtil;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionException;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TransactionFactory;
import org.omg.CosTransactions.TransactionFactoryHelper;
import org.omg.CosTransactions.Unavailable;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;

public class TransactionImpl {
    private static final Logger log = LogManager.getLogger(TransactionImpl.class);
    static TransactionFactory transactionFactory;
    private int timeout;
    protected Control control;
    private Terminator terminator;
    private Hashtable _childThreads;
    private boolean active = true;
    private OrbManagement orbManagement;

    public void finalize() throws Throwable {
        ThreadActionData.popAction();
        super.finalize();
    }

    public TransactionImpl(int aTimeout) throws TransactionException, NotFound, CannotProceed, InvalidName, org.omg.CORBA.ORBPackage.InvalidName, AdapterInactive, ConfigurationException {
        log.debug("TransactionImpl constructor");
        if (TransactionImpl.current() != null) {
            throw new TransactionException("Nested transactions are not supported");
        }
        this.timeout = aTimeout;
        this.control = null;
        this.terminator = null;
        try {
            AtmiBrokerEnvXML client = new AtmiBrokerEnvXML();
            Properties properties = client.getProperties();
            this.orbManagement = OrbManagement.getInstance(properties);
            String toLookup = (String)properties.get("blacktie.trans.factoryid");
            Object aObject = this.orbManagement.getNamingContextExt().resolve_str(toLookup);
            transactionFactory = TransactionFactoryHelper.narrow((Object)aObject);
        }
        catch (UserException cue) {
            throw new TransactionException(cue.getMessage(), cue);
        }
        log.debug(" creating Control");
        this.control = transactionFactory.create(this.timeout);
        ThreadActionData.pushAction(this);
        log.debug(" created Control " + this.control);
        this.setTerminator(this.control);
    }

    public TransactionImpl(String controlIOR) throws ConfigurationException, TransactionException {
        TransactionImpl curr = TransactionImpl.current();
        this.timeout = -1;
        try {
            AtmiBrokerEnvXML client = new AtmiBrokerEnvXML();
            Properties properties = client.getProperties();
            this.orbManagement = OrbManagement.getInstance(properties);
        }
        catch (UserException cue) {
            throw new TransactionException(cue.getMessage(), cue);
        }
        Object obj = this.orbManagement.getOrb().string_to_object(controlIOR);
        if (curr != null) {
            log.debug("current() != null comparing IORs");
            String pIOR = curr.getControlIOR();
            Object pObj = this.orbManagement.getOrb().string_to_object(pIOR);
            log.debug("pIOR=" + pIOR + " pObj=" + pObj);
            if (pObj != null && pObj._is_equivalent(obj)) {
                log.debug("Different IORs same object");
                ThreadActionData.popAction();
            } else {
                log.info("Different IORs and different object");
                throw new TransactionException("Nested transactions are not supported");
            }
        }
        this.control = ControlHelper.narrow((Object)obj);
        ThreadActionData.pushAction(this);
        this.setTerminator(this.control);
    }

    public Status getStatus() throws Unavailable {
        return this.control.get_coordinator().get_status();
    }

    public boolean equals(java.lang.Object obj) {
        if (obj instanceof TransactionImpl) {
            TransactionImpl other = (TransactionImpl)obj;
            return this.control.equals(other.control);
        }
        return false;
    }

    private void setTerminator(Control c) throws TransactionException {
        try {
            this.terminator = this.control.get_terminator();
            log.debug("Terminator is " + this.terminator);
        }
        catch (Unavailable e) {
            throw new TransactionException("Could not get the terminator", e);
        }
    }

    public String getControlIOR() {
        return this.orbManagement.getOrb().object_to_string((Object)this.control);
    }

    public static TransactionImpl current() {
        log.trace("Getting current");
        return ThreadActionData.currentAction();
    }

    public Control getControl() {
        log.debug("TransactionImpl getControl");
        return this.control;
    }

    public void commit() throws TransactionException {
        log.debug("TransactionImpl commit");
        try {
            log.debug("calling commit");
            this.terminator.commit(true);
            this.active = false;
            ThreadActionData.popAction();
            log.debug("called commit on terminator");
        }
        catch (Exception e) {
            this.active = false;
            ThreadActionData.popAction();
            throw new TransactionException("Could not commit the transaction: " + e.getMessage(), e);
        }
    }

    public void rollback() throws TransactionException {
        log.debug("TransactionImpl rollback");
        try {
            this.terminator.rollback();
            this.active = false;
            ThreadActionData.popAction();
            log.debug("called rollback on terminator");
        }
        catch (Exception e) {
            this.active = false;
            ThreadActionData.popAction();
            throw new TransactionException("Could not rollback the transaction: " + e.getMessage(), e);
        }
    }

    public void rollback_only() throws TransactionException {
        log.debug("TransactionImpl rollback_only");
        try {
            this.control.get_coordinator().rollback_only();
            log.debug("tx marked rollback only");
        }
        catch (Unavailable e) {
            throw new TransactionException("Tx Manager unavailable for set rollback only", e);
        }
        catch (Exception e) {
            throw new TransactionException("Error setting rollback only", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addChildThread(Thread t) {
        if (t == null) {
            return false;
        }
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this.active) {
                if (this._childThreads == null) {
                    this._childThreads = new Hashtable();
                }
                return true;
            }
        }
        return false;
    }

    public final boolean removeChildThread() {
        return this.removeChildThread(ThreadUtil.getThreadId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeChildThread(String threadId) {
        if (threadId == null) {
            return false;
        }
        TransactionImpl transactionImpl = this;
        synchronized (transactionImpl) {
            if (this._childThreads != null) {
                this._childThreads.remove(threadId);
                return true;
            }
        }
        return false;
    }

    public final TransactionImpl parent() {
        return null;
    }

    public static final TransactionImpl suspend() {
        TransactionImpl curr = ThreadActionData.currentAction();
        if (curr != null) {
            ThreadActionData.purgeActions();
        }
        return curr;
    }

    public static final boolean resume(TransactionImpl act) {
        if (act == null) {
            TransactionImpl.suspend();
        } else {
            ThreadActionData.restoreActions(act);
        }
        return true;
    }
}

