/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.xatmi;

import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.AtmiBrokerEnvXML;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Connection;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.ConnectionImpl;

public class ConnectionFactory {
    private static final Logger log = LogManager.getLogger(ConnectionFactory.class);
    private Properties properties = new Properties();
    private static ThreadLocal<ConnectionImpl> connections = new ThreadLocal();

    public static synchronized ConnectionFactory getConnectionFactory() throws ConfigurationException {
        return new ConnectionFactory();
    }

    private ConnectionFactory() throws ConfigurationException {
        log.debug("Creating connection factory: " + this);
        AtmiBrokerEnvXML xml = new AtmiBrokerEnvXML();
        this.properties.putAll((Map<?, ?>)xml.getProperties());
        log.debug("Created connection factory: " + this);
    }

    public Connection getConnection() throws ConfigurationException {
        ConnectionImpl connection = connections.get();
        if (connection == null) {
            connection = new ConnectionImpl(this, this.properties);
            connections.set(connection);
            log.debug("Returning connection: " + connection);
        }
        return connection;
    }

    public void removeConnection(ConnectionImpl connection) {
        connections.set(null);
    }

    public Properties getProperties() {
        return this.properties;
    }
}

