/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.conf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.AttributeStructure;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.BufferStructure;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.Machine;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.Server;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLEnvHandler
extends DefaultHandler {
    private static final Logger log = LogManager.getLogger(XMLEnvHandler.class);
    private static final String envVarPatStr = "(.*)\\$\\{(.*)\\}(.*)";
    private static Pattern pattern;
    private final String DOMAIN = "DOMAIN";
    private final String BUFFER = "BUFFER";
    private final String ATTRIBUTE = "ATTRIBUTE";
    private final String SERVER_NAME = "SERVER";
    private final String SERVICE_NAME = "SERVICE";
    private final String ORB = "ORB";
    private final String MQ = "MQ";
    private final String SOCKETSERVER = "SOCKETSERVER";
    private final String MACHINE = "MACHINE";
    private final String MACHINE_REF = "MACHINE-REF";
    private Properties prop;
    private String value;
    private String serverName;
    private String serviceName;
    private List<String> servers = new ArrayList<String>();
    private Map<String, BufferStructure> buffers = new HashMap<String, BufferStructure>();
    private Map<String, Machine> machines = new HashMap<String, Machine>();
    private List<Server> serverLaunchers = new ArrayList<Server>();
    private String currentBufferName;
    static int CHAR_SIZE;
    static int LONG_SIZE;
    static int INT_SIZE;
    static int SHORT_SIZE;
    static int FLOAT_SIZE;
    static int DOUBLE_SIZE;

    XMLEnvHandler(Properties prop) {
        this.prop = prop;
        prop.put("blacktie.domain.servers", this.servers);
        prop.put("blacktie.domain.buffers", this.buffers);
        prop.put("blacktie.domain.serverLaunchers", this.serverLaunchers);
        prop.setProperty("blacktie.domain.version", "5.11.2.Final");
        if (pattern == null) {
            pattern = Pattern.compile(envVarPatStr);
        }
    }

    public XMLEnvHandler() {
        this(new Properties());
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String strValue = new String(ch, start, length);
        this.value = this.value + strValue;
    }

    public String getenv(CharSequence inputStr) {
        String[] matches = new String[3];
        matches[0] = "";
        matches[2] = "";
        Matcher matcher = pattern.matcher(inputStr);
        if (matcher.find()) {
            int i;
            StringBuilder sb = new StringBuilder();
            boolean expanded = false;
            for (i = 0; i < matcher.groupCount(); ++i) {
                String val;
                if (i >= matches.length || (val = matcher.group(i + 1)) == null || val.length() <= 0) continue;
                String env = System.getenv(val);
                if (env == null) {
                    env = System.getProperty(val);
                }
                if (env == null) {
                    if (val.equals("jboss.bind.address.management")) {
                        env = "localhost";
                    }
                    matches[i] = val;
                    continue;
                }
                matches[i] = env;
                expanded = true;
            }
            if (!expanded) {
                log.error("There is an unset environment variable within the configuration element/attribute: " + inputStr);
            }
            for (i = 0; i < matches.length; ++i) {
                sb.append(matches[i]);
            }
            return sb.toString();
        }
        return inputStr.toString();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.value = "";
        if ("SERVER".equals(localName)) {
            this.serverName = atts.getValue(0);
            if (this.servers.contains(this.serverName)) {
                throw new SAXException("Duplicate server detected: " + this.serverName);
            }
            this.servers.add(this.serverName);
            this.serverLaunchers.add(new Server(this.serverName));
        } else if ("MACHINE-REF".equals(localName)) {
            Machine machine = null;
            String avalue = this.getenv(atts.getValue(0));
            machine = this.machines.get(avalue);
            if (machine == null) {
                throw new SAXException("Machine did not exist: " + avalue);
            }
            Server server = this.serverLaunchers.get(this.serverLaunchers.size() - 1);
            server.addMachine(machine);
            String ad_key = "blacktie.." + server.getName() + machine.getId() + ".conversational";
            this.prop.put(ad_key, (Object)false);
        } else if ("BUFFER".equals(localName)) {
            this.currentBufferName = atts.getValue(0);
            BufferStructure buffer = this.buffers.get(this.currentBufferName);
            if (buffer != null) {
                throw new SAXException("Duplicate buffer detected: " + this.currentBufferName);
            }
            buffer = new BufferStructure();
            buffer.name = this.currentBufferName;
            buffer.wireSize = 0;
            buffer.memSize = 0L;
            buffer.lastPad = 0;
            this.buffers.put(this.currentBufferName, buffer);
        } else if ("ATTRIBUTE".equals(localName)) {
            BufferStructure buffer = this.buffers.get(this.currentBufferName);
            AttributeStructure attribute = new AttributeStructure();
            attribute.id = null;
            attribute.type = null;
            attribute.count = 0;
            attribute.length = 0;
            attribute.wirePosition = 0L;
            attribute.memPosition = 0L;
            String type = null;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getLocalName(i).equals("id")) {
                    attribute.id = atts.getValue(i);
                    continue;
                }
                if (atts.getLocalName(i).equals("type")) {
                    type = atts.getValue(i);
                    continue;
                }
                if (atts.getLocalName(i).equals("arrayCount")) {
                    attribute.count = Integer.parseInt(atts.getValue(i));
                    continue;
                }
                if (!atts.getLocalName(i).equals("arrayLength")) continue;
                attribute.length = Integer.parseInt(atts.getValue(i));
            }
            int typeSize = -1;
            boolean contains = buffer.attributeNames.contains(attribute.id);
            boolean fail = false;
            if (!contains) {
                if (type.equals("short")) {
                    typeSize = SHORT_SIZE;
                    attribute.instanceSize = SHORT_SIZE;
                    attribute.type = Short.TYPE;
                } else if (type.equals("int")) {
                    typeSize = INT_SIZE;
                    attribute.instanceSize = INT_SIZE;
                    attribute.type = Integer.TYPE;
                } else if (type.equals("long")) {
                    typeSize = LONG_SIZE;
                    attribute.instanceSize = LONG_SIZE;
                    attribute.type = Long.TYPE;
                } else if (type.equals("float")) {
                    typeSize = FLOAT_SIZE;
                    attribute.instanceSize = FLOAT_SIZE;
                    attribute.type = Float.TYPE;
                } else if (type.equals("double")) {
                    typeSize = DOUBLE_SIZE;
                    attribute.instanceSize = DOUBLE_SIZE;
                    attribute.type = Double.TYPE;
                } else if (type.equals("char")) {
                    typeSize = CHAR_SIZE;
                    attribute.instanceSize = CHAR_SIZE;
                    attribute.type = Byte.TYPE;
                } else if (type.equals("char[]")) {
                    if (attribute.length == 0) {
                        attribute.length = 1;
                    }
                    typeSize = CHAR_SIZE;
                    attribute.instanceSize = CHAR_SIZE * attribute.length;
                    attribute.type = byte[].class;
                } else if (type.equals("short[]")) {
                    if (attribute.length == 0) {
                        attribute.length = 1;
                    }
                    typeSize = SHORT_SIZE;
                    attribute.instanceSize = SHORT_SIZE * attribute.length;
                    attribute.type = short[].class;
                } else if (type.equals("int[]")) {
                    if (attribute.length == 0) {
                        attribute.length = 1;
                    }
                    typeSize = INT_SIZE;
                    attribute.instanceSize = INT_SIZE * attribute.length;
                    attribute.type = int[].class;
                } else if (type.equals("long[]")) {
                    if (attribute.length == 0) {
                        attribute.length = 1;
                    }
                    typeSize = LONG_SIZE;
                    attribute.instanceSize = LONG_SIZE * attribute.length;
                    attribute.type = long[].class;
                } else if (type.equals("float[]")) {
                    if (attribute.length == 0) {
                        attribute.length = 1;
                    }
                    typeSize = FLOAT_SIZE;
                    attribute.instanceSize = FLOAT_SIZE * attribute.length;
                    attribute.type = float[].class;
                } else if (type.equals("double[]")) {
                    if (attribute.length == 0) {
                        attribute.length = 1;
                    }
                    typeSize = DOUBLE_SIZE;
                    attribute.instanceSize = DOUBLE_SIZE * attribute.length;
                    attribute.type = double[].class;
                } else if (type.equals("char[][]")) {
                    if (attribute.length == 0) {
                        attribute.length = 1;
                    }
                    if (attribute.count == 0) {
                        attribute.count = 1;
                    }
                    typeSize = CHAR_SIZE;
                    attribute.instanceSize = CHAR_SIZE * attribute.length * attribute.count;
                    attribute.type = byte[][].class;
                } else {
                    log.error("Unknown attribute type: " + attribute.type);
                    fail = true;
                }
                if (!fail) {
                    buffer.attributes.add(attribute);
                    if (buffer.lastPad < typeSize) {
                        buffer.lastPad = typeSize;
                    }
                    buffer.memSize += buffer.memSize % (long)typeSize;
                    attribute.memPosition = buffer.memSize;
                    attribute.wirePosition = buffer.wireSize;
                    buffer.wireSize += attribute.instanceSize;
                    buffer.memSize += (long)attribute.instanceSize;
                }
            } else {
                log.error("Duplicate attribute detected: " + attribute.id);
            }
        } else if ("ORB".equals(localName)) {
            for (int j = 0; j < atts.getLength(); ++j) {
                if (atts.getLocalName(j).equals("OPT")) {
                    String[] argv = atts.getValue(j).split(" ");
                    int orbargs = 0;
                    boolean lookForInterface = false;
                    for (int i = 0; i < argv.length; ++i) {
                        String arg = "blacktie.orb.arg." + (i + 1);
                        String toSet = this.getenv(argv[i]);
                        if (toSet.equals("-ORBListenEndpoints")) {
                            lookForInterface = true;
                            continue;
                        }
                        if (lookForInterface) {
                            int startOfHostname = toSet.indexOf("//") + 2;
                            int portIndex = toSet.indexOf(":", startOfHostname);
                            String interfaceAddress = toSet.substring(startOfHostname, portIndex);
                            String interfacePort = toSet.substring(portIndex + 1);
                            this.prop.setProperty("blacktie.orb.interface", interfaceAddress);
                            this.prop.setProperty("blacktie.orb.interface.port", interfacePort);
                            continue;
                        }
                        this.prop.setProperty(arg, toSet);
                        log.debug(arg + " is " + toSet);
                        ++orbargs;
                    }
                    log.debug("blacktie.orb.args is " + orbargs);
                    this.prop.setProperty("blacktie.orb.args", Integer.toString(orbargs));
                    continue;
                }
                if (!atts.getLocalName(j).equals("TRANS_FACTORY_ID")) continue;
                this.prop.setProperty("blacktie.trans.factoryid", atts.getValue(j));
            }
        } else if ("MQ".equals(localName)) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String avalue = this.getenv(atts.getValue(i));
                if (atts.getLocalName(i).equals("USER")) {
                    this.prop.setProperty("StompConnectUsr", avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("PASSWORD")) {
                    this.prop.setProperty("StompConnectPwd", avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("DESTINATION_TIMEOUT")) {
                    this.prop.setProperty("DestinationTimeout", avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("RECEIVE_TIMEOUT")) {
                    this.prop.setProperty("ReceiveTimeout", avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("TIME_TO_LIVE")) {
                    this.prop.setProperty("TimeToLive", avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("NAMING_URL")) {
                    this.prop.setProperty("java.naming.provider.url", avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("HOST")) {
                    this.prop.setProperty("StompConnectHost", avalue);
                    continue;
                }
                if (!atts.getLocalName(i).equals("PORT")) continue;
                this.prop.setProperty("StompConnectPort", avalue);
            }
        } else if ("SOCKETSERVER".equals(localName)) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String avalue = this.getenv(atts.getValue(i));
                if (atts.getLocalName(i).equals("PORT")) {
                    this.prop.setProperty("blacktie.java.socketserver.port", avalue);
                    continue;
                }
                if (!atts.getLocalName(i).equals("HOST")) continue;
                this.prop.setProperty("blacktie.java.socketserver.host", avalue);
            }
        } else if ("MACHINE".equals(localName)) {
            Machine machine = new Machine();
            for (int i = 0; i < atts.getLength(); ++i) {
                String avalue = this.getenv(atts.getValue(i));
                if (atts.getLocalName(i).equals("id")) {
                    machine.setId(avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("hostname")) {
                    machine.setHostname(avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("ipAddress")) {
                    machine.setIpAddress(avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("pathToExecutable")) {
                    machine.setPathToExecutable(avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("workingDirectory")) {
                    machine.setWorkingDirectory(avalue);
                    continue;
                }
                if (atts.getLocalName(i).equals("serverId")) {
                    machine.setServerId(Integer.parseInt(avalue));
                    continue;
                }
                if (!atts.getLocalName(i).equals("argLine")) continue;
                machine.setArgLine(avalue);
            }
            this.machines.put(machine.getId(), machine);
        } else if ("SERVICE".equals(localName)) {
            String ex_key;
            String ad_key;
            for (int i = 0; i < atts.getLength(); ++i) {
                String ad_key2;
                String attsLocalName = atts.getLocalName(i);
                if (attsLocalName.equals("name")) {
                    this.serviceName = atts.getValue(i);
                    String serviceServer = (String)this.prop.get("blacktie." + this.serviceName + ".server");
                    String type = (String)this.prop.get("blacktie." + this.serviceName + ".type");
                    if (serviceServer != null && !type.equals("topic")) {
                        log.warn("service " + this.serviceName + " has already been defined in " + this.serviceName);
                        throw new SAXException("Can not define the same service: " + this.serviceName);
                    }
                    if (this.serviceName.equals("BTStompAdmin") || this.serviceName.equals("BTDomainAdmin")) {
                        throw new SAXException("Can not define service: " + this.serviceName);
                    }
                    this.prop.put("blacktie." + this.serviceName + ".server", this.serverName);
                    continue;
                }
                if (attsLocalName.equals("function_name")) {
                    String func_key = "blacktie." + this.serviceName + ".function_name";
                    String function_name = atts.getValue(i);
                    this.prop.put(func_key, function_name);
                    continue;
                }
                if (attsLocalName.equals("java_class_name")) {
                    String java_key = "blacktie." + this.serviceName + ".java_class_name";
                    String java_class_name = atts.getValue(i);
                    this.prop.put(java_key, java_class_name);
                    continue;
                }
                if (attsLocalName.equals("library_name")) {
                    String lib_key = "blacktie." + this.serviceName + ".library_name";
                    String library_name = atts.getValue(i);
                    this.prop.put(lib_key, library_name);
                    continue;
                }
                if (attsLocalName.equals("advertised")) {
                    String advertised = atts.getValue(i);
                    ad_key2 = "blacktie." + this.serviceName + ".advertised";
                    this.prop.put(ad_key2, advertised);
                    if (!advertised.equals("true")) continue;
                    String skey = "blacktie." + this.serverName + ".services";
                    String object = (String)this.prop.get(skey);
                    object = object == null ? this.serviceName : new String(object + "," + this.serviceName);
                    this.prop.put(skey, object);
                    continue;
                }
                if (attsLocalName.equals("conversational")) {
                    String conversational = atts.getValue(i);
                    ad_key2 = "blacktie." + this.serviceName + ".conversational";
                    this.prop.put(ad_key2, new Boolean(conversational));
                    continue;
                }
                if (attsLocalName.equals("size")) {
                    String sizeKey = "blacktie." + this.serviceName + ".size";
                    String sizeVal = atts.getValue(i);
                    this.prop.setProperty(sizeKey, sizeVal);
                    continue;
                }
                if (attsLocalName.equals("externally-managed-destination")) {
                    String external = atts.getValue(i);
                    ad_key2 = "blacktie." + this.serviceName + ".externally-managed-destination";
                    this.prop.put(ad_key2, new Boolean(external));
                    continue;
                }
                if (attsLocalName.equals("type")) {
                    String type = atts.getValue(i);
                    String type_key = "blacktie." + this.serviceName + ".type";
                    this.prop.setProperty(type_key, type);
                    continue;
                }
                if (!attsLocalName.equals("coding_type")) continue;
                String coding_type = atts.getValue(i);
                String coding_key = "blacktie." + this.serviceName + ".coding_type";
                this.prop.setProperty(coding_key, coding_type);
            }
            String type_key = "blacktie." + this.serviceName + ".type";
            if (this.prop.get(type_key) == null) {
                this.prop.put(type_key, "queue");
            }
            if (this.prop.get(ad_key = "blacktie." + this.serviceName + ".conversational") == null) {
                this.prop.put(ad_key, (Object)false);
            }
            if (this.prop.get(ex_key = "blacktie." + this.serviceName + ".externally-managed-destination") == null) {
                this.prop.put(ex_key, (Object)false);
            }
            log.trace("Externally managed: " + this.prop.get("blacktie." + this.serviceName + ".externally-managed-destination"));
            log.trace("Added the service: " + this.serviceName);
            log.trace("Adding for: " + this.serviceName + " " + this.prop.get("blacktie." + this.serviceName + ".externally-managed-destination"));
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("DOMAIN".equals(localName)) {
            this.prop.setProperty("blacktie.domain.name", this.getenv(this.value));
        } else if ("SERVICE".equals(localName)) {
            this.serviceName = null;
        }
    }

    static {
        CHAR_SIZE = 1;
        LONG_SIZE = 8;
        INT_SIZE = 4;
        SHORT_SIZE = 2;
        FLOAT_SIZE = 4;
        DOUBLE_SIZE = 8;
    }
}

