/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.server;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Message;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Receiver;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.BlackTieService;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Response;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Service;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.TPSVCINFO;

public class ServiceDispatcher
extends BlackTieService
implements Runnable {
    private static final Logger log = LogManager.getLogger(ServiceDispatcher.class);
    private Service callback;
    private Receiver receiver;
    private Thread thread;
    private volatile boolean closing;
    private String serviceName;
    private Object closeLock = new Object();
    private String threadName;
    private boolean closed;

    ServiceDispatcher(String serviceName, Service callback, Receiver receiver, int index) throws ConfigurationException {
        super(serviceName);
        this.serviceName = serviceName;
        this.callback = callback;
        this.receiver = receiver;
        this.threadName = serviceName + "-Dispatcher-" + index;
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.start();
        log.debug("Created: " + this.thread.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug("Running");
        while (!this.closing) {
            Message message = null;
            try {
                message = this.receiver.receive(0L);
                log.trace("Received");
                if (message == null || this.closing) continue;
                try {
                    this.processMessage(this.serviceName, message);
                    log.trace("Processed");
                }
                catch (Throwable t) {
                    log.error("Can't process the message", t);
                }
                try {
                    message.ack();
                }
                catch (IOException t) {
                    log.error("Can't ack the message", (Throwable)t);
                }
            }
            catch (ConnectionException e) {
                if (this.closing) {
                    log.trace("Got an exception during close: " + e.getMessage(), (Throwable)e);
                    break;
                }
                if (e.getTperrno() == 13) {
                    log.debug("Got a timeout");
                    continue;
                }
                log.error("Could not receive the message: " + e.getMessage(), (Throwable)e);
                break;
            }
            catch (Throwable t) {
                log.warn("Got throwable trying to receive: " + t.getMessage(), t);
            }
        }
        Object object = this.closeLock;
        synchronized (object) {
            log.debug("Close the thread");
            this.closed = true;
            this.closeLock.notify();
        }
    }

    public void startClose() {
        log.trace("Attempting to close: " + this.threadName);
        this.closing = true;
        log.trace("Closed set: " + this.threadName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ConnectionException {
        log.trace("closing: " + this.threadName);
        log.trace("Closing receiver");
        this.receiver.close();
        log.trace("Closing receiver");
        Object object = this.closeLock;
        synchronized (object) {
            try {
                this.thread.interrupt();
                log.trace("Joining");
                if (!this.closed) {
                    this.closeLock.wait();
                }
                log.trace("Joined");
            }
            catch (InterruptedException e) {
                log.error("Could not join the dispatcher", (Throwable)e);
            }
        }
        log.trace("closed");
    }

    @Override
    public Response tpservice(TPSVCINFO svcinfo) throws ConnectionException, ConfigurationException {
        log.trace("Invoking callback");
        return this.callback.tpservice(svcinfo);
    }
}

