/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.xatmi;

import javax.annotation.PostConstruct;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.JtsTransactionImple;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Message;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionException;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionFactory;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Response;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Service;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.BufferImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.ConnectionImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.SessionImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.TPSVCINFO_Impl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.X_OCTET_Impl;
import org.jboss.narayana.rest.bridge.inbound.InboundBridge;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeManager;

public abstract class BlackTieService
implements Service {
    private static final Logger log = LogManager.getLogger(BlackTieService.class);
    private ConnectionFactory connectionFactory;
    private String name;

    protected BlackTieService(String name) throws ConfigurationException {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @PostConstruct
    public void init() {
        log.info("init PostConstruct");
        try {
            this.connectionFactory = ConnectionFactory.getConnectionFactory();
        }
        catch (ConfigurationException e) {
            log.warn("init failed with " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processMessage(String serviceName, Message message) throws ConnectionException, ConfigurationException, NamingException, InvalidTransactionException, IllegalStateException, SystemException, TransactionException {
        log.trace("Service invoked");
        if (this.connectionFactory == null) {
            this.connectionFactory = ConnectionFactory.getConnectionFactory();
        }
        try (ConnectionImpl connection = (ConnectionImpl)this.connectionFactory.getConnection();){
            boolean hasTx = false;
            boolean hasTPNOREPLY = (message.flags & 4) == 4;
            boolean responseSendable = !hasTPNOREPLY;
            short rval = 1;
            int rcode = 10;
            byte[] data = null;
            int len = 0;
            int flags = 0;
            String type = null;
            String subtype = null;
            SessionImpl serviceSession = connection.createServiceSession(serviceName, message.cd, message.replyTo);
            InboundBridge inboundBridge = null;
            try {
                boolean isConversational;
                boolean hasTPCONV = (message.flags & 0x400) == 1024;
                Boolean conversational = (Boolean)this.connectionFactory.getProperties().get("blacktie." + serviceName + ".conversational");
                log.trace(serviceName);
                boolean bl = isConversational = conversational == true;
                if (hasTPCONV && isConversational) {
                    X_OCTET_Impl odata = new X_OCTET_Impl(null);
                    byte[] ack = new byte[4];
                    byte[] bytes = "ACK".getBytes();
                    System.arraycopy(bytes, 0, ack, 0, 3);
                    odata.setByteArray(ack);
                    long result = serviceSession.tpsend(odata, 0);
                    if (result == -1L) {
                        log.error("Could not send ack");
                        serviceSession.close();
                        return;
                    }
                    log.debug("Sent ack");
                    serviceSession.setCreatedState(message.flags);
                } else if (!hasTPCONV && !isConversational) {
                    log.debug("Session was not a TPCONV");
                } else {
                    log.error("Session was invoked in an improper manner");
                    X_OCTET_Impl odata = new X_OCTET_Impl(null);
                    byte[] ack = new byte[4];
                    byte[] bytes = "ERR".getBytes();
                    System.arraycopy(bytes, 0, ack, 0, 3);
                    odata.setByteArray(bytes);
                    long result = serviceSession.tpsend(odata, 0);
                    if (result == -1L) {
                        log.error("Could not send err");
                    } else {
                        log.error("Error reported");
                    }
                    serviceSession.close();
                    return;
                }
                log.debug("Created the session");
                BufferImpl buffer = null;
                if (message.type != null && !message.type.equals("")) {
                    buffer = (BufferImpl)connection.tpalloc(message.type, message.subtype);
                    buffer.deserialize(message.data);
                }
                TPSVCINFO_Impl tpsvcinfo = new TPSVCINFO_Impl(message.serviceName, buffer, message.flags, hasTPCONV ? serviceSession : null, connection, message.len);
                log.debug("Prepared the data for passing to the service");
                hasTx = message.control != null && message.control.length() != 0;
                log.debug("hasTx=" + hasTx + " control: " + message.control);
                if (hasTx) {
                    if (message.control.startsWith("IOR")) {
                        log.debug("resume OTS transaction");
                        JtsTransactionImple.resume(message.control);
                    } else if (message.control.startsWith("http")) {
                        log.debug("start inbound bridge");
                        inboundBridge = InboundBridgeManager.getInstance().createInboundBridge(message.control);
                        inboundBridge.start();
                    } else {
                        log.error(message.control + " is not OTS or RTS when resume the transaction");
                    }
                }
                log.debug("Invoking the XATMI service");
                Response response = null;
                try {
                    response = this.tpservice(tpsvcinfo);
                    log.debug("Service invoked");
                    if (!hasTPNOREPLY && response == null) {
                        log.error("Error, expected response but none returned");
                    }
                }
                catch (Throwable t) {
                    log.error("Service error detected", t);
                }
                if (!hasTPNOREPLY && serviceSession.getSender() != null) {
                    log.trace("Sending response");
                    if (response != null) {
                        rval = response.getRval();
                        rcode = response.getRcode();
                        if (rval != 2 && rval != 1) {
                            rval = 1;
                        }
                    }
                    if (connection.hasOpenSessions()) {
                        rcode = 10;
                        rval = 1;
                    }
                    if (rval == 1 && TransactionImpl.current() != null) {
                        try {
                            TransactionImpl.current().rollback_only();
                        }
                        catch (TransactionException e) {
                            throw new ConnectionException(12, "Could not mark transaction for rollback only");
                        }
                    }
                    if (response != null) {
                        BufferImpl toSend = (BufferImpl)response.getBuffer();
                        if (toSend != null) {
                            len = toSend.getLen();
                            data = toSend.serialize();
                            type = toSend.getType();
                            subtype = toSend.getSubtype();
                        }
                        flags = response.getFlags();
                    }
                    log.debug("Will return desired message");
                    return;
                }
                if (!hasTPNOREPLY && serviceSession.getSender() == null) {
                    log.error("No sender avaible but message to be sent");
                    responseSendable = false;
                    return;
                }
                log.debug("No need to send a response");
                return;
            }
            finally {
                if (hasTx) {
                    if (message.control.startsWith("IOR")) {
                        log.debug("suspend OTS transaction");
                        JtsTransactionImple.suspend();
                    } else if (message.control.startsWith("http")) {
                        log.debug("inbound bridge stop");
                        if (inboundBridge != null) {
                            inboundBridge.stop();
                        }
                    } else {
                        log.error(message.control + " is not OTS or RTS when suspend the transaction");
                    }
                }
                if (responseSendable) {
                    serviceSession.getSender().send("", rval, rcode, data, len, 0, flags, 0, type, subtype);
                }
            }
        }
    }
}

