/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Sender;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;

public class SocketSenderImpl
implements Sender {
    private static final Logger log = LogManager.getLogger(SocketSenderImpl.class);
    private String addr;
    private int sid;
    private boolean closed;
    private int pad = 0;
    private Socket socket;
    private DataOutputStream outs;

    SocketSenderImpl(String addr) throws ConnectionException {
        log.debug((Object)"creating socket sender ");
        this.addr = addr;
        String[] s = addr.split(":");
        try {
            this.socket = new Socket(s[0], Integer.parseInt(s[1]));
            this.sid = Integer.parseInt(s[2]);
            this.outs = new DataOutputStream(this.socket.getOutputStream());
            this.closed = false;
        }
        catch (Exception e) {
            throw new ConnectionException(9, "connect to " + addr + " failed with " + e);
        }
        log.debug((Object)("create socket sender for " + addr));
    }

    public SocketSenderImpl(Socket endpoint, String replyTo) throws ConnectionException {
        log.debug((Object)("create socket sender with receiver endpoint " + endpoint.getRemoteSocketAddress() + " " + endpoint.getLocalPort()));
        this.socket = endpoint;
        try {
            this.outs = new DataOutputStream(this.socket.getOutputStream());
        }
        catch (IOException e) {
            throw new ConnectionException(9, "get stream from endpoint failed with " + e);
        }
        this.addr = replyTo;
        this.closed = false;
        log.debug((Object)("create socket sender for " + replyTo));
    }

    public Object getSendTo() {
        return this.addr;
    }

    public void send(Object replyTo, short rval, int rcode, byte[] data, int len, int correlationId, int flags, int ttl, String type, String subtype) throws ConnectionException {
        String toReplyTo;
        log.debug((Object)"Sending the message");
        if (this.closed) {
            log.error((Object)"Sender closed");
            throw new ConnectionException(9, "Sender closed");
        }
        if (data == null) {
            data = new byte[]{0};
            len = 1;
        }
        if ((toReplyTo = (String)replyTo) == null || toReplyTo.isEmpty()) {
            log.debug((Object)"Reply to set as null");
            toReplyTo = "(null)";
        }
        if (type == null || type.isEmpty()) {
            log.debug((Object)"Type set as null");
            type = "(null)";
        }
        if (subtype == null || subtype.isEmpty()) {
            log.debug((Object)"Subtype set as null");
            subtype = "(null)";
        }
        if (len < 1) {
            log.error((Object)"Length of buffer must be greater than 0");
            throw new ConnectionException(4, "Length of buffer must be greater than 0");
        }
        byte[] toSend = new byte[len + this.pad];
        if (data != null) {
            int min = Math.min(toSend.length, data.length);
            System.arraycopy(data, 0, toSend, 0, min);
        }
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.sid).append("\n").append(correlationId).append("\n").append(rcode).append("\n").append(toSend.length).append("\n").append(flags).append("\n").append(rval).append("\n").append(toReplyTo).append("\n").append(type).append("\n").append(subtype).append("\n");
            int sendlen = buffer.length() + toSend.length;
            log.debug((Object)("send on " + this.socket + " len is " + sendlen + " and buffer is " + buffer));
            try {
                this.outs.writeInt(sendlen);
                this.outs.write(buffer.toString().getBytes(), 0, buffer.length());
                this.outs.write(toSend, 0, toSend.length);
            }
            catch (SocketException e) {
                log.warn((Object)("socket send with " + e));
            }
        }
        catch (IOException e) {
            throw new ConnectionException(9, "send failed with " + e);
        }
    }

    public void close() throws ConnectionException {
        log.debug((Object)"Close called");
        if (this.closed) {
            throw new ConnectionException(9, "Sender already closed");
        }
        this.closed = true;
        try {
            this.outs.close();
            this.socket.shutdownOutput();
        }
        catch (SocketException socketException) {
        }
        catch (IOException e) {
            throw new ConnectionException(9, "close socket failed with " + e);
        }
        log.debug((Object)("Sender closed: " + this.addr));
    }

    public Object getEndpoint() {
        return this.socket;
    }
}

