/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.ResponseMonitor;
import org.jboss.narayana.blacktie.jatmibroker.core.server.Client;
import org.jboss.narayana.blacktie.jatmibroker.core.server.ClientContext;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.EventListener;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Message;

public class SocketServer
implements Runnable {
    private static final Logger log = LogManager.getLogger(SocketServer.class);
    private int port;
    private String addr;
    private ServerSocket serverSocket;
    private boolean shutdown = false;
    private List<Thread> threads;
    private List<Client> clients;
    private List<ClientContext> contexts;
    private static SocketServer instance;
    private static int reference;
    private Thread serverThread;

    public static synchronized SocketServer getInstance(Properties properties) throws IOException {
        if (instance == null) {
            int port = Integer.parseInt(properties.getProperty("blacktie.java.socketserver.port"));
            String addr = properties.getProperty("blacktie.java.socketserver.host", "localhost");
            instance = new SocketServer(port, addr);
            reference = 0;
        }
        ++reference;
        return instance;
    }

    public static synchronized void discardInstance() {
        if (--reference == 0) {
            instance.shutdown();
            instance = null;
        }
    }

    private SocketServer(int port, String addr) throws IOException {
        this.addr = addr;
        this.serverSocket = new ServerSocket(port);
        this.port = this.serverSocket.getLocalPort();
        this.clients = new ArrayList<Client>();
        this.threads = new ArrayList<Thread>();
        this.contexts = new ArrayList<ClientContext>();
        this.serverThread = new Thread(this);
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    public int getPort() {
        return this.port;
    }

    public String getAddr() {
        return this.addr;
    }

    public Socket getClientSocket(int sid) {
        ClientContext context = this.getContext(sid);
        if (context != null) {
            return context.getSocket();
        }
        return null;
    }

    public synchronized ClientContext register(int sid, ResponseMonitor responseMonitor, EventListener eventListener) {
        for (int i = 0; i < this.contexts.size(); ++i) {
            if (this.contexts.get(i).getSid() != sid) continue;
            return this.contexts.get(i);
        }
        ClientContext context = new ClientContext();
        context.setSid(sid);
        context.setResponseMonitor(responseMonitor);
        context.setEventListener(eventListener);
        this.contexts.add(context);
        log.debug((Object)("register sid " + sid));
        return context;
    }

    public synchronized void unregister(int sid) {
        for (int i = 0; i < this.contexts.size(); ++i) {
            if (this.contexts.get(i).getSid() != sid) continue;
            this.contexts.remove(i);
            log.debug((Object)("unregister sid " + sid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveMessage(int sid, long timeout) {
        ClientContext context = this.getContext(sid);
        Message msg = null;
        if (context != null) {
            ClientContext clientContext = context;
            synchronized (clientContext) {
                msg = context.getMessage(timeout);
            }
        } else {
            log.warn((Object)("Could not receive message for sid " + sid));
        }
        return msg;
    }

    public ClientContext getContext(int sid) {
        for (int i = 0; i < this.contexts.size(); ++i) {
            if (this.contexts.get(i).getSid() != sid) continue;
            return this.contexts.get(i);
        }
        return null;
    }

    private void shutdown() {
        log.debug((Object)"shutdowning server");
        try {
            this.shutdown = true;
            for (int i = 0; i < this.threads.size(); ++i) {
                try {
                    this.clients.get(i).close();
                    this.threads.get(i).join();
                    continue;
                }
                catch (InterruptedException e) {
                    log.error((Object)("join client " + i + " failed with " + e));
                }
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            this.serverThread.join();
        }
        catch (IOException e) {
            log.error((Object)("close server socket failed with " + e));
        }
        catch (InterruptedException e) {
            log.error((Object)("Could not join serverThread with " + e));
        }
        log.debug((Object)"shutdown server");
    }

    protected void finalize() {
        this.shutdown();
    }

    public void run() {
        while (!this.shutdown) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                log.debug((Object)("connection from " + clientSocket));
                Client client = new Client(this, clientSocket);
                this.clients.add(client);
                Thread thread = new Thread(client);
                this.threads.add(thread);
                thread.start();
            }
            catch (SocketException clientSocket) {
            }
            catch (IOException e) {
                log.error((Object)("run server failed with " + e));
            }
        }
    }
}

