/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.xatmi;

import javax.annotation.PostConstruct;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.JtsTransactionImple;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Message;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionException;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionFactory;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Service;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.BufferImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.ConnectionImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.TPSVCINFO_Impl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.X_OCTET_Impl;
import org.jboss.narayana.rest.bridge.inbound.InboundBridgeManager;

public abstract class BlackTieService
implements Service {
    private static final Logger log = LogManager.getLogger(BlackTieService.class);
    private ConnectionFactory connectionFactory;
    private String name;

    protected BlackTieService(String name) throws ConfigurationException {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @PostConstruct
    public void init() {
        log.info((Object)"init PostConstruct");
        try {
            this.connectionFactory = ConnectionFactory.getConnectionFactory();
        }
        catch (ConfigurationException e) {
            log.warn((Object)("init failed with " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void processMessage(String serviceName, Message message) throws ConnectionException, ConfigurationException, NamingException, InvalidTransactionException, IllegalStateException, SystemException, TransactionException {
        block55: {
            BlackTieService.log.trace((Object)"Service invoked");
            if (this.connectionFactory == null) {
                this.connectionFactory = ConnectionFactory.getConnectionFactory();
            }
            connection = (ConnectionImpl)this.connectionFactory.getConnection();
            try {
                block50: {
                    block51: {
                        hasTx = false;
                        hasTPNOREPLY = (message.flags & 4) == 4;
                        responseSendable = hasTPNOREPLY == false;
                        rval = 1;
                        rcode = 10;
                        data = null;
                        len = 0;
                        flags = 0;
                        type = null;
                        subtype = null;
                        serviceSession = connection.createServiceSession(serviceName, message.cd, message.replyTo);
                        inboundBridge = null;
                        hasTPCONV = (message.flags & 1024) == 1024;
                        conversational = (Boolean)this.connectionFactory.getProperties().get("blacktie." + serviceName + ".conversational");
                        BlackTieService.log.trace((Object)serviceName);
                        v0 = isConversational = conversational == true;
                        if (!hasTPCONV || !isConversational) ** GOTO lbl59
                        odata = new X_OCTET_Impl(null);
                        ack = new byte[4];
                        bytes = "ACK".getBytes();
                        System.arraycopy(bytes, 0, ack, 0, 3);
                        odata.setByteArray(ack);
                        result = serviceSession.tpsend(odata, 0);
                        if (result != -1L) break block49;
                        BlackTieService.log.error((Object)"Could not send ack");
                        serviceSession.close();
                        var25_30 = null;
                        if (!hasTx) break block50;
                        if (!message.control.startsWith("IOR")) break block51;
                        BlackTieService.log.debug((Object)"suspend OTS transaction");
                        JtsTransactionImple.suspend();
                        break block50;
                    }
                    if (message.control.startsWith("http")) {
                        BlackTieService.log.debug((Object)"inbound bridge stop");
                        if (inboundBridge != null) {
                            inboundBridge.stop();
                        }
                    } else {
                        BlackTieService.log.error((Object)(message.control + " is not OTS or RTS when suspend the transaction"));
                    }
                }
                if (responseSendable) {
                    serviceSession.getSender().send("", rval, rcode, data, len, 0, flags, 0, type, subtype);
                }
                var27_34 = null;
            }
            catch (Throwable var26_39) {
                var27_37 = null;
                connection.close();
                throw var26_39;
            }
            connection.close();
            {
                block53: {
                    block54: {
                        block49: {
                            return;
                        }
                        BlackTieService.log.debug((Object)"Sent ack");
                        serviceSession.setCreatedState(message.flags);
                        break block52;
lbl59:
                        // 1 sources

                        if (!hasTPCONV && !isConversational) {
                            BlackTieService.log.debug((Object)"Session was not a TPCONV");
                            break block52;
                        }
                        BlackTieService.log.error((Object)"Session was invoked in an improper manner");
                        odata = new X_OCTET_Impl(null);
                        ack = new byte[4];
                        bytes = "ERR".getBytes();
                        System.arraycopy(bytes, 0, ack, 0, 3);
                        odata.setByteArray(bytes);
                        result = serviceSession.tpsend(odata, 0);
                        if (result == -1L) {
                            BlackTieService.log.error((Object)"Could not send err");
                        } else {
                            BlackTieService.log.error((Object)"Error reported");
                        }
                        serviceSession.close();
                        var25_31 = null;
                        if (!hasTx) break block53;
                        if (!message.control.startsWith("IOR")) break block54;
                        BlackTieService.log.debug((Object)"suspend OTS transaction");
                        JtsTransactionImple.suspend();
                        break block53;
                    }
                    if (message.control.startsWith("http")) {
                        BlackTieService.log.debug((Object)"inbound bridge stop");
                        if (inboundBridge != null) {
                            inboundBridge.stop();
                        }
                    } else {
                        BlackTieService.log.error((Object)(message.control + " is not OTS or RTS when suspend the transaction"));
                    }
                }
                if (!responseSendable) break block55;
                serviceSession.getSender().send("", rval, rcode, data, len, 0, flags, 0, type, subtype);
            }
        }
        var27_35 = null;
        connection.close();
        {
            block56: {
                block57: {
                    block52: {
                        return;
                    }
                    try {
                        BlackTieService.log.debug((Object)"Created the session");
                        buffer = null;
                        if (message.type != null && !message.type.equals("")) {
                            buffer = (BufferImpl)connection.tpalloc(message.type, message.subtype);
                            buffer.deserialize(message.data);
                        }
                        tpsvcinfo = new TPSVCINFO_Impl(message.serviceName, buffer, message.flags, hasTPCONV != false ? serviceSession : null, connection, message.len);
                        BlackTieService.log.debug((Object)"Prepared the data for passing to the service");
                        hasTx = message.control != null && message.control.length() != 0;
                        BlackTieService.log.debug((Object)("hasTx=" + hasTx + " control: " + message.control));
                        if (hasTx) {
                            if (message.control.startsWith("IOR")) {
                                BlackTieService.log.debug((Object)"resume OTS transaction");
                                JtsTransactionImple.resume(message.control);
                            } else if (message.control.startsWith("http")) {
                                BlackTieService.log.debug((Object)"start inbound bridge");
                                inboundBridge = InboundBridgeManager.getInstance().createInboundBridge(message.control);
                                inboundBridge.start();
                            } else {
                                BlackTieService.log.error((Object)(message.control + " is not OTS or RTS when resume the transaction"));
                            }
                        }
                        BlackTieService.log.debug((Object)"Invoking the XATMI service");
                        response = null;
                        try {
                            response = this.tpservice(tpsvcinfo);
                            BlackTieService.log.debug((Object)"Service invoked");
                            if (!hasTPNOREPLY && response == null) {
                                BlackTieService.log.error((Object)"Error, expected response but none returned");
                            }
                        }
                        catch (Throwable t) {
                            BlackTieService.log.error((Object)"Service error detected", t);
                        }
                        if (!hasTPNOREPLY && serviceSession.getSender() != null) {
                            BlackTieService.log.trace((Object)"Sending response");
                            if (response != null) {
                                rval = response.getRval();
                                rcode = response.getRcode();
                                if (rval != 2 && rval != 1) {
                                    rval = 1;
                                }
                            }
                            if (connection.hasOpenSessions()) {
                                rcode = 10;
                                rval = 1;
                            }
                            if (rval == 1 && TransactionImpl.current() != null) {
                                try {
                                    TransactionImpl.current().rollback_only();
                                }
                                catch (TransactionException e) {
                                    throw new ConnectionException(12, "Could not mark transaction for rollback only");
                                }
                            }
                            if (response != null) {
                                toSend = (BufferImpl)response.getBuffer();
                                if (toSend != null) {
                                    len = toSend.getLen();
                                    data = toSend.serialize();
                                    type = toSend.getType();
                                    subtype = toSend.getSubtype();
                                }
                                flags = response.getFlags();
                            }
                            BlackTieService.log.debug((Object)"Will return desired message");
                        } else if (!hasTPNOREPLY && serviceSession.getSender() == null) {
                            BlackTieService.log.error((Object)"No sender avaible but message to be sent");
                            responseSendable = false;
                        } else {
                            BlackTieService.log.debug((Object)"No need to send a response");
                        }
                        var25_32 = null;
                        if (!hasTx) break block56;
                        if (!message.control.startsWith("IOR")) break block57;
                    }
                    catch (Throwable var24_38) {
                        var25_33 = null;
                        if (hasTx) {
                            if (message.control.startsWith("IOR")) {
                                BlackTieService.log.debug((Object)"suspend OTS transaction");
                                JtsTransactionImple.suspend();
                            } else if (message.control.startsWith("http")) {
                                BlackTieService.log.debug((Object)"inbound bridge stop");
                                if (inboundBridge != null) {
                                    inboundBridge.stop();
                                }
                            } else {
                                BlackTieService.log.error((Object)(message.control + " is not OTS or RTS when suspend the transaction"));
                            }
                        }
                        if (responseSendable) {
                            serviceSession.getSender().send("", rval, rcode, data, len, 0, flags, 0, type, subtype);
                        }
                        throw var24_38;
                    }
                    BlackTieService.log.debug((Object)"suspend OTS transaction");
                    JtsTransactionImple.suspend();
                    break block56;
                }
                if (message.control.startsWith("http")) {
                    BlackTieService.log.debug((Object)"inbound bridge stop");
                    if (inboundBridge != null) {
                        inboundBridge.stop();
                    }
                } else {
                    BlackTieService.log.error((Object)(message.control + " is not OTS or RTS when suspend the transaction"));
                }
            }
            if (responseSendable) {
                serviceSession.getSender().send("", rval, rcode, data, len, 0, flags, 0, type, subtype);
            }
        }
        var27_36 = null;
        connection.close();
    }
}

