/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.xatmi.mdb;

import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.JtsTransactionImple;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.BlackTieService;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;

public abstract class MDBBlacktieService
extends BlackTieService
implements MessageListener {
    private static final Logger log = LogManager.getLogger(MDBBlacktieService.class);

    protected MDBBlacktieService(String name) throws ConfigurationException {
        super(name);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void onMessage(Message message) {
        try {
            String serviceName = null;
            Destination jmsDestination = message.getJMSDestination();
            serviceName = jmsDestination instanceof Queue ? ((Queue)jmsDestination).getQueueName() : ((Topic)jmsDestination).getTopicName();
            serviceName = serviceName.substring(serviceName.indexOf(95) + 1);
            log.trace((Object)serviceName);
            if (JtsTransactionImple.hasTransaction()) {
                throw new ConnectionException(9, "Blacktie services must not be called with a transactional context: " + this.getName() + ":" + serviceName);
            }
            BytesMessage bytesMessage = (BytesMessage)message;
            org.jboss.narayana.blacktie.jatmibroker.core.transport.Message toProcess = MDBBlacktieService.convertFromBytesMessage(bytesMessage);
            log.debug((Object)("SERVER onMessage: transaction control ior: " + toProcess.control));
            this.processMessage(serviceName, toProcess);
            log.debug((Object)"Processed message");
        }
        catch (Throwable t) {
            log.error((Object)"Could not service the request", t);
        }
    }

    private static org.jboss.narayana.blacktie.jatmibroker.core.transport.Message convertFromBytesMessage(BytesMessage message) throws JMSException {
        String controlIOR = message.getStringProperty("messagecontrol");
        String replyTo = message.getStringProperty("messagereplyto");
        int len = (int)message.getBodyLength();
        String serviceName = message.getStringProperty("servicename");
        int flags = new Integer(message.getStringProperty("messageflags"));
        int cd = new Integer(message.getStringProperty("messagecorrelationId"));
        String type = message.getStringProperty("messagetype");
        String subtype = message.getStringProperty("messagesubtype");
        log.debug((Object)("type: " + type + " subtype: " + subtype));
        org.jboss.narayana.blacktie.jatmibroker.core.transport.Message toProcess = new org.jboss.narayana.blacktie.jatmibroker.core.transport.Message();
        toProcess.type = type;
        toProcess.subtype = subtype;
        toProcess.replyTo = replyTo;
        toProcess.serviceName = serviceName;
        toProcess.flags = flags;
        toProcess.cd = cd;
        toProcess.len = len;
        if (toProcess.type == "") {
            toProcess.data = null;
        } else {
            toProcess.data = new byte[toProcess.len];
            message.readBytes(toProcess.data);
        }
        toProcess.control = controlIOR;
        return toProcess;
    }
}

