/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.conf;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.XMLEnvHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private static final Logger log = LogManager.getLogger(XMLParser.class);
    private DefaultHandler handler;
    private SAXParser saxParser;
    private Schema schema;
    private Properties properties = new Properties();
    private static Map<URL, XMLParser> parsedFiles = new HashMap<URL, XMLParser>();

    private XMLParser(String xsdFilename, String env) throws ConfigurationException {
        this.handler = new XMLEnvHandler(this.properties);
        log.debug((Object)("Creating the parser: " + xsdFilename));
        try {
            String schemaDir = System.getenv("BLACKTIE_SCHEMA_DIR");
            if (schemaDir != null) {
                log.debug((Object)("SCHEMA DIR: " + schemaDir));
                schemaDir = schemaDir + System.getProperty("file.separator");
                xsdFilename = schemaDir + xsdFilename;
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL resource = Thread.currentThread().getContextClassLoader().getResource(xsdFilename);
            if (resource != null) {
                this.schema = schemaFactory.newSchema(resource);
            } else {
                File file = new File(xsdFilename);
                if (file.exists()) {
                    this.schema = schemaFactory.newSchema(file);
                } else {
                    throw new ConfigurationException("Could not load the schema: " + xsdFilename);
                }
            }
            factory.setSchema(this.schema);
            this.saxParser = factory.newSAXParser();
        }
        catch (SAXException e) {
            log.error((Object)("Could not create a SAXParser: " + e.getMessage()), (Throwable)e);
            throw new ConfigurationException("Could not create a SAXParser: " + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Could not create a SAXParser: " + e.getMessage()), (Throwable)e);
            throw new ConfigurationException("Could not create a SAXParser: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            log.error((Object)("Could not parse configuration: " + e.getMessage()), e);
            throw new ConfigurationException("Could not parse configuration: " + e.getMessage(), e);
        }
        String configDir = System.getenv("BLACKTIE_CONFIGURATION_DIR");
        if (configDir != null && !configDir.equals("")) {
            env = configDir + "/" + env;
        }
        log.debug((Object)("read " + env + " configuration from " + configDir + " directory"));
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(env);
        if (resource != null) {
            try {
                this.schema.newValidator().validate(new StreamSource(resource));
                this.saxParser.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(env), this.handler);
            }
            catch (Throwable t) {
                throw new ConfigurationException("Errors parse : " + env + " due to: " + t.getMessage(), t);
            }
        } else {
            throw new ConfigurationException("Could not load the configuration file: " + env + " please update your CLASSPATH");
        }
    }

    public Properties getLoadedProperties() {
        return this.properties;
    }

    public static void loadProperties(String schemaName, String configFile, Properties prop) throws ConfigurationException {
        URL resource;
        log.trace((Object)"Detecting the filename");
        String env = configFile;
        String configDir = System.getenv("BLACKTIE_CONFIGURATION_DIR");
        if (configDir != null && !configDir.equals("")) {
            env = configDir + "/" + env;
        }
        if ((resource = Thread.currentThread().getContextClassLoader().getResource(env)) == null) {
            throw new ConfigurationException("Could not find the file: " + env);
        }
        log.trace((Object)"Detected the filename");
        XMLParser parser = parsedFiles.get(resource);
        if (parser == null) {
            log.debug((Object)("Configfile not loaded yet: " + resource.getFile()));
            parser = new XMLParser(schemaName, configFile);
            parsedFiles.put(resource, parser);
        } else {
            log.debug((Object)("Configfile loaded before: " + resource.getFile()));
        }
        prop.putAll((Map<?, ?>)parser.getLoadedProperties());
    }
}

