/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.xatmi.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.codec.CodecFactory;
import org.jboss.narayana.blacktie.jatmibroker.core.ResponseMonitor;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Codec;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Message;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Receiver;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Transport;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.TransportFactory;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Buffer;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Connection;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionFactory;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Response;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ResponseException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Session;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.BufferImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.SessionImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.X_OCTET_Impl;

public class ConnectionImpl
implements Connection {
    private static final Logger log = LogManager.getLogger(ConnectionImpl.class);
    private static int nextId;
    private Map<String, Transport> transports = new HashMap<String, Transport>();
    private Map<Integer, Receiver> temporaryQueues = new HashMap<Integer, Receiver>();
    Properties properties;
    private Map<Integer, SessionImpl> sessions = new HashMap<Integer, SessionImpl>();
    private List<Integer> tpGetAnySessions = new ArrayList<Integer>();
    private ResponseMonitor responseMonitor;
    private ConnectionFactory connectionFactory;
    private SessionImpl serviceSession;
    private TransportFactory transportFactory;

    public ConnectionImpl(ConnectionFactory connectionFactory, Properties properties) throws ConfigurationException {
        log.debug((Object)("Creating connection: " + this));
        this.connectionFactory = connectionFactory;
        this.properties = properties;
        this.responseMonitor = new ResponseMonitorImpl();
        this.transportFactory = new TransportFactory(properties);
    }

    @Override
    public Buffer tpalloc(String type, String subtype) throws ConnectionException, ConfigurationException {
        if (type == null) {
            throw new ConnectionException(4, "No type provided");
        }
        log.debug((Object)("Initializing a new: " + type));
        try {
            Class<?> clazz = Class.forName(this.getClass().getPackage().getName() + "." + type + "_Impl");
            Constructor<?> ctor = clazz.getConstructor(String.class);
            return (Buffer)ctor.newInstance(subtype);
        }
        catch (InvocationTargetException t) {
            if (t.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)t.getCause();
            }
            throw new ConnectionException(6, "Type was not known: " + type, t);
        }
        catch (Throwable t) {
            throw new ConnectionException(6, "Type was not known: " + type, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response tpcall(String svc, Buffer buffer, int flags) throws ConnectionException, ConfigurationException {
        log.debug((Object)"tpcall");
        int tpacallFlags = flags;
        int cd = this.tpacall(svc, buffer, tpacallFlags &= 0xFFFFFEFF);
        try {
            Response response = this.receive(cd, flags);
            return response;
        }
        finally {
            this.tpcancel(cd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int tpacall(String svc, Buffer toSend, int flags) throws ConnectionException {
        log.debug((Object)"tpacall");
        int toCheck = flags & 0xFFFFFFD0;
        if (toCheck != 0) {
            log.trace((Object)("invalid flags remain: " + toCheck));
            throw new ConnectionException(4, "Invalid flags remain: " + toCheck);
        }
        svc = svc.substring(0, Math.min(128, svc.length()));
        String qtype = (String)this.properties.get("blacktie." + svc + ".type");
        log.debug((Object)(svc + " qtype is " + qtype + " and flags is " + flags));
        if ("topic".equals(qtype) && (flags & 4) == 0) {
            log.warn((Object)(svc + " type is " + qtype + " and MUST have TPNOREPLY set"));
            throw new ConnectionException(4, svc + " type is " + qtype + " and MUST have TPNOREPLY set");
        }
        int correlationId = 0;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            correlationId = ++nextId;
            log.trace((Object)("Allocated next sessionId: " + correlationId));
        }
        Transport transport = this.getTransport(svc);
        Receiver endpoint = transport.createReceiver(correlationId, this.responseMonitor, null);
        this.temporaryQueues.put(correlationId, endpoint);
        log.trace((Object)("Added a queue for: " + correlationId));
        String type = null;
        String subtype = null;
        int len = 0;
        byte[] data = null;
        if (toSend != null) {
            CodecFactory factory = new CodecFactory(this);
            String coding_type = this.properties.getProperty("blacktie." + svc + ".coding_type");
            Codec codec = factory.getCodec(coding_type);
            data = codec.encode((BufferImpl)toSend);
            type = toSend.getType();
            subtype = toSend.getSubtype();
            len = toSend.getLen();
        }
        String timeToLive = this.properties.getProperty("TimeToLive");
        int ttl = 0;
        if (timeToLive != null && (flags & 4) != 4) {
            ttl = Integer.parseInt(timeToLive) * 1000;
            log.debug((Object)("Set ttl: " + ttl));
        }
        transport.getSender(svc, false).send(endpoint.getReplyTo(), (short)0, 0, data, len, correlationId, flags, ttl, type, subtype);
        if ((flags & 4) == 4) {
            correlationId = 0;
        }
        log.debug((Object)("Returning cd: " + correlationId));
        return correlationId;
    }

    @Override
    public int tpcancel(int cd) throws ConnectionException {
        log.debug((Object)("tpcancel: " + cd));
        int toReturn = -1;
        Receiver endpoint = this.temporaryQueues.remove(cd);
        if (endpoint == null) {
            log.debug((Object)"No endpoint available");
            throw new ConnectionException(2, "cd " + cd + " does not exist");
        }
        log.debug((Object)"closing endpoint");
        endpoint.close();
        log.debug((Object)"endpoint closed");
        toReturn = 0;
        log.debug((Object)("tpcancel returning: " + toReturn));
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response tpgetrply(int cd, int flags) throws ConnectionException, ConfigurationException {
        log.debug((Object)("tpgetrply: " + cd));
        int toCheck = flags & 0xFFFFFE5C;
        if (toCheck != 0) {
            log.trace((Object)("invalid flags remain: " + toCheck));
            throw new ConnectionException(4, "Invalid flags remain: " + toCheck);
        }
        List<Integer> list = this.tpGetAnySessions;
        synchronized (list) {
            if ((flags & 0x80) == 128) {
                if ((flags & 1) != 1) {
                    int timeout = 0;
                    if ((flags & 0x20) != 32) {
                        timeout = Integer.parseInt(this.properties.getProperty("ReceiveTimeout")) * 1000 + Integer.parseInt(this.properties.getProperty("TimeToLive")) * 1000;
                    }
                    if (this.tpGetAnySessions.size() == 0) {
                        try {
                            this.tpGetAnySessions.wait(timeout);
                        }
                        catch (InterruptedException e) {
                            throw new ConnectionException(12, "Could not wait", e);
                        }
                    }
                    if (this.tpGetAnySessions.size() == 0) {
                        throw new ConnectionException(13, "No message arrived");
                    }
                } else if (this.tpGetAnySessions.size() == 0) {
                    throw new ConnectionException(3, "No message arrived");
                }
                cd = this.tpGetAnySessions.remove(0);
            }
        }
        Response toReturn = this.receive(cd, flags);
        this.tpcancel(cd);
        log.debug((Object)("tpgetrply returning: " + toReturn));
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session tpconnect(String svc, Buffer toSend, int flags) throws ConnectionException {
        boolean connected;
        log.debug((Object)("tpconnect: " + svc));
        svc = svc.substring(0, Math.min(128, svc.length()));
        svc = svc.substring(0, Math.min(128, svc.length()));
        int correlationId = 0;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            correlationId = nextId++;
        }
        Transport transport = this.getTransport(svc);
        SessionImpl session = new SessionImpl(this, svc, transport, correlationId);
        Receiver receiver = session.getReceiver();
        String type = null;
        String subtype = null;
        int len = 0;
        byte[] data = null;
        if (toSend != null) {
            CodecFactory factory = new CodecFactory(this);
            String coding_type = this.properties.getProperty("blacktie." + svc + ".coding_type");
            Codec codec = factory.getCodec(coding_type);
            data = codec.encode((BufferImpl)toSend);
            type = toSend.getType();
            subtype = toSend.getSubtype();
            len = toSend.getLen();
        }
        String timeToLive = this.properties.getProperty("TimeToLive");
        int ttl = 0;
        if (timeToLive != null) {
            ttl = Integer.parseInt(timeToLive) * 1000;
        }
        log.debug((Object)"tpconnect sending data");
        session.getSender().send(receiver.getReplyTo(), (short)0, 0, data, len, correlationId, flags | 0x400, ttl, type, subtype);
        byte[] response = null;
        try {
            log.debug((Object)"tpconnect receiving data");
            X_OCTET_Impl odata = (X_OCTET_Impl)session.tprecv(0);
            response = odata.getByteArray();
            log.debug((Object)"tpconnect received data");
        }
        catch (ResponseException e) {
            response = ((X_OCTET_Impl)e.getReceived()).getByteArray();
            log.debug((Object)"Caught an exception with data", (Throwable)e);
        }
        catch (ConnectionException e) {
            session.close();
            throw new ConnectionException(e.getTperrno(), "Could not connect");
        }
        catch (ConfigurationException e) {
            session.close();
            throw new ConnectionException(7, "Configuration exception: " + e.getMessage(), e);
        }
        byte[] ack = new byte[4];
        byte[] bytes = "ACK".getBytes();
        System.arraycopy(bytes, 0, ack, 0, 3);
        boolean bl = connected = response == null ? false : Arrays.equals(ack, response);
        if (!connected) {
            log.error((Object)"Could not connect");
            session.close();
            throw new ConnectionException(12, "Could not connect");
        }
        session.setCreatorState(flags);
        this.sessions.put(correlationId, session);
        log.trace((Object)("Added session: " + correlationId));
        log.debug((Object)("Created session: " + correlationId));
        return session;
    }

    @Override
    public void close() throws ConnectionException {
        log.debug((Object)("Close connection called: " + this));
        SessionImpl[] sessions = new SessionImpl[this.sessions.size()];
        sessions = this.sessions.values().toArray(sessions);
        for (int i = 0; i < sessions.length; ++i) {
            log.debug((Object)("closing session: " + sessions[i].getCd()));
            sessions[i].tpdiscon();
            log.debug((Object)("Closed open session: " + sessions[i].getCd()));
        }
        this.sessions.clear();
        log.trace((Object)"Removed all sessions");
        Receiver[] receivers = new Receiver[this.temporaryQueues.size()];
        receivers = this.temporaryQueues.values().toArray(receivers);
        for (int i = 0; i < receivers.length; ++i) {
            log.debug((Object)"closing receiver");
            this.tpcancel(receivers[i].getCd());
            log.debug((Object)"Closed open receiver");
        }
        this.temporaryQueues.clear();
        log.trace((Object)"Temporary queues cleared");
        if (this.serviceSession != null) {
            log.debug((Object)"closing service session");
            this.serviceSession.close();
            this.serviceSession = null;
            log.debug((Object)"Closed open service session");
        }
        for (Transport transport : this.transports.values()) {
            log.debug((Object)"closing transport");
            transport.close();
            log.debug((Object)"closed transport");
        }
        this.transports.clear();
        this.connectionFactory.removeConnection(this);
        this.transportFactory.close();
        log.debug((Object)"Close connection finished");
    }

    private Transport getTransport(String serviceName) throws ConnectionException {
        Transport toReturn = this.transports.get(serviceName);
        if (toReturn == null) {
            toReturn = this.transportFactory.createTransport();
            this.transports.put(serviceName, toReturn);
        }
        return toReturn;
    }

    private Response receive(int cd, int flags) throws ConnectionException, ConfigurationException {
        log.debug((Object)("receive: " + cd));
        Receiver endpoint = this.temporaryQueues.get(cd);
        if (endpoint == null) {
            throw new ConnectionException(2, "Session does not exist: " + cd);
        }
        Message message = endpoint.receive(flags);
        BufferImpl buffer = null;
        if (message.type != null && !message.type.equals("")) {
            CodecFactory factory = new CodecFactory(this);
            String coding_type = this.properties.getProperty("blacktie." + message.serviceName + ".coding_type");
            Codec codec = factory.getCodec(coding_type);
            buffer = codec.decode(message.type, message.subtype, message.data, message.len);
        }
        if (message.rval == 1) {
            if (message.rcode == 10) {
                throw new ResponseException(10, "Got an error back from the remote service", -1L, message.rcode, buffer);
            }
            throw new ResponseException(11, "Got a fail back from the remote service", -1L, message.rcode, buffer);
        }
        Response response = new Response(cd, message.rval, message.rcode, buffer, message.flags);
        log.debug((Object)("received returned a response? " + (response == null ? "false" : "true")));
        return response;
    }

    public SessionImpl createServiceSession(String name, int cd, Object replyTo) throws ConnectionException {
        log.trace((Object)"Creating the service session");
        if (this.serviceSession != null) {
            throw new ConnectionException(9, "Second service session creation attempt, was: " + this.serviceSession.getCd() + " new: " + cd);
        }
        Transport transport = this.getTransport(name);
        this.serviceSession = new SessionImpl(this, transport, cd, replyTo);
        log.trace((Object)("Created the service session: " + cd));
        return this.serviceSession;
    }

    public boolean hasOpenSessions() {
        return this.sessions.size() > 0 || this.temporaryQueues.size() > 0;
    }

    void removeSession(SessionImpl session) {
        log.debug((Object)("Removing session: " + session.getCd()));
        boolean remove = false;
        Iterator<Integer> iterator = this.sessions.keySet().iterator();
        while (iterator.hasNext()) {
            Integer next = iterator.next();
            if (next.intValue() == session.getCd()) {
                iterator.remove();
                log.trace((Object)("Removed session: " + session.getCd()));
                remove = true;
                break;
            }
            log.trace((Object)("Ignoring: " + next));
        }
        if (!remove) {
            log.debug((Object)("Session did not exist: " + session.getCd() + " size: " + this.sessions.size()));
        }
        if (session.equals(this.serviceSession)) {
            this.serviceSession = null;
        }
        log.debug((Object)("Removed session: " + session.getCd()));
    }

    private class ResponseMonitorImpl
    implements ResponseMonitor {
        private ResponseMonitorImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void responseReceived(int sessionId, boolean remove) {
            List list = ConnectionImpl.this.tpGetAnySessions;
            synchronized (list) {
                if (!remove) {
                    log.trace((Object)("tpgetanyCallback adding: " + sessionId));
                    ConnectionImpl.this.tpGetAnySessions.add(sessionId);
                    ConnectionImpl.this.tpGetAnySessions.notify();
                } else {
                    log.trace((Object)("tpgetanyCallback removing: " + sessionId));
                    for (int i = 0; i < ConnectionImpl.this.tpGetAnySessions.size(); ++i) {
                        if (sessionId != (Integer)ConnectionImpl.this.tpGetAnySessions.get(i)) continue;
                        ConnectionImpl.this.tpGetAnySessions.remove(i);
                        log.trace((Object)("tpgetanyCallback removed: " + sessionId));
                        break;
                    }
                }
            }
        }
    }
}

