/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.xatmi.server;

import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.orbportability.OA;
import com.arjuna.orbportability.ORB;
import com.arjuna.orbportability.RootOA;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.AtmiBrokerEnvXML;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.server.ServiceData;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.TransportFactory;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;

public class BlackTieServer {
    private static final Logger log = LogManager.getLogger(BlackTieServer.class);
    private String serverName;
    private Map<String, ServiceData> serviceData = new HashMap<String, ServiceData>();
    private Properties properties;
    private TransportFactory transportFactory;
    private boolean shutdown;

    public BlackTieServer(String serverName) throws ConfigurationException, ConnectionException {
        ORB orb = ORB.getInstance((String)"ClientSide");
        RootOA oa = OA.getRootOA((ORB)orb);
        orb.initORB(new String[0], null);
        try {
            oa.initOA();
        }
        catch (Throwable t) {
            throw new ConnectionException(12, "Could not connect to the orb", t);
        }
        ORBManager.setORB((ORB)orb);
        ORBManager.setPOA((OA)oa);
        this.serverName = serverName;
        AtmiBrokerEnvXML server = new AtmiBrokerEnvXML();
        this.properties = server.getProperties();
        this.transportFactory = new TransportFactory(this.properties);
        String services = (String)this.properties.get("blacktie." + serverName + ".services");
        if (services != null) {
            StringTokenizer st = new StringTokenizer(services, ",", false);
            while (st.hasMoreElements()) {
                String serviceName = st.nextToken();
                String functionName = (String)this.properties.get("blacktie." + serviceName + ".java_class_name");
                this.tpadvertise(serviceName, functionName);
            }
        }
    }

    public void tpadvertise(String serviceName, String serviceClassName) throws ConnectionException {
        int min = Math.min(128, serviceName.length());
        serviceName = serviceName.substring(0, min);
        log.debug((Object)("Advertising: " + serviceName));
        ServiceData serviceData = this.serviceData.get(serviceName);
        if (serviceData == null) {
            try {
                ServiceData data = new ServiceData(this.transportFactory, this.properties, serviceName, serviceClassName);
                this.serviceData.put(serviceName, data);
                log.info((Object)("Advertised: " + serviceName));
            }
            catch (ConnectionException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ConnectionException(12, "Could not create service factory for: " + serviceName, t);
            }
        } else {
            if (!serviceData.getServiceClassName().equals(serviceClassName)) {
                throw new ConnectionException(23, "Service already registered");
            }
            log.trace((Object)"This is a duplicate advertise");
        }
    }

    public void tpunadvertise(String serviceName) throws ConnectionException {
        ServiceData data = this.serviceData.remove(serviceName = serviceName.substring(0, Math.min(128, serviceName.length())));
        if (data == null) {
            throw new ConnectionException(6, "Service did not exist: " + serviceName);
        }
        data.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws ConnectionException {
        log.debug((Object)("Close server called: " + this.serverName));
        String[] array = new String[this.serviceData.size()];
        array = this.serviceData.keySet().toArray(array);
        for (int i = 0; i < array.length; ++i) {
            this.tpunadvertise(array[i]);
        }
        this.transportFactory.close();
        BlackTieServer blackTieServer = this;
        synchronized (blackTieServer) {
            this.shutdown = true;
            this.notify();
        }
        log.debug((Object)("Close server finished: " + this.serverName));
    }

    public synchronized void block() throws InterruptedException {
        if (!this.shutdown) {
            log.info((Object)"Server waiting for requests...");
            this.wait();
        }
    }
}

