/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.server.ServiceDispatcher;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Transport;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.TransportFactory;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Service;

public class ServiceData {
    private static final Logger log = LogManager.getLogger(ServiceData.class);
    private static final String DEFAULT_POOL_SIZE = "2";
    private List<ServiceDispatcher> dispatchers = new ArrayList<ServiceDispatcher>();
    private Transport connection;
    private String serviceClassName;
    private String serviceName;

    public ServiceData(TransportFactory transportFactory, Properties properties, String serviceName, String serviceClassName) throws ConnectionException, InstantiationException, IllegalAccessException, ClassNotFoundException, ConfigurationException {
        this.serviceName = serviceName;
        this.serviceClassName = serviceClassName;
        String sizeS = properties.getProperty("blacktie." + serviceName + ".size", DEFAULT_POOL_SIZE);
        int size = Integer.parseInt(sizeS);
        this.connection = transportFactory.createTransport();
        Boolean conversational = (Boolean)properties.get("blacktie." + serviceName + ".conversational");
        Class<?> callback = Class.forName(serviceClassName);
        for (int i = 0; i < size; ++i) {
            this.dispatchers.add(new ServiceDispatcher(serviceName, (Service)callback.newInstance(), this.connection.getReceiver(serviceName, conversational), i));
        }
    }

    public void close() throws ConnectionException {
        log.debug((Object)("Unadvertising: " + this.serviceName));
        Iterator<ServiceDispatcher> iterator = this.dispatchers.iterator();
        while (iterator.hasNext()) {
            iterator.next().startClose();
        }
        this.connection.close();
        this.connection = null;
        iterator = this.dispatchers.iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
        }
        this.dispatchers.clear();
        log.info((Object)("Unadvertised: " + this.serviceName));
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }
}

