/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.hybrid.stomp.Message;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;

public class StompManagement {
    private static final Logger log = LogManager.getLogger(StompManagement.class);
    private static List<Socket> disconnectedConnections = new ArrayList<Socket>();
    private static final byte[] COLON = new byte[]{58};
    private static final byte[] EOL = new byte[]{10};
    private static final byte[] EOM = new byte[]{0, 10, 10};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(Socket socket, OutputStream outputStream, InputStream inputStream) throws IOException {
        log.debug((Object)"close");
        Message message = new Message();
        message.setCommand("DISCONNECT");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("receipt", "disconnect");
        message.setHeaders(headers);
        StompManagement.send(message, outputStream);
        log.debug((Object)"Sent disconnect");
        Socket socket2 = socket;
        synchronized (socket2) {
            Message received;
            if (!disconnectedConnections.remove(socket) && (received = StompManagement.receive(socket, inputStream)) != null && received.getCommand().equals("ERROR")) {
                log.error((Object)("Did not receive the receipt for the disconnect:" + new String(received.getBody())));
            }
            disconnectedConnections.remove(socket);
        }
    }

    public static Socket connect(String host, int port, String username, String password) throws IOException, ConnectionException {
        Socket socket = new Socket(host, port);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("login", username);
        headers.put("passcode", password);
        Message message = new Message();
        message.setCommand("CONNECT");
        message.setHeaders(headers);
        StompManagement.send(message, outputStream);
        Message received = StompManagement.receive(socket, inputStream);
        if (received.getCommand().equals("ERROR")) {
            throw new ConnectionException(12, new String(received.getBody()));
        }
        log.debug((Object)("Created socket: " + socket + " input: " + inputStream + "output: " + outputStream));
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(Message message, OutputStream outputStream) throws IOException {
        log.trace((Object)("Writing on: " + outputStream));
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            outputStream.write(message.getCommand().getBytes());
            outputStream.write(EOL);
            for (Map.Entry<String, String> header : message.getHeaders().entrySet()) {
                outputStream.write(header.getKey().getBytes());
                outputStream.write(COLON);
                outputStream.write(header.getValue().getBytes());
                outputStream.write(EOL);
            }
            outputStream.write(EOL);
            if (message.getBody() != null) {
                outputStream.write(message.getBody());
            }
            outputStream.write(EOM);
        }
        log.trace((Object)("Wrote on: " + outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message receive(Socket socket, InputStream inputStream) throws IOException {
        Socket socket2 = socket;
        synchronized (socket2) {
            String header;
            log.trace((Object)("Reading from: " + inputStream));
            Message message = new Message();
            message.setCommand(StompManagement.readLine(inputStream));
            log.trace((Object)message.getCommand());
            HashMap<String, String> headers = new HashMap<String, String>();
            while ((header = StompManagement.readLine(inputStream)).length() > 0) {
                int sep = header.indexOf(58);
                if (sep <= 0) continue;
                String key = header.substring(0, sep);
                String value = header.substring(sep + 1, header.length());
                headers.put(key.trim(), value.trim());
                log.trace((Object)("Header: " + key + ":" + value));
            }
            message.setHeaders(headers);
            if (message.getCommand() != null) {
                if (message.getCommand().equals("RECEIPT")) {
                    if (message.getHeaders().get("receipt-id") != null && message.getHeaders().get("receipt-id").equals("disconnect")) {
                        log.debug((Object)("Read disconnect receipt from: " + inputStream));
                        disconnectedConnections.add(socket);
                        message = null;
                    } else {
                        log.trace((Object)("Read from: " + inputStream + " command was: " + message.getCommand()));
                    }
                    StompManagement.readLine(inputStream);
                    StompManagement.readLine(inputStream);
                } else if (!message.getCommand().equals("ERROR")) {
                    String contentLength = (String)headers.get("content-length");
                    if (contentLength != null) {
                        byte[] body = new byte[Integer.valueOf(contentLength).intValue()];
                        int offset = 0;
                        while (offset != body.length) {
                            offset = inputStream.read(body, offset, body.length - offset);
                        }
                        message.setBody(body);
                        log.trace((Object)("Read error: " + body));
                    }
                    StompManagement.readLine(inputStream);
                    StompManagement.readLine(inputStream);
                    log.trace((Object)("Read from: " + inputStream + " command was: " + message.getCommand()));
                } else {
                    message.setBody(((String)headers.get("message")).getBytes());
                    String read = null;
                    do {
                        if ((read = StompManagement.readLine(inputStream)) == null) continue;
                        log.debug((Object)read);
                    } while (read != null);
                    StompManagement.readLine(inputStream);
                    log.trace((Object)("Read from: " + inputStream + " command was: " + message.getCommand()));
                }
            } else {
                log.trace((Object)("Read from: " + inputStream + " null"));
                message = null;
            }
            return message;
        }
    }

    private static String readLine(InputStream inputStream) throws IOException {
        String toReturn = null;
        char[] read = new char[]{};
        char c = (char)inputStream.read();
        while (c != '\n' && c != '\u0000' && c != '\uffffffff') {
            char[] tmp = new char[read.length + 1];
            System.arraycopy(read, 0, tmp, 0, read.length);
            tmp[read.length] = c;
            read = tmp;
            c = (char)inputStream.read();
        }
        if (c == '\uffffffff') {
            throw new EOFException("Read the end of the stream");
        }
        if (c == '\u0000') {
            log.trace((Object)"returning null");
        } else {
            toReturn = new String(read);
            log.trace((Object)("returning: " + toReturn));
        }
        return toReturn;
    }
}

