/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.tx;

import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.ThreadUtil;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionImpl;

public class ThreadActionData {
    private static ThreadLocal _threadList = new ThreadLocal();

    public static TransactionImpl currentAction() {
        Stack txs = (Stack)_threadList.get();
        if (txs != null) {
            try {
                return (TransactionImpl)txs.peek();
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void pushAction(TransactionImpl a) {
        ThreadActionData.pushAction(a, true);
    }

    public static void pushAction(TransactionImpl a, boolean register) {
        Thread t = Thread.currentThread();
        Stack<TransactionImpl> txs = (Stack<TransactionImpl>)_threadList.get();
        if (txs == null) {
            txs = new Stack<TransactionImpl>();
            txs.push(a);
            _threadList.set(txs);
        } else {
            txs.push(a);
        }
        if (register) {
            a.addChildThread(t);
        }
    }

    public static void restoreActions(TransactionImpl act) {
        ThreadActionData.purgeActions();
        if (act != null) {
            Stack<TransactionImpl> s = new Stack<TransactionImpl>();
            s.push(act);
            for (TransactionImpl nextLevel = act.parent(); nextLevel != null; nextLevel = nextLevel.parent()) {
                s.push(nextLevel);
            }
            try {
                while (!s.empty()) {
                    ThreadActionData.pushAction((TransactionImpl)s.pop());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static TransactionImpl popAction() throws EmptyStackException {
        return ThreadActionData.popAction(ThreadUtil.getThreadId(), true);
    }

    public static TransactionImpl popAction(boolean unregister) throws EmptyStackException {
        return ThreadActionData.popAction(ThreadUtil.getThreadId(), unregister);
    }

    public static TransactionImpl popAction(String threadId) throws EmptyStackException {
        return ThreadActionData.popAction(threadId, true);
    }

    public static TransactionImpl popAction(String threadId, boolean unregister) throws EmptyStackException {
        Stack txs = (Stack)_threadList.get();
        if (txs != null) {
            TransactionImpl a = (TransactionImpl)txs.pop();
            if (a != null && unregister) {
                a.removeChildThread(threadId);
            }
            if (txs.size() == 0) {
                _threadList.set(null);
            }
            return a;
        }
        return null;
    }

    public static void purgeAction(TransactionImpl act) throws NoSuchElementException {
        ThreadActionData.purgeAction(act, Thread.currentThread(), true);
    }

    public static void purgeAction(TransactionImpl act, Thread t) throws NoSuchElementException {
        ThreadActionData.purgeAction(act, t, true);
    }

    public static void purgeAction(TransactionImpl act, Thread t, boolean unregister) throws NoSuchElementException {
        Stack txs;
        if (act != null && unregister) {
            act.removeChildThread(ThreadUtil.getThreadId(t));
        }
        if ((txs = (Stack)_threadList.get()) != null) {
            txs.removeElement(act);
            if (txs.size() == 0) {
                _threadList.set(null);
            }
        }
    }

    public static void purgeActions() {
        ThreadActionData.purgeActions(Thread.currentThread(), true);
    }

    public static void purgeActions(Thread t) {
        ThreadActionData.purgeActions(t, true);
    }

    public static void purgeActions(Thread t, boolean unregister) {
        Stack txs = (Stack)_threadList.get();
        _threadList.set(null);
        if (txs != null && unregister) {
            while (!txs.empty()) {
                TransactionImpl act = (TransactionImpl)txs.pop();
                if (act == null) continue;
                act.removeChildThread(ThreadUtil.getThreadId(t));
            }
        }
    }
}

