/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.xatmi.impl;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.ConfigurationException;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.EventListener;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Message;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Receiver;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Sender;
import org.jboss.narayana.blacktie.jatmibroker.core.transport.Transport;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionException;
import org.jboss.narayana.blacktie.jatmibroker.core.tx.TransactionImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Buffer;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ConnectionException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.ResponseException;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.Session;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.BufferImpl;
import org.jboss.narayana.blacktie.jatmibroker.xatmi.impl.ConnectionImpl;
import org.omg.CORBA.OBJECT_NOT_EXIST;

public class SessionImpl
implements Session {
    private static final Logger log = LogManager.getLogger(SessionImpl.class);
    private Transport transport;
    private int cd;
    private Sender sender;
    private Receiver receiver;
    private EventListener eventListener;
    private long lastEvent = -1L;
    private int lastRCode = 0;
    private boolean canSend = true;
    private boolean canRecv = true;
    private ConnectionImpl connection;
    private boolean closed;

    SessionImpl(ConnectionImpl connection, String serviceName, Transport transport, int cd) throws ConnectionException {
        log.debug((Object)("Creating a new client session: " + cd));
        this.connection = connection;
        this.transport = transport;
        this.cd = cd;
        this.eventListener = new EventListenerImpl(this);
        this.receiver = transport.createReceiver(cd, null, this.eventListener);
        this.sender = transport.getSender(serviceName, true);
        this.canSend = false;
        this.canRecv = true;
    }

    SessionImpl(ConnectionImpl connection, Transport transport, int cd, Object replyTo) throws ConnectionException {
        log.debug((Object)("Connecting a client session for the service: " + cd));
        this.connection = connection;
        this.transport = transport;
        this.cd = cd;
        this.eventListener = new EventListenerImpl(this);
        if (replyTo != null && !replyTo.equals("")) {
            this.sender = transport.createSender(replyTo);
        } else {
            log.trace((Object)"NO REPLY TO REQUIRED");
        }
        this.receiver = transport.createReceiver(this.sender);
        this.canRecv = false;
        this.canSend = true;
    }

    void setCreatorState(long flags) {
        if ((flags & 0x800L) == 2048L) {
            this.canSend = true;
            this.canRecv = false;
        } else if ((flags & 0x1000L) == 4096L) {
            this.canSend = false;
            this.canRecv = true;
        }
    }

    public void setCreatedState(long flags) {
        if ((flags & 0x800L) == 2048L) {
            this.canSend = false;
            this.canRecv = true;
        } else if ((flags & 0x1000L) == 4096L) {
            this.canSend = true;
            this.canRecv = false;
        }
    }

    public void close() throws ConnectionException {
        log.debug((Object)("Closing session: " + this.cd));
        if (this.closed) {
            throw new ConnectionException(9, "Session already closed");
        }
        if (this.sender != null) {
            log.debug((Object)"Sender closing");
            this.sender.close();
            this.sender = null;
        }
        if (this.receiver != null) {
            log.debug((Object)"Receiver closing");
            this.receiver.close();
            this.receiver = null;
        }
        this.connection.removeSession(this);
        this.closed = true;
        log.debug((Object)("Closed session: " + this.cd));
    }

    @Override
    public int tpsend(Buffer toSend, int flags) throws ConnectionException {
        log.debug((Object)("tpsend invoked: " + this.cd));
        if (this.closed) {
            throw new ConnectionException(9, "Session already closed");
        }
        int toReturn = -1;
        int toCheck = flags & 0xFFFFEFDC;
        if (toCheck != 0) {
            log.trace((Object)("invalid flags remain: " + toCheck));
            throw new ConnectionException(4, "Invalid flags remain: " + toCheck);
        }
        if (this.lastEvent > -1L) {
            throw new ResponseException(22, "Event existed on descriptor: " + this.lastEvent, this.lastEvent, this.lastRCode, null);
        }
        if (!this.canSend) {
            throw new ConnectionException(9, "Session can't send");
        }
        if (this.sender != null) {
            log.debug((Object)"Sender not null, sending");
            String type = null;
            String subtype = null;
            byte[] data = null;
            int len = 0;
            if (toSend != null) {
                data = ((BufferImpl)toSend).serialize();
                type = toSend.getType();
                subtype = toSend.getSubtype();
                len = toSend.getLen();
            }
            this.sender.send(this.receiver.getReplyTo(), (short)0, 0, data, len, this.cd, flags, 0, type, subtype);
            if ((flags & 0x1000) == 4096) {
                this.canSend = false;
                this.canRecv = true;
            }
        } else {
            throw new ConnectionException(9, "Session in receive mode");
        }
        toReturn = 0;
        return toReturn;
    }

    @Override
    public Buffer tprecv(int flags) throws ConnectionException, ConfigurationException {
        log.debug((Object)("Receiving: " + this.cd));
        if (this.closed) {
            throw new ConnectionException(9, "Session already closed");
        }
        int toCheck = flags & 0xFFFFFEDC;
        if (toCheck != 0) {
            log.trace((Object)("invalid flags remain: " + toCheck));
            throw new ConnectionException(4, "Invalid flags remain: " + toCheck);
        }
        if (!this.canRecv) {
            throw new ConnectionException(9, "Session can't receive");
        }
        Message m = this.receiver.receive(flags);
        if (m.replyTo == null || this.sender != null && !m.replyTo.equals(this.sender.getSendTo())) {
            log.trace((Object)"Send to location has altered");
            this.sender.close();
            this.sender = null;
        }
        if (this.sender == null && m.replyTo != null && !m.replyTo.equals("")) {
            log.trace((Object)"Will require a new sender");
            this.sender = ((String)m.replyTo).contains("IOR:") ? this.transport.createSender(m.replyTo) : this.transport.createSender(this.receiver);
        } else {
            log.debug((Object)"Not setting the sender");
        }
        BufferImpl received = null;
        if (m.type != null && !m.type.equals("")) {
            received = (BufferImpl)this.connection.tpalloc(m.type, m.subtype);
            received.deserialize(m.data);
        }
        log.debug((Object)"Prepared and ready to launch");
        if ((m.flags & 0x1000) == 4096) {
            this.canSend = true;
            this.canRecv = false;
        }
        if ((m.flags & 0x1000) == 4096) {
            throw new ResponseException(22, "Reporting send only event", 32L, m.rcode, received);
        }
        if (m.rval == 3) {
            this.close();
            throw new ResponseException(22, "Received a disconnect event", 1L, m.rcode, received);
        }
        if (m.rval == 2 || m.rval == 1) {
            log.debug((Object)("Completed session is being closed: " + this.cd));
            this.close();
            if (m.rval == 2) {
                throw new ResponseException(22, "Service completed successfully event", 8L, 0, received);
            }
            if (m.rcode == 10) {
                throw new ResponseException(22, "Service received an error", 2L, m.rcode, received);
            }
            throw new ResponseException(22, "Service received a fail", 4L, m.rcode, received);
        }
        return received;
    }

    @Override
    public void tpdiscon() throws ConnectionException {
        log.debug((Object)("tpdiscon: " + this.cd));
        if (this.closed) {
            throw new ConnectionException(9, "Session already closed");
        }
        if (this.sender == null) {
            throw new ConnectionException(9, "Session had no endpoint to respond to for tpdiscon");
        }
        if (TransactionImpl.current() != null) {
            try {
                TransactionImpl.current().rollback_only();
            }
            catch (TransactionException e) {
                throw new ConnectionException(12, "Could not mark transaction for rollback only");
            }
        }
        try {
            this.sender.send("", (short)3, 0, null, 0, this.cd, 0, 0, null, null);
        }
        catch (OBJECT_NOT_EXIST one) {
            log.warn((Object)"The disconnect called failed to notify the remote end");
            log.debug((Object)"The disconnect called failed to notify the remote end", (Throwable)one);
        }
        this.close();
    }

    int getCd() {
        return this.cd;
    }

    Receiver getReceiver() {
        return this.receiver;
    }

    public Sender getSender() {
        return this.sender;
    }

    private void setLastEvent(long lastEvent, int rcode) {
        log.debug((Object)("Set lastEvent: " + lastEvent + "lastRCode: " + this.lastRCode + " cd: " + this.cd));
        this.lastEvent = lastEvent;
        this.lastRCode = rcode;
    }

    Transport getTransport() {
        return this.transport;
    }

    private class EventListenerImpl
    implements EventListener {
        private SessionImpl session;

        public EventListenerImpl(SessionImpl session) {
            this.session = session;
        }

        @Override
        public void setLastEvent(long lastEvent, int rcode) {
            this.session.setLastEvent(lastEvent, rcode);
        }
    }
}

