/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.jatmibroker.core.conf;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.jatmibroker.core.conf.Machine;

public class Server {
    private static Logger log = LogManager.getLogger(Server.class);
    private List<Machine> machines = new ArrayList<Machine>();
    private String name;

    public Server(String name) {
        this.name = name;
    }

    public void addMachine(Machine machine) {
        this.machines.add(machine);
        machine.setServer(this);
    }

    public List<Machine> getLocalMachine() throws UnknownHostException {
        ArrayList<Machine> toReturn = new ArrayList<Machine>();
        String hostname = InetAddress.getLocalHost().getHostName();
        String ipAddress = InetAddress.getLocalHost().getHostAddress();
        String loopbackAddress = InetAddress.getLoopbackAddress().getHostAddress();
        log.info((Object)("Checking for host: " + hostname + " or ip: " + ipAddress + " or loopback: " + loopbackAddress));
        for (Machine next : this.machines) {
            log.debug((Object)("Checking against: " + next.getHostname() + " or ip: " + next.getIpAddress()));
            if (!hostname.equals(next.getHostname()) && !ipAddress.equals(next.getIpAddress()) && !loopbackAddress.equals(next.getIpAddress())) continue;
            toReturn.add(next);
        }
        return toReturn;
    }

    public String getName() {
        return this.name;
    }
}

