/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.blacktie.btadmin.commands;

import java.io.IOException;
import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jboss.narayana.blacktie.btadmin.Command;
import org.jboss.narayana.blacktie.btadmin.CommandFailedException;
import org.jboss.narayana.blacktie.btadmin.IncompatibleArgsException;

public class Advertise
implements Command {
    private static Logger log = LogManager.getLogger(Advertise.class);
    private String serverName;
    private String serviceName;

    public boolean requiresAdminConnection() {
        return true;
    }

    public String getExampleUsage() {
        return "<serverName> <serviceName>";
    }

    public void initializeArgs(String[] args) throws IncompatibleArgsException {
        this.serverName = args[0];
        this.serviceName = args[1];
    }

    public void invoke(MBeanServerConnection beanServerConnection, ObjectName blacktieAdmin, Properties configuration) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, CommandFailedException {
        Boolean result = (Boolean)beanServerConnection.invoke(blacktieAdmin, "advertise", new Object[]{this.serverName, this.serviceName}, new String[]{"java.lang.String", "java.lang.String"});
        if (!result.booleanValue()) {
            log.error((Object)"Service could not be advertised");
            throw new CommandFailedException(-1);
        }
        log.info((Object)"Service advertised");
    }
}

